"""add historyrun.task_id

Revision ID: 969d84257cac
Revises: c90a7c76e996
Create Date: 2025-05-13 11:17:22.089308

"""
import sqlalchemy as sa
from alembic import op


# revision identifiers, used by Alembic.
revision = "969d84257cac"
down_revision = "c90a7c76e996"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("historyrun", schema=None) as batch_op:
        batch_op.add_column(sa.Column("task_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            batch_op.f("fk_historyrun_task_id_taskv2"),
            "taskv2",
            ["task_id"],
            ["id"],
            ondelete="SET NULL",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("historyrun", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_historyrun_task_id_taskv2"), type_="foreignkey"
        )
        batch_op.drop_column("task_id")

    # ### end Alembic commands ###
