"""Add user_settings table

Revision ID: 9c5ae74c9b98
Revises: d9a140db5d42
Create Date: 2024-09-24 12:01:13.393326

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op


# revision identifiers, used by Alembic.
revision = "9c5ae74c9b98"
down_revision = "d9a140db5d42"
branch_labels = None
depends_on = None

# Manually define constraint name, see issue #1777
CONSTRAINT_NAME = "fk_user_oauth_user_settings_id_user_settings"


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "user_settings",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "slurm_accounts", sa.JSON(), server_default="[]", nullable=False
        ),
        sa.Column(
            "ssh_host", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "ssh_username", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "ssh_private_key_path",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=True,
        ),
        sa.Column(
            "ssh_tasks_dir", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "ssh_jobs_dir", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "slurm_user", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "cache_dir", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("user_oauth", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("user_settings_id", sa.Integer(), nullable=True)
        )
        batch_op.create_foreign_key(
            CONSTRAINT_NAME, "user_settings", ["user_settings_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("user_oauth", schema=None) as batch_op:
        batch_op.drop_constraint(CONSTRAINT_NAME, type_="foreignkey")
        batch_op.drop_column("user_settings_id")

    op.drop_table("user_settings")
    # ### end Alembic commands ###
