"""drop old filter columns

Revision ID: af8673379a5c
Revises: db09233ad13a
Create Date: 2025-01-30 14:44:04.302795

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "af8673379a5c"
down_revision = "db09233ad13a"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.drop_column("filters")

    with op.batch_alter_table("workflowtaskv2", schema=None) as batch_op:
        batch_op.drop_column("input_filters")

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("workflowtaskv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "input_filters",
                postgresql.JSON(astext_type=sa.Text()),
                server_default=sa.text("'null'::json"),
                autoincrement=False,
                nullable=True,
            )
        )

    with op.batch_alter_table("datasetv2", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "filters",
                postgresql.JSON(astext_type=sa.Text()),
                server_default=sa.text("'null'::json"),
                autoincrement=False,
                nullable=True,
            )
        )

    # ### end Alembic commands ###
