"""new history items

Revision ID: fbce16ff4e47
Revises: af1ef1c83c9b
Create Date: 2025-03-14 15:25:01.083619

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "fbce16ff4e47"
down_revision = "af1ef1c83c9b"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "historyrun",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("workflowtask_id", sa.Integer(), nullable=True),
        sa.Column(
            "workflowtask_dump",
            postgresql.JSONB(astext_type=sa.Text()),
            nullable=False,
        ),
        sa.Column(
            "task_group_dump",
            postgresql.JSONB(astext_type=sa.Text()),
            nullable=False,
        ),
        sa.Column(
            "timestamp_started", sa.DateTime(timezone=True), nullable=False
        ),
        sa.Column(
            "status", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("num_available_images", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["datasetv2.id"],
            name=op.f("fk_historyrun_dataset_id_datasetv2"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["workflowtask_id"],
            ["workflowtaskv2.id"],
            name=op.f("fk_historyrun_workflowtask_id_workflowtaskv2"),
            ondelete="SET NULL",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_historyrun")),
    )
    op.create_table(
        "historyunit",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("history_run_id", sa.Integer(), nullable=False),
        sa.Column(
            "logfile", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column(
            "status", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("zarr_urls", postgresql.ARRAY(sa.String()), nullable=True),
        sa.ForeignKeyConstraint(
            ["history_run_id"],
            ["historyrun.id"],
            name=op.f("fk_historyunit_history_run_id_historyrun"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_historyunit")),
    )
    op.create_table(
        "historyimagecache",
        sa.Column(
            "zarr_url", sqlmodel.sql.sqltypes.AutoString(), nullable=False
        ),
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("workflowtask_id", sa.Integer(), nullable=False),
        sa.Column("latest_history_unit_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["datasetv2.id"],
            name=op.f("fk_historyimagecache_dataset_id_datasetv2"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["latest_history_unit_id"],
            ["historyunit.id"],
            name=op.f(
                "fk_historyimagecache_latest_history_unit_id_historyunit"
            ),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["workflowtask_id"],
            ["workflowtaskv2.id"],
            name=op.f("fk_historyimagecache_workflowtask_id_workflowtaskv2"),
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint(
            "zarr_url",
            "dataset_id",
            "workflowtask_id",
            name=op.f("pk_historyimagecache"),
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("historyimagecache")
    op.drop_table("historyunit")
    op.drop_table("historyrun")
    # ### end Alembic commands ###
