import shortuuid
from fastapi.responses import JSONResponse
from .protocol import ErrorResponse

def uuid():
    return shortuuid.random()

def create_error(
        message: str,
        type: str,
        status: int = 500) -> JSONResponse:
    return JSONResponse(
        status_code=status,
        content=ErrorResponse(
            error={
                'message': message,
                'type': type,
            },
        ).model_dump(),
    )

def create_403_error(message: str = 'Request not allowed') -> JSONResponse:
    return create_error(
        message=message,
        type='forbidden',
        status=403,
    )


def create_404_error(message: str = 'Resource not found') -> JSONResponse:
    return create_error(
        message=message,
        type='not_found_error',
        status=404,
    )

def create_500_error(message: str) -> JSONResponse:
    return create_error(
        message=message,
        type='internal_error',
        status=500,
    )

def create_501_error(func: str) -> JSONResponse:
    return create_error(
        message=f'{func} not implemented',
        type='not_implemented',
        status=501,
    )
