"""This file contains metadata to help describe the results of LAMMPS
calculations, etc.
"""

metadata = {}

"""Properties that LAMMPS produces, depending on the type of calculation.
"""

metadata["results"] = {
    "energy": {
        "calculation": ["energy", "minimization"],
        "description": "The total energy",
        "dimensionality": "scalar",
        "property": "total energy#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "DfE0": {
        "description": "the energy of formation",
        "dimensionality": "scalar",
        "property": "DfE0#LAMMPS#{model}",
        "type": "float",
        "units": "kJ/mol",
        "format": ".2f",
    },
    "E atomization": {
        "description": "the energy of formation from atoms",
        "dimensionality": "scalar",
        "property": "E atomization#LAMMPS#{model}",
        "type": "float",
        "units": "kJ/mol",
        "format": ".2f",
    },
    "gradients": {
        "description": "The gradients",
        "dimensionality": "[3, n_atoms]",
        "property": "gradients#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol/Å",
    },
    "model": {
        "description": "The model used",
        "dimensionality": "scalar",
        "type": "string",
    },
    "DfH0_reax": {
        "calculation": ["energy", "minimization"],
        "description": "the Reax approximation to the enthalpy of formation",
        "dimensionality": "scalar",
        "property": "DfH0_reax#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
        "format": ".2f",
    },
    "T": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "temperature",
        "dimensionality": "scalar",
        "property": "temperature#LAMMPS#{model}",
        "type": "float",
        "units": "K",
    },
    "T,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of temperature",
        "dimensionality": "scalar",
        "property": "temperature, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "K",
    },
    "T,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of temperature",
        "dimensionality": "scalar",
        "property": "temperature, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "T,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of temperature sampling",
        "dimensionality": "scalar",
        "property": "temperature, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "P": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "pressure",
        "dimensionality": "scalar",
        "property": "pressure#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "P,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of pressure",
        "dimensionality": "scalar",
        "property": "pressure, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "P,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of pressure",
        "dimensionality": "scalar",
        "property": "pressure, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "P,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of pressure sampling",
        "dimensionality": "scalar",
        "property": "pressure, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "stress": {
        "description": "Stress Voigt vector",
        "dimensionality": "[6]",
        "property": "stress#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "stress,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of stress",
        "dimensionality": "[6]",
        "property": "stress, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "stress,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of stress",
        "dimensionality": "[6]",
        "property": "stress, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "stress,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of stress sampling",
        "dimensionality": "[6]",
        "property": "stress, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Sxx": {
        "description": "Sxx",
        "dimensionality": "scalar",
        "property": "Sxx#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Sxx,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of Sxx",
        "dimensionality": "scalar",
        "property": "Sxx, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Sxx,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of Sxx",
        "dimensionality": "scalar",
        "property": "Sxx, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Sxx,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of Sxx sampling",
        "dimensionality": "scalar",
        "property": "Sxx, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Syy": {
        "description": "Syy",
        "dimensionality": "scalar",
        "property": "Syy#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Syy,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of Syy",
        "dimensionality": "scalar",
        "property": "Syy, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Syy,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of Syy",
        "dimensionality": "scalar",
        "property": "Syy, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Syy,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of Syy sampling",
        "dimensionality": "scalar",
        "property": "Syy, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Szz": {
        "description": "Szz",
        "dimensionality": "scalar",
        "property": "Szz#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Szz,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of Szz",
        "dimensionality": "scalar",
        "property": "Szz, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Szz,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of Szz",
        "dimensionality": "scalar",
        "property": "Szz, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Szz,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of Szz sampling",
        "dimensionality": "scalar",
        "property": "Szz, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Sxy": {
        "description": "Sxy",
        "dimensionality": "scalar",
        "property": "Sxy#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Sxy,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of Sxy",
        "dimensionality": "scalar",
        "property": "Sxy, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Sxy,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of Sxy",
        "dimensionality": "scalar",
        "property": "Sxy, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Sxy,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of Sxy sampling",
        "dimensionality": "scalar",
        "property": "Sxy, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Sxz": {
        "description": "Sxz",
        "dimensionality": "scalar",
        "property": "Sxz#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Sxz,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of Sxz",
        "dimensionality": "scalar",
        "property": "Sxz, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Sxz,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of Sxz",
        "dimensionality": "scalar",
        "property": "Sxz, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Sxz,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of Sxz sampling",
        "dimensionality": "scalar",
        "property": "Sxz, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Syz": {
        "description": "Syz",
        "dimensionality": "scalar",
        "property": "Syz#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Syz,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of Syz",
        "dimensionality": "scalar",
        "property": "Syz, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "atm",
    },
    "Syz,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of Syz",
        "dimensionality": "scalar",
        "property": "Syz, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Syz,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of Syz sampling",
        "dimensionality": "scalar",
        "property": "Syz, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "density": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "density",
        "dimensionality": "scalar",
        "property": "density#LAMMPS#{model}",
        "type": "float",
        "units": "g/ml",
    },
    "density,stderr": {
        "calculation": ["npt"],
        "description": "stderr of density",
        "dimensionality": "scalar",
        "property": "density, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "g/ml",
    },
    "density,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of density",
        "dimensionality": "scalar",
        "property": "density, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "density,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of density sampling",
        "dimensionality": "scalar",
        "property": "density, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "V": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "V",
        "dimensionality": "scalar",
        "property": "volume#LAMMPS#{model}",
        "type": "float",
        "units": "g/ml",
    },
    "V,stderr": {
        "calculation": ["npt"],
        "description": "stderr of V",
        "dimensionality": "scalar",
        "property": "volume, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "g/ml",
    },
    "V,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of V",
        "dimensionality": "scalar",
        "property": "volume, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "V,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of V sampling",
        "dimensionality": "scalar",
        "property": "volume, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "a": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "cell parameter 'a'",
        "dimensionality": "scalar",
        "property": "cell_a#LAMMPS#{model}",
        "type": "float",
        "units": "Å",
    },
    "a,stderr": {
        "calculation": ["npt"],
        "description": "stderr of cell 'a'",
        "dimensionality": "scalar",
        "property": "cell_a, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "Å",
    },
    "a,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of cell 'a'",
        "dimensionality": "scalar",
        "property": "cell_a, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "a,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of cell 'a' sampling",
        "dimensionality": "scalar",
        "property": "cell_a, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "b": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "cell parameter 'b'",
        "dimensionality": "scalar",
        "property": "cell_b#LAMMPS#{model}",
        "type": "float",
        "units": "Å",
    },
    "b,stderr": {
        "calculation": ["npt"],
        "description": "stderr of cell 'b'",
        "dimensionality": "scalar",
        "property": "cell_b, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "Å",
    },
    "b,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of cell 'b'",
        "dimensionality": "scalar",
        "property": "cell_b, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "b,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of cell 'b' sampling",
        "dimensionality": "scalar",
        "property": "cell_b, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "c": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "cell parameter 'c'",
        "dimensionality": "scalar",
        "property": "cell_c#LAMMPS#{model}",
        "type": "float",
        "units": "Å",
    },
    "c,stderr": {
        "calculation": ["npt"],
        "description": "stderr of cell 'c'",
        "dimensionality": "scalar",
        "property": "cell_c, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "Å",
    },
    "c,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of cell 'c'",
        "dimensionality": "scalar",
        "property": "cell_c, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "c,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of cell 'c' sampling",
        "dimensionality": "scalar",
        "property": "cell_c, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "alpha": {
        "calculation": ["npt"],
        "description": "cell parameter 'alpha'",
        "dimensionality": "scalar",
        "property": "cell_alpha#LAMMPS#{model}",
        "type": "float",
        "units": "degree",
    },
    "alpha,stderr": {
        "calculation": ["npt"],
        "description": "stderr of cell 'alpha'",
        "dimensionality": "scalar",
        "property": "cell_alpha, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "degree",
    },
    "alpha,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of cell 'alpha'",
        "dimensionality": "scalar",
        "property": "cell_alpha, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "alpha,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of cell 'alpha' sampling",
        "dimensionality": "scalar",
        "property": "cell_alpha, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "beta": {
        "calculation": ["npt"],
        "description": "cell parameter 'beta'",
        "dimensionality": "scalar",
        "property": "cell_beta#LAMMPS#{model}",
        "type": "float",
        "units": "degree",
    },
    "beta,stderr": {
        "calculation": ["npt"],
        "description": "stderr of cell 'beta'",
        "dimensionality": "scalar",
        "property": "cell_beta, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "degree",
    },
    "beta,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of cell 'beta'",
        "dimensionality": "scalar",
        "property": "cell_beta, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "beta,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of cell 'beta' sampling",
        "dimensionality": "scalar",
        "property": "cell_beta, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "gamma": {
        "calculation": ["npt"],
        "description": "cell parameter 'gamma'",
        "dimensionality": "scalar",
        "property": "cell_gamma#LAMMPS#{model}",
        "type": "float",
        "units": "degree",
    },
    "gamma,stderr": {
        "calculation": ["npt"],
        "description": "stderr of cell 'gamma'",
        "dimensionality": "scalar",
        "property": "cell_gamma, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "degree",
    },
    "gamma,tau": {
        "calculation": ["npt"],
        "description": "autocorrelation time of cell 'gamma'",
        "dimensionality": "scalar",
        "property": "cell_gamma, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "gamma,inefficiency": {
        "calculation": ["npt"],
        "description": "statistical inefficiency of cell 'gamma' sampling",
        "dimensionality": "scalar",
        "property": "cell_gamma, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Etot": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "total energy",
        "dimensionality": "scalar",
        "property": "total energy#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "Etot,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of total energy",
        "dimensionality": "scalar",
        "property": "total energy, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "Etot,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of total energy",
        "dimensionality": "scalar",
        "property": "total energy, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Etot,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of total energy sampling",
        "dimensionality": "scalar",
        "property": "total energy, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Eke": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "kinetic energy",
        "dimensionality": "scalar",
        "property": "kinetic energy#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "Eke,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of kinetic energy",
        "dimensionality": "scalar",
        "property": "kinetic energy, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "Eke,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of kinetic energy",
        "dimensionality": "scalar",
        "property": "kinetic energy, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Eke,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of kinetic energy sampling",
        "dimensionality": "scalar",
        "property": "kinetic energy, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Epe": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "potential energy",
        "dimensionality": "scalar",
        "property": "potential energy#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "Epe,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of potential energy",
        "dimensionality": "scalar",
        "property": "potential energy, stderr#LAMMPS#{model}",
        "type": "float",
        "units": "kcal/mol",
    },
    "Epe,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of potential energy",
        "dimensionality": "scalar",
        "property": "potential energy, tau#LAMMPS#{model}",
        "type": "float",
        "units": "fs",
    },
    "Epe,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of potential energy sampling",
        "dimensionality": "scalar",
        "property": "potential energy, inefficiency#LAMMPS#{model}",
        "type": "float",
        "units": "",
    },
    "Epair": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "nonbonded (vdW & electrostatic) energy",
        "dimensionality": "scalar",
        "type": "float",
        "units": "kcal/mol",
    },
    "Epair,stderr": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "stderr of nonbond energy",
        "dimensionality": "scalar",
        "type": "float",
        "units": "kcal/mol",
    },
    "Epair,tau": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "autocorrelation time of nonbond energy",
        "dimensionality": "scalar",
        "type": "float",
        "units": "fs",
    },
    "Epair,inefficiency": {
        "calculation": [
            "nve",
            "nvt",
            "npt",
        ],
        "description": "statistical inefficiency of nonbond energy sampling",
        "dimensionality": "scalar",
        "type": "float",
        "units": "",
    },
    # Timings
    "t_lammps_wall": {
        "description": "The wall clock time for LAMMPS",
        "dimensionality": "scalar",
        "type": "float",
        "units": "s",
        "format": ".1f",
    },
    "SEAMM elapsed time": {
        "description": "total elapsed time for LAMMPS",
        "dimensionality": "scalar",
        "type": "float",
        "units": "s",
        "format": ".1f",
    },
    "SEAMM np": {
        "description": "number of processors for LAMMPS",
        "dimensionality": "scalar",
        "type": "integer",
        "format": "d",
    },
    "t_nve": {
        "calculation": ["nve"],
        "description": "The time for the NVE step",
        "dimensionality": "scalar",
        "type": "float",
        "units": "s",
    },
    "np_nve": {
        "calculation": ["nve"],
        "description": "The number of processors for the NVE step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "nsteps_nve": {
        "calculation": ["nve"],
        "description": "The number of steps in the NVE step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "natoms_nve": {
        "calculation": ["nve"],
        "description": "The number of atoms in the NVE step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "t_nvt": {
        "calculation": ["nvt"],
        "description": "The time for the NVT step",
        "dimensionality": "scalar",
        "type": "float",
        "units": "s",
    },
    "np_nvt": {
        "calculation": ["nvt"],
        "description": "The number of processors for the NVT step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "nsteps_nvt": {
        "calculation": ["nvt"],
        "description": "The number of steps in the NVT step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "natoms_nvt": {
        "calculation": ["nvt"],
        "description": "The number of atoms in the NVT step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "t_npt": {
        "calculation": ["npt"],
        "description": "The time for the NPT step",
        "dimensionality": "scalar",
        "type": "float",
        "units": "s",
    },
    "np_npt": {
        "calculation": ["npt"],
        "description": "The number of processors for the NPT step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "nsteps_npt": {
        "calculation": ["npt"],
        "description": "The number of steps in the NPT step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "natoms_npt": {
        "calculation": ["npt"],
        "description": "The number of atoms in the NPT step",
        "dimensionality": "scalar",
        "type": "integer",
        "units": "s",
    },
    "minimizer": {
        "calculation": ["minimization"],
        "description": "the minimizer used",
        "dimensionality": "scalar",
        "type": "string",
    },
    "optimization is converged": {
        "calculation": ["minimization"],
        "description": "whether the geometry optimization converged",
        "dimensionality": "scalar",
        "type": "boolean",
        "format": "s",
    },
    "N steps optimization": {
        "calculation": ["minimization"],
        "description": "number of optimization steps",
        "dimensionality": "scalar",
        "type": "integer",
    },
    "N force evaluations": {
        "calculation": ["minimization"],
        "description": "number of force evaluations",
        "dimensionality": "scalar",
        "type": "integer",
    },
    "energy change": {
        "calculation": ["minimization"],
        "description": "the last energy change",
        "dimensionality": "scalar",
        "type": "float",
        "units": "kcal/mol",
        "format": ".2f",
    },
    "energy change threshold": {
        "calculation": ["minimization"],
        "description": "the threshold for the energy change",
        "dimensionality": "scalar",
        "type": "float",
        "units": "kcal/mol/Å",
        "format": ".2f",
    },
    "force norm": {
        "calculation": ["minimization"],
        "description": "the l2 norm of the force vector",
        "dimensionality": "scalar",
        "type": "float",
        "units": "kcal/mol/Å",
        "format": ".2f",
    },
    "force norm threshold": {
        "calculation": ["minimization"],
        "description": "the l2 norm of the force vector threshold",
        "dimensionality": "scalar",
        "type": "float",
        "units": "kcal/mol/Å",
        "format": ".2f",
    },
    "RMSD": {
        "calculation": ["minimization"],
        "description": "RMSD with H removed",
        "dimensionality": "scalar",
        "type": "float",
        "units": "Å",
    },
    "displaced atom": {
        "calculation": ["minimization"],
        "description": "Atom index with largest displacement",
        "dimensionality": "scalar",
        "type": "int",
    },
    "maximum displacement": {
        "calculation": ["minimization"],
        "description": "Maximum displacement of an atom",
        "dimensionality": "scalar",
        "type": "float",
        "units": "Å",
    },
    "RMSD with H": {
        "calculation": ["minimization"],
        "description": "RMSD including H atoms",
        "dimensionality": "scalar",
        "type": "float",
        "units": "Å",
    },
    "displaced atom with H": {
        "calculation": ["minimization"],
        "description": "Atom index with largest displacement, including H",
        "dimensionality": "scalar",
        "type": "int",
    },
    "maximum displacement with H": {
        "calculation": ["minimization"],
        "description": "Maximum displacement of an atom, including H",
        "dimensionality": "scalar",
        "type": "float",
        "units": "Å",
    },
}
