"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.credential_purpose import CredentialPurpose
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_object_credential_existence_info_response import ListObjectCredentialExistenceInfoResponse
from agilicus_api.model.list_object_credentials_response import ListObjectCredentialsResponse
from agilicus_api.model.object_credential import ObjectCredential
from agilicus_api.model.object_type import ObjectType


class CredentialsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_object_credential(
            self,
            object_credential,
            **kwargs
        ):
            """Add an object_credential  # noqa: E501

            Adds an object_credential. Multiple credentials for a given purpose may exist for an object within an org. However, they must be distringuished by their priority. If one already exists for a given priority, a 409 will be returned.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_object_credential(object_credential, async_req=True)
            >>> result = thread.get()

            Args:
                object_credential (ObjectCredential):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectCredential
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_credential'] = \
                object_credential
            return self.call_with_http_info(**kwargs)

        if self.create_object_credential is None:
            self.create_object_credential = _Endpoint(
                settings={
                    'response_type': (ObjectCredential,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/object_credentials',
                    'operation_id': 'create_object_credential',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'object_credential',
                    ],
                    'required': [
                        'object_credential',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'object_credential':
                            (ObjectCredential,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'object_credential': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_object_credential
            )

        def __delete_object_credential(
            self,
            object_credential_id,
            **kwargs
        ):
            """Delete an object_credential  # noqa: E501

            Delete an object_credential  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_object_credential(object_credential_id, async_req=True)
            >>> result = thread.get()

            Args:
                object_credential_id (str): A credential ID

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_credential_id'] = \
                object_credential_id
            return self.call_with_http_info(**kwargs)

        if self.delete_object_credential is None:
            self.delete_object_credential = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/object_credentials/{object_credential_id}',
                    'operation_id': 'delete_object_credential',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'object_credential_id',
                        'org_id',
                    ],
                    'required': [
                        'object_credential_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'object_credential_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'object_credential_id': 'object_credential_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'object_credential_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_object_credential
            )

        def __get_object_credential(
            self,
            object_credential_id,
            **kwargs
        ):
            """Get an object_credential  # noqa: E501

            Get an object_credential  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_object_credential(object_credential_id, async_req=True)
            >>> result = thread.get()

            Args:
                object_credential_id (str): A credential ID

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectCredential
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_credential_id'] = \
                object_credential_id
            return self.call_with_http_info(**kwargs)

        if self.get_object_credential is None:
            self.get_object_credential = _Endpoint(
                settings={
                    'response_type': (ObjectCredential,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/object_credentials/{object_credential_id}',
                    'operation_id': 'get_object_credential',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'object_credential_id',
                        'org_id',
                    ],
                    'required': [
                        'object_credential_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'object_credential_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'object_credential_id': 'object_credential_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'object_credential_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_object_credential
            )

        def __list_object_credential_existence_info(
            self,
            **kwargs
        ):
            """List ObjectCredentialExistenceInfo  # noqa: E501

            List whether or not ObjectCredentials exist for the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_object_credential_existence_info(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                object_id (str): search by object id. [optional]
                object_type (ObjectType): An object type. [optional]
                object_types ([ObjectType]): A list of object types. Returns all items which match at least one of the types. . [optional]
                object_ids ([str]): A list of object IDs. Returns all items which match at least one of the . . [optional]
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                purpose (CredentialPurpose): The purpose of a credential. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListObjectCredentialExistenceInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_object_credential_existence_info is None:
            self.list_object_credential_existence_info = _Endpoint(
                settings={
                    'response_type': (ListObjectCredentialExistenceInfoResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/object_credentials/existence_info',
                    'operation_id': 'list_object_credential_existence_info',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'object_id',
                        'object_type',
                        'object_types',
                        'object_ids',
                        'org_ids',
                        'page_at_id',
                        'purpose',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'object_id':
                            (str,),
                        'object_type':
                            (ObjectType,),
                        'object_types':
                            ([ObjectType],),
                        'object_ids':
                            ([str],),
                        'org_ids':
                            ([str],),
                        'page_at_id':
                            (str,),
                        'purpose':
                            (CredentialPurpose,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'object_id': 'object_id',
                        'object_type': 'object_type',
                        'object_types': 'object_types',
                        'object_ids': 'object_ids',
                        'org_ids': 'org_ids',
                        'page_at_id': 'page_at_id',
                        'purpose': 'purpose',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'object_id': 'query',
                        'object_type': 'query',
                        'object_types': 'query',
                        'object_ids': 'query',
                        'org_ids': 'query',
                        'page_at_id': 'query',
                        'purpose': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                        'object_types': 'multi',
                        'object_ids': 'multi',
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_object_credential_existence_info
            )

        def __list_object_credentials(
            self,
            **kwargs
        ):
            """List all object_credentials  # noqa: E501

            List all object_credentials matching the provided query parameters. Perform keyset pagination by setting the page_at_id parameter to the id for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_object_credentials(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                object_id (str): search by object id. [optional]
                object_type (ObjectType): An object type. [optional]
                object_types ([ObjectType]): A list of object types. Returns all items which match at least one of the types. . [optional]
                object_ids ([str]): A list of object IDs. Returns all items which match at least one of the . . [optional]
                org_ids ([str]): The list of org ids to search for. Each org will be searched for independently.. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                encryption_key_id (str): query by the id of the key used to encrypt something. [optional]
                purpose (CredentialPurpose): The purpose of a credential. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListObjectCredentialsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_object_credentials is None:
            self.list_object_credentials = _Endpoint(
                settings={
                    'response_type': (ListObjectCredentialsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/object_credentials',
                    'operation_id': 'list_object_credentials',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'object_id',
                        'object_type',
                        'object_types',
                        'object_ids',
                        'org_ids',
                        'page_at_id',
                        'encryption_key_id',
                        'purpose',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'object_id':
                            (str,),
                        'object_type':
                            (ObjectType,),
                        'object_types':
                            ([ObjectType],),
                        'object_ids':
                            ([str],),
                        'org_ids':
                            ([str],),
                        'page_at_id':
                            (str,),
                        'encryption_key_id':
                            (str,),
                        'purpose':
                            (CredentialPurpose,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'object_id': 'object_id',
                        'object_type': 'object_type',
                        'object_types': 'object_types',
                        'object_ids': 'object_ids',
                        'org_ids': 'org_ids',
                        'page_at_id': 'page_at_id',
                        'encryption_key_id': 'encryption_key_id',
                        'purpose': 'purpose',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'object_id': 'query',
                        'object_type': 'query',
                        'object_types': 'query',
                        'object_ids': 'query',
                        'org_ids': 'query',
                        'page_at_id': 'query',
                        'encryption_key_id': 'query',
                        'purpose': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                        'object_types': 'multi',
                        'object_ids': 'multi',
                        'org_ids': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_object_credentials
            )

        def __replace_object_credential(
            self,
            object_credential_id,
            **kwargs
        ):
            """update an object_credential  # noqa: E501

            update an object_credential  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_object_credential(object_credential_id, async_req=True)
            >>> result = thread.get()

            Args:
                object_credential_id (str): A credential ID

            Keyword Args:
                object_credential (ObjectCredential): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ObjectCredential
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['object_credential_id'] = \
                object_credential_id
            return self.call_with_http_info(**kwargs)

        if self.replace_object_credential is None:
            self.replace_object_credential = _Endpoint(
                settings={
                    'response_type': (ObjectCredential,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/object_credentials/{object_credential_id}',
                    'operation_id': 'replace_object_credential',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'object_credential_id',
                        'object_credential',
                    ],
                    'required': [
                        'object_credential_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'object_credential_id':
                            (str,),
                        'object_credential':
                            (ObjectCredential,),
                    },
                    'attribute_map': {
                        'object_credential_id': 'object_credential_id',
                    },
                    'location_map': {
                        'object_credential_id': 'path',
                        'object_credential': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_object_credential
            )

    create_object_credential = None 
    delete_object_credential = None 
    get_object_credential = None 
    list_object_credential_existence_info = None 
    list_object_credentials = None 
    replace_object_credential = None 
