"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.api_key import APIKey
from agilicus_api.model.api_key_introspect import APIKeyIntrospect
from agilicus_api.model.api_key_introspect_response import APIKeyIntrospectResponse
from agilicus_api.model.api_key_op_status import APIKeyOpStatus
from agilicus_api.model.authentication_document import AuthenticationDocument
from agilicus_api.model.bulk_session_operation_response import BulkSessionOperationResponse
from agilicus_api.model.bulk_token_revoke import BulkTokenRevoke
from agilicus_api.model.bulk_token_revoke_response import BulkTokenRevokeResponse
from agilicus_api.model.create_session_and_token_request import CreateSessionAndTokenRequest
from agilicus_api.model.create_session_and_token_response import CreateSessionAndTokenResponse
from agilicus_api.model.create_token_request import CreateTokenRequest
from agilicus_api.model.create_user_data_token_request import CreateUserDataTokenRequest
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.identity_assertion import IdentityAssertion
from agilicus_api.model.identity_assertion_response import IdentityAssertionResponse
from agilicus_api.model.list_api_keys_response import ListAPIKeysResponse
from agilicus_api.model.list_authentication_document_response import ListAuthenticationDocumentResponse
from agilicus_api.model.list_jwks import ListJWKS
from agilicus_api.model.list_sessions_response import ListSessionsResponse
from agilicus_api.model.list_tokens_response import ListTokensResponse
from agilicus_api.model.many_org_token_introspect_response import ManyOrgTokenIntrospectResponse
from agilicus_api.model.raw_token import RawToken
from agilicus_api.model.refresh_token_request import RefreshTokenRequest
from agilicus_api.model.session import Session
from agilicus_api.model.session_challenge import SessionChallenge
from agilicus_api.model.token import Token
from agilicus_api.model.token_introspect import TokenIntrospect
from agilicus_api.model.token_reissue_request import TokenReissueRequest
from agilicus_api.model.token_revoke import TokenRevoke
from agilicus_api.model.user_session_identifiers import UserSessionIdentifiers


class TokensApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_api_key(
            self,
            api_key,
            **kwargs
        ):
            """Create an API Key  # noqa: E501

            Creates an API Key with the provided body. Note that the secret which serves as the key to provide access is only available when the API Key is created.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_api_key(api_key, async_req=True)
            >>> result = thread.get()

            Args:
                api_key (APIKey):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                APIKey
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['api_key'] = \
                api_key
            return self.call_with_http_info(**kwargs)

        if self.create_api_key is None:
            self.create_api_key = _Endpoint(
                settings={
                    'response_type': (APIKey,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/api_keys',
                    'operation_id': 'create_api_key',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'api_key',
                    ],
                    'required': [
                        'api_key',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'api_key':
                            (APIKey,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'api_key': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_api_key
            )

        def __create_api_key_introspection(
            self,
            api_key_introspect,
            **kwargs
        ):
            """Introspect an API Key  # noqa: E501

            Introspect an API Key to determine its permissions  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_api_key_introspection(api_key_introspect, async_req=True)
            >>> result = thread.get()

            Args:
                api_key_introspect (APIKeyIntrospect): API Key to introspect

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                APIKeyIntrospectResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['api_key_introspect'] = \
                api_key_introspect
            return self.call_with_http_info(**kwargs)

        if self.create_api_key_introspection is None:
            self.create_api_key_introspection = _Endpoint(
                settings={
                    'response_type': (APIKeyIntrospectResponse,),
                    'auth': [],
                    'endpoint_path': '/v1/api_keys/introspect',
                    'operation_id': 'create_api_key_introspection',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'api_key_introspect',
                    ],
                    'required': [
                        'api_key_introspect',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'api_key_introspect':
                            (APIKeyIntrospect,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'api_key_introspect': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_api_key_introspection
            )

        def __create_authentication_document(
            self,
            authentication_document,
            **kwargs
        ):
            """Create a authentication document  # noqa: E501

            Creates an authentication document with the provided body  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_authentication_document(authentication_document, async_req=True)
            >>> result = thread.get()

            Args:
                authentication_document (AuthenticationDocument):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuthenticationDocument
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['authentication_document'] = \
                authentication_document
            return self.call_with_http_info(**kwargs)

        if self.create_authentication_document is None:
            self.create_authentication_document = _Endpoint(
                settings={
                    'response_type': (AuthenticationDocument,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/authentication_documents',
                    'operation_id': 'create_authentication_document',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'authentication_document',
                    ],
                    'required': [
                        'authentication_document',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'authentication_document':
                            (AuthenticationDocument,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'authentication_document': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_authentication_document
            )

        def __create_bulk_delete_session_task(
            self,
            user_session_identifiers,
            **kwargs
        ):
            """Delete a set of sessions  # noqa: E501

            Delete a set of sessions. The body parameters determine the set of sessions  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_bulk_delete_session_task(user_session_identifiers, async_req=True)
            >>> result = thread.get()

            Args:
                user_session_identifiers (UserSessionIdentifiers): The identifying information for which sessions to delete

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkSessionOperationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_session_identifiers'] = \
                user_session_identifiers
            return self.call_with_http_info(**kwargs)

        if self.create_bulk_delete_session_task is None:
            self.create_bulk_delete_session_task = _Endpoint(
                settings={
                    'response_type': (BulkSessionOperationResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions/bulk_delete',
                    'operation_id': 'create_bulk_delete_session_task',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_session_identifiers',
                    ],
                    'required': [
                        'user_session_identifiers',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_session_identifiers':
                            (UserSessionIdentifiers,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'user_session_identifiers': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_bulk_delete_session_task
            )

        def __create_bulk_revoke_session_task(
            self,
            user_session_identifiers,
            **kwargs
        ):
            """Revoke a set of sessions  # noqa: E501

            Revoke a set of sessions. The body parameters determine the set of sessions  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_bulk_revoke_session_task(user_session_identifiers, async_req=True)
            >>> result = thread.get()

            Args:
                user_session_identifiers (UserSessionIdentifiers): The identifying information for which sessions to revoke

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkSessionOperationResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_session_identifiers'] = \
                user_session_identifiers
            return self.call_with_http_info(**kwargs)

        if self.create_bulk_revoke_session_task is None:
            self.create_bulk_revoke_session_task = _Endpoint(
                settings={
                    'response_type': (BulkSessionOperationResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions/bulk_revoke',
                    'operation_id': 'create_bulk_revoke_session_task',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_session_identifiers',
                    ],
                    'required': [
                        'user_session_identifiers',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_session_identifiers':
                            (UserSessionIdentifiers,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'user_session_identifiers': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_bulk_revoke_session_task
            )

        def __create_bulk_revoke_token_task(
            self,
            bulk_token_revoke,
            **kwargs
        ):
            """Revoke a set of tokens  # noqa: E501

            Revoke a set of tokens. The body parameters determine the set of tokens  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_bulk_revoke_token_task(bulk_token_revoke, async_req=True)
            >>> result = thread.get()

            Args:
                bulk_token_revoke (BulkTokenRevoke): Token to revoke

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                BulkTokenRevokeResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['bulk_token_revoke'] = \
                bulk_token_revoke
            return self.call_with_http_info(**kwargs)

        if self.create_bulk_revoke_token_task is None:
            self.create_bulk_revoke_token_task = _Endpoint(
                settings={
                    'response_type': (BulkTokenRevokeResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/tokens/bulk_revoke',
                    'operation_id': 'create_bulk_revoke_token_task',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'bulk_token_revoke',
                    ],
                    'required': [
                        'bulk_token_revoke',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'bulk_token_revoke':
                            (BulkTokenRevoke,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'bulk_token_revoke': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_bulk_revoke_token_task
            )

        def __create_introspect_token(
            self,
            token_introspect,
            **kwargs
        ):
            """Introspect a token  # noqa: E501

            Introspect a token  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_introspect_token(token_introspect, async_req=True)
            >>> result = thread.get()

            Args:
                token_introspect (TokenIntrospect): Token to introspect

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Token
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_introspect'] = \
                token_introspect
            return self.call_with_http_info(**kwargs)

        if self.create_introspect_token is None:
            self.create_introspect_token = _Endpoint(
                settings={
                    'response_type': (Token,),
                    'auth': [],
                    'endpoint_path': '/v1/tokens/introspect',
                    'operation_id': 'create_introspect_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'token_introspect',
                    ],
                    'required': [
                        'token_introspect',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'token_introspect':
                            (TokenIntrospect,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'token_introspect': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_introspect_token
            )

        def __create_introspect_token_all_sub_orgs(
            self,
            token_introspect,
            **kwargs
        ):
            """Introspect a token in all sub orgs  # noqa: E501

            Introspect a token in all sub orgs  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_introspect_token_all_sub_orgs(token_introspect, async_req=True)
            >>> result = thread.get()

            Args:
                token_introspect (TokenIntrospect): Token to introspect

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ManyOrgTokenIntrospectResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_introspect'] = \
                token_introspect
            return self.call_with_http_info(**kwargs)

        if self.create_introspect_token_all_sub_orgs is None:
            self.create_introspect_token_all_sub_orgs = _Endpoint(
                settings={
                    'response_type': (ManyOrgTokenIntrospectResponse,),
                    'auth': [],
                    'endpoint_path': '/v1/tokens/introspect_all_sub_orgs',
                    'operation_id': 'create_introspect_token_all_sub_orgs',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'token_introspect',
                    ],
                    'required': [
                        'token_introspect',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'token_introspect':
                            (TokenIntrospect,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'token_introspect': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_introspect_token_all_sub_orgs
            )

        def __create_reissued_token(
            self,
            token_reissue_request,
            **kwargs
        ):
            """Issue a new token from another  # noqa: E501

            Issues a new token with the same or reduced scope to the one presented. Use this to retrieve a token for accessing a different organisation than the one you're currently operating on. Note that the presented token remains valid if it already was. If it is not valid, or the you do not have permissions in the requested organisation, the request will fail. The token will expire at the same time as the presented token.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_reissued_token(token_reissue_request, async_req=True)
            >>> result = thread.get()

            Args:
                token_reissue_request (TokenReissueRequest): The token request

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RawToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_reissue_request'] = \
                token_reissue_request
            return self.call_with_http_info(**kwargs)

        if self.create_reissued_token is None:
            self.create_reissued_token = _Endpoint(
                settings={
                    'response_type': (RawToken,),
                    'auth': [],
                    'endpoint_path': '/v1/tokens/reissue',
                    'operation_id': 'create_reissued_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'token_reissue_request',
                    ],
                    'required': [
                        'token_reissue_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'token_reissue_request':
                            (TokenReissueRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'token_reissue_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_reissued_token
            )

        def __create_revoke_token_task(
            self,
            token_revoke,
            **kwargs
        ):
            """Revoke a token  # noqa: E501

            Revoke a token  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_revoke_token_task(token_revoke, async_req=True)
            >>> result = thread.get()

            Args:
                token_revoke (TokenRevoke): Token to revoke

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['token_revoke'] = \
                token_revoke
            return self.call_with_http_info(**kwargs)

        if self.create_revoke_token_task is None:
            self.create_revoke_token_task = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [],
                    'endpoint_path': '/v1/tokens/revoke',
                    'operation_id': 'create_revoke_token_task',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'token_revoke',
                    ],
                    'required': [
                        'token_revoke',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'token_revoke':
                            (TokenRevoke,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'token_revoke': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_revoke_token_task
            )

        def __create_session(
            self,
            session,
            **kwargs
        ):
            """Create a session  # noqa: E501

            Create a session  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_session(session, async_req=True)
            >>> result = thread.get()

            Args:
                session (Session):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Session
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session'] = \
                session
            return self.call_with_http_info(**kwargs)

        if self.create_session is None:
            self.create_session = _Endpoint(
                settings={
                    'response_type': (Session,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions',
                    'operation_id': 'create_session',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'session',
                    ],
                    'required': [
                        'session',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'session':
                            (Session,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'session': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_session
            )

        def __create_session_and_token(
            self,
            create_session_and_token_response,
            **kwargs
        ):
            """Create a session and a token associated with the session  # noqa: E501

            Create a session and a token associated with the session  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_session_and_token(create_session_and_token_response, async_req=True)
            >>> result = thread.get()

            Args:
                create_session_and_token_response (CreateSessionAndTokenResponse):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateSessionAndTokenRequest
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_session_and_token_response'] = \
                create_session_and_token_response
            return self.call_with_http_info(**kwargs)

        if self.create_session_and_token is None:
            self.create_session_and_token = _Endpoint(
                settings={
                    'response_type': (CreateSessionAndTokenRequest,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions/create_session_and_token',
                    'operation_id': 'create_session_and_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'create_session_and_token_response',
                    ],
                    'required': [
                        'create_session_and_token_response',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'create_session_and_token_response':
                            (CreateSessionAndTokenResponse,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'create_session_and_token_response': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_session_and_token
            )

        def __create_session_challenge(
            self,
            session_challenge,
            **kwargs
        ):
            """Create a user challenge request for a session  # noqa: E501

            Create a user challenge request for a session  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_session_challenge(session_challenge, async_req=True)
            >>> result = thread.get()

            Args:
                session_challenge (SessionChallenge): session challenge

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SessionChallenge
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_challenge'] = \
                session_challenge
            return self.call_with_http_info(**kwargs)

        if self.create_session_challenge is None:
            self.create_session_challenge = _Endpoint(
                settings={
                    'response_type': (SessionChallenge,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/session_challenges',
                    'operation_id': 'create_session_challenge',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'session_challenge',
                    ],
                    'required': [
                        'session_challenge',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'session_challenge':
                            (SessionChallenge,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'session_challenge': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_session_challenge
            )

        def __create_token(
            self,
            create_token_request,
            **kwargs
        ):
            """Create a token  # noqa: E501

            Create a token  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_token(create_token_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_token_request (CreateTokenRequest): Rule to sign

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RawToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_token_request'] = \
                create_token_request
            return self.call_with_http_info(**kwargs)

        if self.create_token is None:
            self.create_token = _Endpoint(
                settings={
                    'response_type': (RawToken,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/tokens',
                    'operation_id': 'create_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'create_token_request',
                    ],
                    'required': [
                        'create_token_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'create_token_request':
                            (CreateTokenRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'create_token_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_token
            )

        def __create_token_validation(
            self,
            create_token_request,
            **kwargs
        ):
            """Validate a token request  # noqa: E501

            Validate a token request prior to creating a token. This verifies the user has permission to access the scopes requested  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_token_validation(create_token_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_token_request (CreateTokenRequest): Token to validate

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CreateTokenRequest
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_token_request'] = \
                create_token_request
            return self.call_with_http_info(**kwargs)

        if self.create_token_validation is None:
            self.create_token_validation = _Endpoint(
                settings={
                    'response_type': (CreateTokenRequest,),
                    'auth': [],
                    'endpoint_path': '/v1/tokens/validations',
                    'operation_id': 'create_token_validation',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'create_token_request',
                    ],
                    'required': [
                        'create_token_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'create_token_request':
                            (CreateTokenRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'create_token_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_token_validation
            )

        def __create_user_data_token(
            self,
            create_user_data_token_request,
            **kwargs
        ):
            """Create a User Data Token  # noqa: E501

            User Data tokens allow a signed in user to create specific claims that can be shared with another party that can be cryptographically verified.  The resulting RawToken can be cryptographically verified with /v1/user_data_tokens/jwks   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_user_data_token(create_user_data_token_request, async_req=True)
            >>> result = thread.get()

            Args:
                create_user_data_token_request (CreateUserDataTokenRequest): claims to sign

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RawToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['create_user_data_token_request'] = \
                create_user_data_token_request
            return self.call_with_http_info(**kwargs)

        if self.create_user_data_token is None:
            self.create_user_data_token = _Endpoint(
                settings={
                    'response_type': (RawToken,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/user_data_tokens',
                    'operation_id': 'create_user_data_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'create_user_data_token_request',
                    ],
                    'required': [
                        'create_user_data_token_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'create_user_data_token_request':
                            (CreateUserDataTokenRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'create_user_data_token_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_user_data_token
            )

        def __delete_api_key(
            self,
            api_key_id,
            **kwargs
        ):
            """Delete an API Key  # noqa: E501

            Deletes the requested API Key  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_api_key(api_key_id, async_req=True)
            >>> result = thread.get()

            Args:
                api_key_id (str): An API Key ID found in a path

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['api_key_id'] = \
                api_key_id
            return self.call_with_http_info(**kwargs)

        if self.delete_api_key is None:
            self.delete_api_key = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/api_keys/{api_key_id}',
                    'operation_id': 'delete_api_key',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'api_key_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'api_key_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'api_key_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'api_key_id': 'api_key_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'api_key_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_api_key
            )

        def __delete_authentication_document(
            self,
            document_id,
            **kwargs
        ):
            """Delete a authentication document  # noqa: E501

            Deletes the requested authentication document  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_authentication_document(document_id, async_req=True)
            >>> result = thread.get()

            Args:
                document_id (str): Authetication document path

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['document_id'] = \
                document_id
            return self.call_with_http_info(**kwargs)

        if self.delete_authentication_document is None:
            self.delete_authentication_document = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/authentication_documents/{document_id}',
                    'operation_id': 'delete_authentication_document',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'document_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'document_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'document_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'document_id': 'document_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'document_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_authentication_document
            )

        def __delete_session(
            self,
            session_id,
            **kwargs
        ):
            """Delete a session  # noqa: E501

            Deletes the requested session  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_session(session_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): A login session identifier

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_id'] = \
                session_id
            return self.call_with_http_info(**kwargs)

        if self.delete_session is None:
            self.delete_session = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions/{session_id}',
                    'operation_id': 'delete_session',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'session_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'session_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'session_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'session_id': 'session_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'session_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_session
            )

        def __get_api_key(
            self,
            api_key_id,
            **kwargs
        ):
            """Get an API Key  # noqa: E501

            Gets the requested API Key  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_api_key(api_key_id, async_req=True)
            >>> result = thread.get()

            Args:
                api_key_id (str): An API Key ID found in a path

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                APIKey
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['api_key_id'] = \
                api_key_id
            return self.call_with_http_info(**kwargs)

        if self.get_api_key is None:
            self.get_api_key = _Endpoint(
                settings={
                    'response_type': (APIKey,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/api_keys/{api_key_id}',
                    'operation_id': 'get_api_key',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'api_key_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'api_key_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'api_key_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'api_key_id': 'api_key_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'api_key_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_api_key
            )

        def __get_authentication_document(
            self,
            document_id,
            **kwargs
        ):
            """Get a authentication document  # noqa: E501

            Gets the requested authentication document  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_authentication_document(document_id, async_req=True)
            >>> result = thread.get()

            Args:
                document_id (str): Authetication document path

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AuthenticationDocument
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['document_id'] = \
                document_id
            return self.call_with_http_info(**kwargs)

        if self.get_authentication_document is None:
            self.get_authentication_document = _Endpoint(
                settings={
                    'response_type': (AuthenticationDocument,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/authentication_documents/{document_id}',
                    'operation_id': 'get_authentication_document',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'document_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'document_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'document_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'document_id': 'document_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'document_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_authentication_document
            )

        def __get_jwks(
            self,
            **kwargs
        ):
            """Return JSON Web Key Set (JWKS)  # noqa: E501

            Return a list of JSON object that represents a cryptographic key. The members of the object represent properties of the key, including its value.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_jwks(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListJWKS
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_jwks is None:
            self.get_jwks = _Endpoint(
                settings={
                    'response_type': (ListJWKS,),
                    'auth': [],
                    'endpoint_path': '/v1/tokens/jwsk',
                    'operation_id': 'get_jwks',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_jwks
            )

        def __get_session(
            self,
            session_id,
            **kwargs
        ):
            """Get a session  # noqa: E501

            Gets the requested session  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_session(session_id, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): A login session identifier

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Session
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_id'] = \
                session_id
            return self.call_with_http_info(**kwargs)

        if self.get_session is None:
            self.get_session = _Endpoint(
                settings={
                    'response_type': (Session,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions/{session_id}',
                    'operation_id': 'get_session',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'session_id',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'session_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'session_id':
                            (str,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'session_id': 'session_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'session_id': 'path',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_session
            )

        def __get_token(
            self,
            **kwargs
        ):
            """introspect token  # noqa: E501

            \"introspect a token that is provided via the bearer authorization header\"   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_token(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                exclude_roles (bool): Excludes complex role information from a token query. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Token
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_token is None:
            self.get_token = _Endpoint(
                settings={
                    'response_type': (Token,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/tokens/introspect_self',
                    'operation_id': 'get_token',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'exclude_roles',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'exclude_roles':
                            (bool,),
                    },
                    'attribute_map': {
                        'exclude_roles': 'exclude_roles',
                    },
                    'location_map': {
                        'exclude_roles': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_token
            )

        def __get_user_data_jwks(
            self,
            **kwargs
        ):
            """Return JSON Web Key Set (JWKS)  # noqa: E501

            Return a list of JSON object that represents a cryptographic key. The members of the object represent properties of the key, including its value.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_user_data_jwks(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListJWKS
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_user_data_jwks is None:
            self.get_user_data_jwks = _Endpoint(
                settings={
                    'response_type': (ListJWKS,),
                    'auth': [],
                    'endpoint_path': '/v1/user_data_tokens/jwks',
                    'operation_id': 'get_user_data_jwks',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_user_data_jwks
            )

        def __list_api_keys(
            self,
            **kwargs
        ):
            """List API Keys  # noqa: E501

            Lists API Keys according to query parameters  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_api_keys(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                search_direction (str): Direction which the search should go starting from the email_nullable_query parameter. . [optional] if omitted the server will use the default value of "forwards"
                api_key_op_status (APIKeyOpStatus): Filters the api keys to only those with an operational status in the provided list. . [optional]
                sort_order (str): Whether to sort results ascending or descending. The default behaviour is ascending. . [optional] if omitted the server will use the default value of "ascending"
                page_at_created_date (datetime, none_type): Pagination based query with the created date as the key. To get the initial entries supply a null value. On subsequent requests, supply the `page_at_created_date` field from the list response. . [optional]
                not_api_key_op_status (APIKeyOpStatus): Filters the api keys to only those without an operational status in the provided list. . [optional]
                label (str): Filters based on whether or not the items in the collection have the given label. . [optional]
                valid_at (str): Search criteria for finding api_keys that are valid (not expired) at specific time * In UTC. * Supports human-friendly values. * Example, find all valid certificates as of now:  valid_at=\"now\" . [optional]
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                scopes ([str]): Query a token containing scopes, case insensitive. The scope can be specific or wildcarded with '%'. This string is passed in the SQL search with ilike. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAPIKeysResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_api_keys is None:
            self.list_api_keys = _Endpoint(
                settings={
                    'response_type': (ListAPIKeysResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/api_keys',
                    'operation_id': 'list_api_keys',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'org_id',
                        'search_direction',
                        'api_key_op_status',
                        'sort_order',
                        'page_at_created_date',
                        'not_api_key_op_status',
                        'label',
                        'valid_at',
                        'name',
                        'scopes',
                    ],
                    'required': [],
                    'nullable': [
                        'page_at_created_date',
                    ],
                    'enum': [
                        'search_direction',
                        'sort_order',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('search_direction',): {

                            "BACKWARDS": "backwards",
                            "FORWARDS": "forwards"
                        },
                        ('sort_order',): {

                            "ASCENDING": "ascending",
                            "DESCENDING": "descending"
                        },
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'search_direction':
                            (str,),
                        'api_key_op_status':
                            (APIKeyOpStatus,),
                        'sort_order':
                            (str,),
                        'page_at_created_date':
                            (datetime, none_type,),
                        'not_api_key_op_status':
                            (APIKeyOpStatus,),
                        'label':
                            (str,),
                        'valid_at':
                            (str,),
                        'name':
                            (str,),
                        'scopes':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                        'search_direction': 'search_direction',
                        'api_key_op_status': 'api_key_op_status',
                        'sort_order': 'sort_order',
                        'page_at_created_date': 'page_at_created_date',
                        'not_api_key_op_status': 'not_api_key_op_status',
                        'label': 'label',
                        'valid_at': 'valid_at',
                        'name': 'name',
                        'scopes': 'scopes',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'org_id': 'query',
                        'search_direction': 'query',
                        'api_key_op_status': 'query',
                        'sort_order': 'query',
                        'page_at_created_date': 'query',
                        'not_api_key_op_status': 'query',
                        'label': 'query',
                        'valid_at': 'query',
                        'name': 'query',
                        'scopes': 'query',
                    },
                    'collection_format_map': {
                        'scopes': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_api_keys
            )

        def __list_authentication_documents(
            self,
            **kwargs
        ):
            """List authentication documents  # noqa: E501

            Lists authentication documents according to query parameters  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_authentication_documents(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListAuthenticationDocumentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_authentication_documents is None:
            self.list_authentication_documents = _Endpoint(
                settings={
                    'response_type': (ListAuthenticationDocumentResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/authentication_documents',
                    'operation_id': 'list_authentication_documents',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_authentication_documents
            )

        def __list_sessions(
            self,
            **kwargs
        ):
            """List Sessions  # noqa: E501

            Lists Sessions according to query parameters  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_sessions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                revoked (bool): Query a session or token based on its revocation status. [optional]
                created_time (datetime): Query based on the created time. Any records created after this date will be returned.. [optional]
                previous_created_time (datetime): Pagination based query with the created time as the key. To get the initial entries supply an empty string. This is typically combined with another pagination key to form a composite pagination key. In that case the resulting dataset from the first key is then sub-paginated with this key.. [optional]
                previous_user_id (str): Pagination based query with the user's id as the key. To get the initial entries supply an empty string.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListSessionsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_sessions is None:
            self.list_sessions = _Endpoint(
                settings={
                    'response_type': (ListSessionsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions',
                    'operation_id': 'list_sessions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                        'org_id',
                        'revoked',
                        'created_time',
                        'previous_created_time',
                        'previous_user_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'revoked':
                            (bool,),
                        'created_time':
                            (datetime,),
                        'previous_created_time':
                            (datetime,),
                        'previous_user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                        'revoked': 'revoked',
                        'created_time': 'created_time',
                        'previous_created_time': 'previous_created_time',
                        'previous_user_id': 'previous_user_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                        'org_id': 'query',
                        'revoked': 'query',
                        'created_time': 'query',
                        'previous_created_time': 'query',
                        'previous_user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_sessions
            )

        def __list_tokens(
            self,
            **kwargs
        ):
            """Query tokens  # noqa: E501

            Query tokens  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_tokens(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 100
                sub (str): search criteria sub. [optional]
                exp_from (str): search criteria expired from using dateparser. [optional]
                exp_to (str): search criteria expired to using dateparser. [optional]
                iat_from (str): search criteria issued from using dateparser. [optional]
                iat_to (str): search criteria issued to using dateparser. [optional]
                jti (str): search criteria using jti. [optional]
                org (str): search criteria using org. [optional]
                revoked (bool): search criteria for revoked tokens. [optional]
                session (str): search criteria using session. [optional]
                scopes ([str]): Query a token containing scopes, case insensitive. The scope can be specific or wildcarded with '%'. This string is passed in the SQL search with ilike. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTokensResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_tokens is None:
            self.list_tokens = _Endpoint(
                settings={
                    'response_type': (ListTokensResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/tokens',
                    'operation_id': 'list_tokens',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'sub',
                        'exp_from',
                        'exp_to',
                        'iat_from',
                        'iat_to',
                        'jti',
                        'org',
                        'revoked',
                        'session',
                        'scopes',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 100,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'sub':
                            (str,),
                        'exp_from':
                            (str,),
                        'exp_to':
                            (str,),
                        'iat_from':
                            (str,),
                        'iat_to':
                            (str,),
                        'jti':
                            (str,),
                        'org':
                            (str,),
                        'revoked':
                            (bool,),
                        'session':
                            (str,),
                        'scopes':
                            ([str],),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'sub': 'sub',
                        'exp_from': 'exp_from',
                        'exp_to': 'exp_to',
                        'iat_from': 'iat_from',
                        'iat_to': 'iat_to',
                        'jti': 'jti',
                        'org': 'org',
                        'revoked': 'revoked',
                        'session': 'session',
                        'scopes': 'scopes',
                    },
                    'location_map': {
                        'limit': 'query',
                        'sub': 'query',
                        'exp_from': 'query',
                        'exp_to': 'query',
                        'iat_from': 'query',
                        'iat_to': 'query',
                        'jti': 'query',
                        'org': 'query',
                        'revoked': 'query',
                        'session': 'query',
                        'scopes': 'query',
                    },
                    'collection_format_map': {
                        'scopes': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_tokens
            )

        def __refresh_token(
            self,
            refresh_token_request,
            **kwargs
        ):
            """Refresh a token  # noqa: E501

            Refresh a token  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_token(refresh_token_request, async_req=True)
            >>> result = thread.get()

            Args:
                refresh_token_request (RefreshTokenRequest): RefreshTokenRequest

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RawToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['refresh_token_request'] = \
                refresh_token_request
            return self.call_with_http_info(**kwargs)

        if self.refresh_token is None:
            self.refresh_token = _Endpoint(
                settings={
                    'response_type': (RawToken,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/tokens/refresh',
                    'operation_id': 'refresh_token',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'refresh_token_request',
                    ],
                    'required': [
                        'refresh_token_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'refresh_token_request':
                            (RefreshTokenRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'refresh_token_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__refresh_token
            )

        def __replace_api_key(
            self,
            api_key_id,
            api_key,
            **kwargs
        ):
            """Update an API key  # noqa: E501

            Update an API key  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_api_key(api_key_id, api_key, async_req=True)
            >>> result = thread.get()

            Args:
                api_key_id (str): An API Key ID found in a path
                api_key (APIKey):

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                APIKey
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['api_key_id'] = \
                api_key_id
            kwargs['api_key'] = \
                api_key
            return self.call_with_http_info(**kwargs)

        if self.replace_api_key is None:
            self.replace_api_key = _Endpoint(
                settings={
                    'response_type': (APIKey,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/api_keys/{api_key_id}',
                    'operation_id': 'replace_api_key',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'api_key_id',
                        'api_key',
                        'user_id',
                        'org_id',
                    ],
                    'required': [
                        'api_key_id',
                        'api_key',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'api_key_id':
                            (str,),
                        'api_key':
                            (APIKey,),
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'api_key_id': 'api_key_id',
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'api_key_id': 'path',
                        'api_key': 'body',
                        'user_id': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_api_key
            )

        def __replace_session(
            self,
            session_id,
            session,
            **kwargs
        ):
            """Update a session  # noqa: E501

            Update a session  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_session(session_id, session, async_req=True)
            >>> result = thread.get()

            Args:
                session_id (str): A login session identifier
                session (Session):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Session
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_id'] = \
                session_id
            kwargs['session'] = \
                session
            return self.call_with_http_info(**kwargs)

        if self.replace_session is None:
            self.replace_session = _Endpoint(
                settings={
                    'response_type': (Session,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/sessions/{session_id}',
                    'operation_id': 'replace_session',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'session_id',
                        'session',
                    ],
                    'required': [
                        'session_id',
                        'session',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'session_id':
                            (str,),
                        'session':
                            (Session,),
                    },
                    'attribute_map': {
                        'session_id': 'session_id',
                    },
                    'location_map': {
                        'session_id': 'path',
                        'session': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_session
            )

        def __update_session_challenge(
            self,
            session_challenge,
            **kwargs
        ):
            """Update a session with its challenge answer  # noqa: E501

            Update a session with its challenge answer  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_session_challenge(session_challenge, async_req=True)
            >>> result = thread.get()

            Args:
                session_challenge (SessionChallenge): session challenge

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                SessionChallenge
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['session_challenge'] = \
                session_challenge
            return self.call_with_http_info(**kwargs)

        if self.update_session_challenge is None:
            self.update_session_challenge = _Endpoint(
                settings={
                    'response_type': (SessionChallenge,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/session_challenges/update_session',
                    'operation_id': 'update_session_challenge',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'session_challenge',
                    ],
                    'required': [
                        'session_challenge',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'session_challenge':
                            (SessionChallenge,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'session_challenge': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__update_session_challenge
            )

        def __validate_identity_assertion(
            self,
            identity_assertion,
            **kwargs
        ):
            """Validate an identity assertion  # noqa: E501

            Validate an identity assertion to asscertain if the request for a token is valid  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.validate_identity_assertion(identity_assertion, async_req=True)
            >>> result = thread.get()

            Args:
                identity_assertion (IdentityAssertion): Token to validate

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                IdentityAssertionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['identity_assertion'] = \
                identity_assertion
            return self.call_with_http_info(**kwargs)

        if self.validate_identity_assertion is None:
            self.validate_identity_assertion = _Endpoint(
                settings={
                    'response_type': (IdentityAssertionResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/authentication_documents_rpc/validate_identity_assertion',
                    'operation_id': 'validate_identity_assertion',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'identity_assertion',
                    ],
                    'required': [
                        'identity_assertion',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'identity_assertion':
                            (IdentityAssertion,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'identity_assertion': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__validate_identity_assertion
            )

    create_api_key = None 
    create_api_key_introspection = None 
    create_authentication_document = None 
    create_bulk_delete_session_task = None 
    create_bulk_revoke_session_task = None 
    create_bulk_revoke_token_task = None 
    create_introspect_token = None 
    create_introspect_token_all_sub_orgs = None 
    create_reissued_token = None 
    create_revoke_token_task = None 
    create_session = None 
    create_session_and_token = None 
    create_session_challenge = None 
    create_token = None 
    create_token_validation = None 
    create_user_data_token = None 
    delete_api_key = None 
    delete_authentication_document = None 
    delete_session = None 
    get_api_key = None 
    get_authentication_document = None 
    get_jwks = None 
    get_session = None 
    get_token = None 
    get_user_data_jwks = None 
    list_api_keys = None 
    list_authentication_documents = None 
    list_sessions = None 
    list_tokens = None 
    refresh_token = None 
    replace_api_key = None 
    replace_session = None 
    update_session_challenge = None 
    validate_identity_assertion = None 
