"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class ExtraProcess(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @property
    def program_name(self):
       return self.get("program_name")

    @program_name.setter
    def program_name(self, new_value):
       self.program_name = new_value

    @property
    def name_regex_flag(self):
       return self.get("name_regex_flag")

    @name_regex_flag.setter
    def name_regex_flag(self, new_value):
       self.name_regex_flag = new_value

    @property
    def start_if_not_running(self):
       return self.get("start_if_not_running")

    @start_if_not_running.setter
    def start_if_not_running(self, new_value):
       self.start_if_not_running = new_value

    @property
    def exit_when_ending(self):
       return self.get("exit_when_ending")

    @exit_when_ending.setter
    def exit_when_ending(self, new_value):
       self.exit_when_ending = new_value

    @property
    def attach_if_already_running(self):
       return self.get("attach_if_already_running")

    @attach_if_already_running.setter
    def attach_if_already_running(self, new_value):
       self.attach_if_already_running = new_value

    @property
    def fork_then_attach(self):
       return self.get("fork_then_attach")

    @fork_then_attach.setter
    def fork_then_attach(self, new_value):
       self.fork_then_attach = new_value

    @property
    def command_arguments(self):
       return self.get("command_arguments")

    @command_arguments.setter
    def command_arguments(self, new_value):
       self.command_arguments = new_value

    @property
    def start_in(self):
       return self.get("start_in")

    @start_in.setter
    def start_in(self, new_value):
       self.start_in = new_value

    @property
    def match_arguments(self):
       return self.get("match_arguments")

    @match_arguments.setter
    def match_arguments(self, new_value):
       self.match_arguments = new_value

    @property
    def wait_for_exit(self):
       return self.get("wait_for_exit")

    @wait_for_exit.setter
    def wait_for_exit(self, new_value):
       self.wait_for_exit = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'program_name': (str,),  # noqa: E501
            'name_regex_flag': (bool,),  # noqa: E501
            'start_if_not_running': (bool,),  # noqa: E501
            'exit_when_ending': (bool,),  # noqa: E501
            'attach_if_already_running': (bool,),  # noqa: E501
            'fork_then_attach': (bool,),  # noqa: E501
            'command_arguments': (str,),  # noqa: E501
            'start_in': (str,),  # noqa: E501
            'match_arguments': (bool,),  # noqa: E501
            'wait_for_exit': (bool,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'program_name': 'program_name',  # noqa: E501
        'name_regex_flag': 'name_regex_flag',  # noqa: E501
        'start_if_not_running': 'start_if_not_running',  # noqa: E501
        'exit_when_ending': 'exit_when_ending',  # noqa: E501
        'attach_if_already_running': 'attach_if_already_running',  # noqa: E501
        'fork_then_attach': 'fork_then_attach',  # noqa: E501
        'command_arguments': 'command_arguments',  # noqa: E501
        'start_in': 'start_in',  # noqa: E501
        'match_arguments': 'match_arguments',  # noqa: E501
        'wait_for_exit': 'wait_for_exit',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, program_name, *args, **kwargs):  # noqa: E501
        """ExtraProcess - a model defined in OpenAPI

        Args:
            program_name (str): Full path to the process to run or attach to

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name_regex_flag (bool): If set use program name as a regex for finding the process to attach to by name or executable path can't be set if start_if_not_running is set. . [optional] if omitted the server will use the default value of False  # noqa: E501
            start_if_not_running (bool): If there isn't a process running this service when running the launcher start it . [optional] if omitted the server will use the default value of False  # noqa: E501
            exit_when_ending (bool): If the process should be terminated when the launcher exits . [optional] if omitted the server will use the default value of True  # noqa: E501
            attach_if_already_running (bool): If the process is already running when the launcher starts, attach to it an intercept its traffic . [optional] if omitted the server will use the default value of False  # noqa: E501
            fork_then_attach (bool): Some programs require specific startup initialization procedures that cause the initial interceptor spawn + resume startup procedure to not function correctly. The typical behavior for this type of program is exhibited as the program terminates prematurely. This setting, when true, does a normal fork and will attach to the pid after the process has initially started.. [optional] if omitted the server will use the default value of False  # noqa: E501
            command_arguments (str): The arguments necessary for the command to run.. [optional]  # noqa: E501
            start_in (str): The directory this extra process will start in. [optional]  # noqa: E501
            match_arguments (bool): When attaching to a running process, match on both the process and the arguments. [optional]  # noqa: E501
            wait_for_exit (bool): When running the interceptor, wait on this proccess as well as the main process. You can use this with the process name to intercept processes that call some kind of launcher which runs another process. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.program_name = program_name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, program_name, *args, **kwargs):  # noqa: E501
        """ExtraProcess - a model defined in OpenAPI

        Args:
            program_name (str): Full path to the process to run or attach to

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name_regex_flag (bool): If set use program name as a regex for finding the process to attach to by name or executable path can't be set if start_if_not_running is set. . [optional] if omitted the server will use the default value of False  # noqa: E501
            start_if_not_running (bool): If there isn't a process running this service when running the launcher start it . [optional] if omitted the server will use the default value of False  # noqa: E501
            exit_when_ending (bool): If the process should be terminated when the launcher exits . [optional] if omitted the server will use the default value of True  # noqa: E501
            attach_if_already_running (bool): If the process is already running when the launcher starts, attach to it an intercept its traffic . [optional] if omitted the server will use the default value of False  # noqa: E501
            fork_then_attach (bool): Some programs require specific startup initialization procedures that cause the initial interceptor spawn + resume startup procedure to not function correctly. The typical behavior for this type of program is exhibited as the program terminates prematurely. This setting, when true, does a normal fork and will attach to the pid after the process has initially started.. [optional] if omitted the server will use the default value of False  # noqa: E501
            command_arguments (str): The arguments necessary for the command to run.. [optional]  # noqa: E501
            start_in (str): The directory this extra process will start in. [optional]  # noqa: E501
            match_arguments (bool): When attaching to a running process, match on both the process and the arguments. [optional]  # noqa: E501
            wait_for_exit (bool): When running the interceptor, wait on this proccess as well as the main process. You can use this with the process name to intercept processes that call some kind of launcher which runs another process. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.program_name = program_name
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

