"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.files_api import FilesApi  # noqa: E501


class TestFilesApi(unittest.TestCase):
    """FilesApi unit test stubs"""

    def setUp(self):
        self.api = FilesApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_add_file(self):
        """Test case for add_file

        upload a file  # noqa: E501
        """
        pass

    def test_create_file_association(self):
        """Test case for create_file_association

        associate a file with an object  # noqa: E501
        """
        pass

    def test_create_file_association_clear_task(self):
        """Test case for create_file_association_clear_task

        Cleans up file associations  # noqa: E501
        """
        pass

    def test_create_file_template(self):
        """Test case for create_file_template

        Add a file template  # noqa: E501
        """
        pass

    def test_create_public_file_org_link(self):
        """Test case for create_public_file_org_link

        link public files based on org  # noqa: E501
        """
        pass

    def test_delete_file(self):
        """Test case for delete_file

        Delete a File  # noqa: E501
        """
        pass

    def test_delete_file_association(self):
        """Test case for delete_file_association

        Remove an association from a file  # noqa: E501
        """
        pass

    def test_delete_file_template(self):
        """Test case for delete_file_template

        Delete a file template  # noqa: E501
        """
        pass

    def test_delete_public_file_org_link(self):
        """Test case for delete_public_file_org_link

        Remove a link from an org  # noqa: E501
        """
        pass

    def test_get_download(self):
        """Test case for get_download

        Download File  # noqa: E501
        """
        pass

    def test_get_download_public(self):
        """Test case for get_download_public

        Download public file  # noqa: E501
        """
        pass

    def test_get_file(self):
        """Test case for get_file

        Get File metadata  # noqa: E501
        """
        pass

    def test_get_file_association(self):
        """Test case for get_file_association

        Get a file association  # noqa: E501
        """
        pass

    def test_get_file_template(self):
        """Test case for get_file_template

        Get a file template  # noqa: E501
        """
        pass

    def test_get_public_file_org_link(self):
        """Test case for get_public_file_org_link

        Get a public file org link  # noqa: E501
        """
        pass

    def test_list_file_associations(self):
        """Test case for list_file_associations

        Query File Associations  # noqa: E501
        """
        pass

    def test_list_file_templates(self):
        """Test case for list_file_templates

        List all file templates  # noqa: E501
        """
        pass

    def test_list_files(self):
        """Test case for list_files

        Query Files  # noqa: E501
        """
        pass

    def test_list_public_file_org_links(self):
        """Test case for list_public_file_org_links

        Query Public File Org Links  # noqa: E501
        """
        pass

    def test_render_file_template(self):
        """Test case for render_file_template

        Render a file template  # noqa: E501
        """
        pass

    def test_replace_file(self):
        """Test case for replace_file

        Update a file  # noqa: E501
        """
        pass

    def test_replace_file_template(self):
        """Test case for replace_file_template

        update a file template  # noqa: E501
        """
        pass

    def test_replace_public_file_org_link(self):
        """Test case for replace_public_file_org_link

        Replace a public file org link  # noqa: E501
        """
        pass

    def test_reupload_file(self):
        """Test case for reupload_file

        Upload a new version of a file  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
