"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.10
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.messages_api import MessagesApi  # noqa: E501


class TestMessagesApi(unittest.TestCase):
    """MessagesApi unit test stubs"""

    def setUp(self):
        self.api = MessagesApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_bulk_delete_messages(self):
        """Test case for bulk_delete_messages

        Delete a list of messages and inbox items asociated to it.  # noqa: E501
        """
        pass

    def test_create_message(self):
        """Test case for create_message

        Send a message to a specific message endpoint.  # noqa: E501
        """
        pass

    def test_create_routed_message(self):
        """Test case for create_routed_message

        Send one or more messages, letting the system choose how to deliver it  # noqa: E501
        """
        pass

    def test_create_user_message(self):
        """Test case for create_user_message

        Send a message to a user on all (optionally of a type) endpoints.  # noqa: E501
        """
        pass

    def test_delete_inbox_item(self):
        """Test case for delete_inbox_item

        Delete an inbox item  # noqa: E501
        """
        pass

    def test_delete_message_endpoint(self):
        """Test case for delete_message_endpoint

        Delete a messaging endpoint  # noqa: E501
        """
        pass

    def test_get_inbox_item(self):
        """Test case for get_inbox_item

        Get an inbox item  # noqa: E501
        """
        pass

    def test_get_message_endpoint(self):
        """Test case for get_message_endpoint

        Get a message endpoint  # noqa: E501
        """
        pass

    def test_list_inbox_items(self):
        """Test case for list_inbox_items

        Get a list of inbox items items and information about the inbox  # noqa: E501
        """
        pass

    def test_list_message_endpoints(self):
        """Test case for list_message_endpoints

        List all message endpoints (all users or a single user)  # noqa: E501
        """
        pass

    def test_list_messages_config(self):
        """Test case for list_messages_config

        Get the config of the endpoint-types (e.g. public keys etc).  # noqa: E501
        """
        pass

    def test_replace_inbox_item(self):
        """Test case for replace_inbox_item

        replace an inbox item  # noqa: E501
        """
        pass

    def test_replace_message_endpoint(self):
        """Test case for replace_message_endpoint

        Update a messaging endpoint  # noqa: E501
        """
        pass

    def test_update_message_endpoint(self):
        """Test case for update_message_endpoint

        Register a messaging endpoint on a user.  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
