from typing import Dict
import random

def random_get(dic: dict, str_key: str, mode:str = "static"):
    if mode == "static":
        count = sum([ord(c) for c in str_key])
        keys = list(dic.keys())
        return dic[keys[count % len(keys)]]
    else:
        keys = list(dic.keys())
        return dic[random.choice(keys)]

opening: Dict[str, str] = {}

# opening["parrot"] = r"""
#                            .    
#                           | \/| 
#                           ) )|/|
#                     _----. /.'.'
# .-._________..      .' @ _\  .' 
# '.._______.   '.   /    (_| .') 
#   '._____.  /   '-/      | _.'  
#    '.______ (         ) ) \     
#      '..____ '._       )  )     
#         .' __.--\  , ,  // ((   
#         '.'     |  \/   (_.'(   
#                 '   \ .'        
#                  \   (          
#                   \   '.        
#                    \ \ '.)      
#                     '-'-'       
# """

opening["estuda"] = r"""
------- O modelo de avaliação utiliza 3 critérios --------

- Cobertura: quanto da atividade foi entregue\?
  - Se houver testes, isso será calculado automaticamente
- Abordagem: como foi a última execução da atividade\?
  - Copiar, ChatGpt, Copilot, Aula, Monitoria, Sozinho
- Autonomia: se refizer a atividade sozinho e SEM CONSULTA, 
    quanto dela você se sente confiante para fazer\?

Cobertura: (  fiz nada ) 0 1 ... 9 ✓ (entreguei tudo)
Abordagem: (muita ajuda) x E D C B A (nenhum suporte)
Autonomia: (não aprendi) x ▁ ▂ ▃ ▅ █ (refaço sozinho)

 ,`````.          __||||___       
' Estuda`,       /_  ___   \      
'miserável`.    /@ \/@  \   \     
 ` , . , '  `.. \__/\___/   /     
                 \_\/______/      
                 /     /\\\\\     
                |     |\\\\\\     
                 \      \\\\\\    
                  \______/\\\\    
            _______ ||_||_______  
           (______(((_(((______(@)
"""[1:]

# opening["alien4"] = r"""
#             ______              ______
#            /___   \___\ || /___/   ___\
#           //\]/\ ___  \\||//  ___ /\[/\\
#           \\/[\//  _)   \/   (_  \\/]\//
#            \___/ _/   o    o   \_ \___/
#                _/                \_
#               //'VvvvvvvvvvvvvvvV'\\
#              ( \.'^^^^^^^^^^^^^^'./ )
#               \____   . .. .   ____/
#    ________        \ . .''. . /        ________
#   /______  \________)________(________/ _______\
#  /|       \ \  Estuda seu miserável  / /       |\
# (\|____   / /                        \ \   ____|/)
# """

# opening["alien5"] = r"""
#                    ⢀⡀⠤⠤⠤⠄ ⠒⠢⣄    
#                 ⡠⠐⢈⠄        ⢸⠓⠄  
#               ⠐⠈⠠⠊         ⡠⠊ ⠈⢂ 
#             ⢀⠊ ⡐⠁        ⢠⢊⠔⠈   ⠆
#            ⣠⡃ ⢰    ⢀⡠⠄⠐⠒ ⢸⢜⠄     
#           ⡐⣁⡑ ⠘  ⢀⠔⢁⣀⣤⣤⣤⣒⣤ ⠈    ⡄
#           ⢫⣿⢧ ⢸  ⣡⣶⣯⠭⢄⣀⣼⡏⠁⢀⡤   ⢐⠁
#           ⢠⢿⣾⣧⠈ ⢠⣿⣿⣗⢢⣤⣿⡿⢋ ⡏    ⡌ 
#    Gosto  ⠘⠳⠙⠻  ⠰⠿⠟⠛⠻⢍⠫⠒⠁⡰   ⢀⠜  
#     de    ⠘⢄          ⢀⠠⢊ ⡇⢠⠒⠁   
#    comer    ⠈⢦⠂    ⢠⠊⠁ ⢀⠄ ⡇⢸     
#  cérebros    ⠘⢄⡄⢤⢄ ⠘⡄  ⡀⠄⢊⡅⡆⢆    
#     de         ⢊   ⠈⢁⠴⠅⣀⣀⠘⢣⠠⠈⠢⢀  
#   alunos       ⠈⠢⢄⣀⡠⠊  ⠈⢣ ⠈⠃⠡  ⠉⠐
# preguiçosos             ⠰⠇  ⠐⡑⠤⢀ 
# """

intro: Dict[str, str] = {}

intro["elephant"] = r"""
        ⣀⣀                                                                      
      ⣰⣿⣿⣿⣿⣦⣀⣀⣀           ↲ -> avalia usando os testes cadastrados no cases.tio 
      ⢿⣿⠟⠋⠉    ⠉⠑⠢⣄⡀      r -> compila e (r)oda fazendo entrada de dados manual 
     ⢠⠞⠁           ⠙⢿⣿⣿⣦⡀                                                       
 ⣀  ⢀⡏ ⢀⣴⣶⣶⡄         ⢻⣿⣿⠇ TAB -> Muda o arquivo PRINCIPAL se múltiplos arquivos 
⣾⣿⣿⣦⣼⡀ ⢺⣿⣿⡿⠃    ⣠⣤⣄  ⠈⡿⠋                                                        
⢿⣿⣿⣿⣿⣇ ⠤⠌⠁ ⡀⢲⡶⠄⢸⣏⣿⣿   ⡇   d -> muda o modo (d)iff de vertical para horizontal   
⠈⢿⣿⣿⣿⣿⣷⣄⡀  ⠈⠉⠓⠂ ⠙⠛⠛⠠ ⡸⠁   u -> trava a avaliação em (u)m único caso de teste    
  ⠻⣿⣿⣿⣿⣿⣿⣷⣦⣄⣀    ⠑ ⣠⠞⠁    t -> define o limite de (t)empo para execução         
   ⢸⡏⠉⠛⠛⠛⠿⠿⣿⣿⣿⣿⣿⣿⣿⣿⡄                                                            
   ⠸        ⠈⠉⠛⢿⣿⣿⣿⣿⡄     esquerda direita -> muda o teste apresentado          
"""

compilling: Dict[str, str] = {}

# compilling["bloody"] = r"""
#  ▄████▄   ▒█████   ███▄ ▄███▓ ██▓███   ██▓ ██▓    ▄▄▄       ███▄    █ ▓█████▄  ▒█████  
# ▒██▀ ▀█  ▒██▒  ██▒▓██▒▀█▀ ██▒▓██░  ██▒▓██▒▓██▒   ▒████▄     ██ ▀█   █ ▒██▀ ██▌▒██▒  ██▒
# ▒▓█    ▄ ▒██░  ██▒▓██    ▓██░▓██░ ██▓▒▒██▒▒██░   ▒██  ▀█▄  ▓██  ▀█ ██▒░██   █▌▒██░  ██▒
# ▒▓▓▄ ▄██▒▒██   ██░▒██    ▒██ ▒██▄█▓▒ ▒░██░▒██░   ░██▄▄▄▄██ ▓██▒  ▐▌██▒░▓█▄   ▌▒██   ██░
# ▒ ▓███▀ ░░ ████▓▒░▒██▒   ░██▒▒██▒ ░  ░░██░░██████▒▓█   ▓██▒▒██░   ▓██░░▒████▓ ░ ████▓▒░
# ░ ░▒ ▒  ░░ ▒░▒░▒░ ░ ▒░   ░  ░▒▓▒░ ░  ░░▓  ░ ▒░▓  ░▒▒   ▓▒█░░ ▒░   ▒ ▒  ▒▒▓  ▒ ░ ▒░▒░▒░ 
#   ░  ▒     ░ ▒ ▒░ ░  ░      ░░▒ ░      ▒ ░░ ░ ▒  ░ ▒   ▒▒ ░░ ░░   ░ ▒░ ░ ▒  ▒   ░ ▒ ▒░ 
# ░        ░ ░ ░ ▒  ░      ░   ░░        ▒ ░  ░ ░    ░   ▒      ░   ░ ░  ░ ░  ░ ░ ░ ░ ▒  
# ░ ░          ░ ░         ░             ░      ░  ░     ░  ░         ░    ░        ░ ░  
# ░                                                                      ░               
# """


executing: str = r"""
███████╗██╗  ██╗███████╗ ██████╗██╗   ██╗████████╗ █████╗ ███╗   ██╗██████╗  ██████╗ 
██╔════╝╚██╗██╔╝██╔════╝██╔════╝██║   ██║╚══██╔══╝██╔══██╗████╗  ██║██╔══██╗██╔═══██╗
█████╗   ╚███╔╝ █████╗  ██║     ██║   ██║   ██║   ███████║██╔██╗ ██║██║  ██║██║   ██║
██╔══╝   ██╔██╗ ██╔══╝  ██║     ██║   ██║   ██║   ██╔══██║██║╚██╗██║██║  ██║██║   ██║
███████╗██╔╝ ██╗███████╗╚██████╗╚██████╔╝   ██║   ██║  ██║██║ ╚████║██████╔╝╚██████╔╝
╚══════╝╚═╝  ╚═╝╚══════╝ ╚═════╝ ╚═════╝    ╚═╝   ╚═╝  ╚═╝╚═╝  ╚═══╝╚═════╝  ╚═════╝ 
"""

compilling["computer"] = r"""
 ██████╗ ██████╗ ███╗   ███╗██████╗ ██╗██╗      █████╗ ███╗   ██╗██████╗  ██████╗ 
██╔════╝██╔═══██╗████╗ ████║██╔══██╗██║██║     ██╔══██╗████╗  ██║██╔══██╗██╔═══██╗
██║     ██║   ██║██╔████╔██║██████╔╝██║██║     ███████║██╔██╗ ██║██║  ██║██║   ██║
██║     ██║   ██║██║╚██╔╝██║██╔═══╝ ██║██║     ██╔══██║██║╚██╗██║██║  ██║██║   ██║
╚██████╗╚██████╔╝██║ ╚═╝ ██║██║     ██║███████╗██║  ██║██║ ╚████║██████╔╝╚██████╔╝
 ╚═════╝ ╚═════╝ ╚═╝     ╚═╝╚═╝     ╚═╝╚══════╝╚═╝  ╚═╝╚═╝  ╚═══╝╚═════╝  ╚═════╝ 
"""

success: Dict[str, str] = {}


success["success"] = r"""
███████╗██╗   ██╗ ██████╗███████╗███████╗███████╗ ██████╗ 
██╔════╝██║   ██║██╔════╝██╔════╝██╔════╝██╔════╝██╔═══██╗
███████╗██║   ██║██║     █████╗  ███████╗███████╗██║   ██║
╚════██║██║   ██║██║     ██╔══╝  ╚════██║╚════██║██║   ██║
███████║╚██████╔╝╚██████╗███████╗███████║███████║╚██████╔╝
╚══════╝ ╚═════╝  ╚═════╝╚══════╝╚══════╝╚══════╝ ╚═════╝ 
"""

images: Dict[str, str] = {}

images["pink"] = r"""
Programando assim, você vai dominar o mundo!
                 /`.    /`.                       
                f   \  ,f  \                      
                |    \/-`\  \                     
                i.  _\';.,X j                     
                 `:_\ (  \ \',-.                  
                   .'"`\ a\eY' )               _,.
                   `._"\`-' `-/            .-;'  |
                     /;-`._.-';\.        ,',"    |
                   .'/   "'   | `\.-'""-/ /      j
                 ,/ /         i,-"        (  ,/  /
              .-' .f         .'            `"/  / 
             / ,,/ffj\      /          .-"`.'-.'  
            / /_\`--//)     \ ,--._ .-'_,-'; /    
           f  ".-"-._;'      `._ _.,-i; /_; /     
           `.,'   |; \          \`\_,/-'  \'      
            .'    l \ `.        /"\ _ \`  j       
            f      : `-'        `._;."/`-'        
"""

images["batman"] = r"""
Não é o que sou por dentro, é o que eu faço que me define.
                     .  .          
                     |\_|\         
                     | a_a\        
                     | | "]        
                 ____| '-\___      
                /.----.___.-'\     
               //        _    \    
              //   .-. (~v~) /|    
             |'|  /\:  .--  / \    
            // |-/  \_/____/\/~|   
           |/  \ |  []_|_|_] \ |   
           | \  | \ |___   _\ ]_}  
           | |  '-' /   '.'  |     
           | |     /    /|:  |     
           | |     |   / |:  /\    
           | |     /  /  |  /  \   
           | |    |  /  /  |    \  
           \ |    |/\/  |/|/\    \ 
            \|\ |\|  |  | / /\/\__\
             \ \| | /   | |__      
                  / |   |____)     
                  |_/              
"""


images["vegeta"] = r"""
O miserável é um gênio!
    ⢨⠊ ⢀⢀   ⠈⠺⡵⡱   ⢠⠃ ⡀         ⡘⢰⡁⠉⠊⠙⢎⣆    ⢩⢀⠜   
   ⢠⠃  ⢸⢸⡀    ⠘⢷⡡  ⠎ ⢰⣧  ⠈⡆       ⠈⣐⢤⣀⣀⢙⠦    ⡇    
  ⢀⠃   ⡌⢸⠃   ⢀  ⠑⢧⡸ ⢀⣿⢻⡀  ⣻     ⣠⡴⠛⠉   ⠑⢝⣦   ⢰⠠⠁  
  ⠌   ⡘⣖⣄⢃   ⠈⢦⡀ ⡜⡇ ⣼⠃⠈⢷⣶⢿⠟   ⢠⠞⠁ ⣀⠄⠂⣶⣶⣦⠆⠋⠓ ⢀⣀⡇   
⠡⡀⡇ ⢰⣧⢱⠊⠘⡈⠄  ⡀⠘⣿⢦⣡⢡⢰⡇⢀⠤⠊⡡⠃  ⢀⡴⠁⢀⠔⠊  ⢠⣿⠟⠁ ⢀ ⢀⠾⣤⣀  ⡠
⡀⠱⡇ ⡆⢃   ⠃   ⣧⣀⣹⡄⠙⡾⡏ ⡌⣠⡾⠁  ⣠⠊⢠⠔⠁    ⣸⡏   ⢨⣪⡄⢻⣥⠫⡳⢊⣴
  ⢡⢠ ⢸⡆ ⣀    ⠈⣛⢛⣁⣀⠘⣧⣀⢱⡿  ⢀⡔⢁⢔⠕⠉⠐⣄⣠⠤⠶⠛⠁⢀⣀  ⠉⠁⠈⠷⣞⠔⡕⣿
⢄⡀⠘⢸ ⣘⠇        ⠉⠐⠤⡑⢎⡉⢨⠁ ⣠⢏⠔⠁⠘⣤⠴⢊⣡⣤⠴⠖⠒⠻⠧⣐⠓    ⠈ ⡜ ⠇
⠤⡈⠑⠇⠡⣻⢠⠊⠉⠉⠉⠑⠒⠤⣀   ⠈⣾⣄⢘⣫⣜⠮⢿⣆⡴⢊⢥⡪⠛⠉    ⢀⠄⠂⠁      ⢧⡀⠈
⠁⠈⠑⠼⣀⣁⣇ ⣴⡉⠉⠉ ⠒⡢⠌⣐⡂⠶⣘⢾⡾⠿⢅ ⣠⣶⡿⠓⠁⢠⠖⣦⡄   ⠊         ⠈⢎⢳
    ⠉⣇⣿⢜⠙⢷⡄   ⣄⣠⠼⢶⡛⣡⢴ ⢀⠛⠱⡀    ⢀⠎ ⠁            ⢠⡋⠮⡈
  ⢀⣖⠂⢽⡈ ⠈⠑⠻⡦⠖⢋⣁⡴⠴⠊⣉⡠⢻⡖⠪⢄⡀⢈⠆  ⢠⠊⢠             ⢀⠤⡵⢤⣃
  ⠸⢠⡯⣖⢵⡀  ⣠⣤⠮⠋⠁     ⠸⣌⢆⢱⡾⠃⢀⠠⠔⠁⣀⢸     ⡄       ⡸⠚⡸⠈⠁
⠤⢀⣀⢇⢡⠸⡗⢔⡄⠸⠊           ⠉⡩⠔⢉⡠⠔⠂⠉⢀⠆            ⢠⢁⠎⢀⡠⠔
   ⠘⡌⢦⡃⣎⠘⡄        ⠠⡟⠠⡐⣋⠤ ⣀⠤⠐⠂⠉⠁             ⡸⢉⠉⠁  
⠤   ⠰⡀⠈⠻⡤⠚⢄  ⢠       ⠈⠂⠒⠉                  ⢠⠃⢸ ⢀⠤⠊
⣀    ⠘⠢⡑⢽⡬⢽⢆ ⠈           ⣠⣤⡶⠟⣉⣉⢢          ⢀⠇ ⠈⡖⠓⠒⠂
 ⢈⣑⣒⡤⠄ ⠈⠑⠥⣈⠙⠧           ⢰⣁⠔⠊⠁        ⡜   ⣠⡻   ⠇⠐⡔⣡
⠉⠉⠁ ⠒⠒⠒⠒ ⠤⠤⠍⣒⡗⢄⡀        ⠈           ⡸  ⢠⡞⢡⠃   ⢸ ⠸⣡
            ⢠  ⠈⣶⢄⡀                ⡰⠁⣠⡔⠉ ⡎    ⢸  ⠃
         ⢠⠇⣀⢼   ⢉⡄⠈⠐⠤⣀         ⢀⡀ ⡜⡡⣾⠃  ⠸      ⡧⢄⡈
       ⣀⠤⠚⠉ ⡆   ⠈⡵⢄⡀  ⠙⠂⠄⣀⡀⠤⠊⠉⢀⣀⣠⡴⢿⣟⠞  ⢀⠇      ⡗⠢⢌
    ⡠⠔⠉  ⢀⡠⡤⠇  ⢀ ⠰⣣⠈⠐⠤⡀ ⡀⠈⠙⢍⠉⣉⠤⠒⠉⣠⣟⢮⠂⡄ ⣼⠁ ⡆    ⢡⣀ 
⣿⡷⠖⠉  ⡠⠔⣪⣿⠟⣫   ⢸  ⢩⢆  ⠈⠑⢳⠤⠄⠠⠭⠤⠐⠂⢉⣾⢮⠃⢠⠃⢰⡹ ⢰     ⢸⡉⣳
⠉ ⢀⡠⠒⠉⣠⠾⠋⢁⠔⠹   ⡈⡇  ⢫⣆   ⠘⣆      ⣘⢾⠃⢀⠏⣠⡳⠁ ⣾      ⠈⠉
"""



images["esqueleto"] = r"""
Você venceu o desafio, mas não a guerra!
Espero você no próximo nível!
                              _.--""-._                     
  .                         ."         ".                   
 / \    ,^.         /(     Y             |      )\          
/   `---. |--'\    (  \__..'--   -   -- -'""-.-'  )         
|        :|    `>   '.     l_..-------.._l      .'          
|      __l;__ .'      "-.__.||_.-'v'-._||`"----"            
 \  .-' | |  `              l._       _.'                   
  \/    | |                   l`^^'^^'j                     
        | |                _   \_____/     _                
        j |               l `--__)-'(__.--' |               
        | |               | /`---``-----'"1 |  ,-----.      
        | |               )/  `--' '---'   \'-'  ___  `-.   
        | |              //  `-'  '`----'  /  ,-'   I`.  \  
      _ L |_            //  `-.-.'`-----' /  /  |   |  `. \ 
     '._' / \         _/(   `/   )- ---' ;  /__.J   L.__.\ :
      `._;/7(-.......'  /        ) (     |  |            | |
      `._;l _'--------_/        )-'/     :  |___.    _._./ ;
        | |                 .__ )-'\  __  \  \  I   1   / / 
        `-'                /   `-\-(-'   \ \  `.|   | ,' /  
                           \__  `-'    __/  `-. `---'',-'   
                              )-._.-- (        `-----'      
                             )(  l\ o ('..-.                
                       _..--' _'-' '--'.-. |                
                __,,-'' _,,-''            \ \               

"""

images["coiote"] = r"""
Você fez essa questão muito rápido, da próxima vez
vou aumentar a dificuldade!
                      _                                   
                     : \                                  
                     ;\ \_                   _            
                     ;@: ~:              _,-;@)           
                     ;@: ;~:          _,' _,'@;           
                     ;@;  ;~;      ,-'  _,@@@,'           
                    |@(     ;      ) ,-'@@@-;             
                    ;@;   |~~(   _/ /@@@@@@/              
                    \@\   ; _/ _/ /@@@@@@;~               
                     \@\   /  / ,'@@@,-'~                 
                       \\  (  ) :@@(~                     
                    ___ )-'~~~~`--/ ___                   
                   (   `--_    _,--'   )                  
                  (~`- ___ \  / ___ -'~)                  
                 __~\_(   \_~~_/   )_/~__                 
 /\ /\ /\     ,-'~~~~~`-._ 0\/0 _,-'~~~~~`-.              
| |:  ::|    ;     ______ `----'  ______    :             
| `'  `'|    ;    {      \   ~   /      }   |             
 \_   _/     `-._      ,-,' ~~  `.-.      _,'        |\   
   \ /_          `----' ,'       `, `----'           : \  
   |_( )                `-._/#\_,-'                  :  ) 
 ,-'  ~)           _,--./  (###)__                   :  : 
 (~~~~_)          /       ; `-'   `--,               |  ; 
 (~~~' )         ;       /@@@@@@.    `.              | /  
 `.HH~;        ,-'  ,-   |@@@ @@@@.   `.             .')  
  `HH `.      ,'   /     |@@@@@ @@@@.  `.           / /(~)
   HH   \_   ,'  _/`.    |@@@@@ @@@@@;  `.          ; (~~)
   ~~`.   \_,'  /   ;   .@@@@@ @@@@@@;\_  \___      ; H~\)
"""

images["piupiu"] = r"""
Eu acho que eu vi um programador!
                 $                
              $  $   $$           
              $ $$ $$             
         $$$$      $$$$$$         
       $$                $$       
     $$        $$          $$     
   $$                        $$   
  $$                          $$  
  $                           $ $ 
 $                $             $ 
 $             $$$$              $
 $            $$ $           $   $
 $          $$$$$$       $$$$    $
 $         $$$$$$$      $$  $    $
  $        $$$$$ $     $$$$$$   $ 
  $$       $     $    $$$$$$   $$ 
   $$      $    $    $$$$     $   
    $      $   $     $       $    
    $      $$$$         $  $$     
    $$               $$$  $       
     $$$       $$$$$      $       
        $$$     $$       $$       
            $$     $$$$$$         
          $$      $$ $            
       $$$$        $ $$           
         $  $$     $   $          
    $$$$$$ $       $  $           
  $$   $$$$ $      $   $$$$$$$    
  $$      $$$$     $ $$     $$    
  $          $$$$$$$$         $   
   $$         $   $          $    
    $$$$$$$$$$$   $$$$$$$$$$$ ~*  
"""

images["saitama"] = r"""
Se garantiu
        ⣠⣴⣶⡋⠉⠙⠒⢤⡀     ⢠⠖⠉⠉⠙⠢⡄ 
      ⢀⣼⣟⡒⠒     ⠙⣆   ⢠⠃     ⠹⡄
      ⣼⠷⠖        ⠘⡆  ⡇       ⢷
      ⣷⡒  ⢐⣒⣒⡒ ⣐⣒⣒⣧  ⡇ ⢠⢤⢠⡠  ⢸
     ⢰⣛⣟⣂ ⠘⠤⠬⠃⠰⠑⠥⠊⣿ ⢴⠃ ⠘⠚⠘⠑⠐ ⢸
     ⢸⣿⡿⠤     ⢀⡆  ⣿  ⡇       ⣸
     ⠈⠿⣯⡭    ⢀⣀   ⡟  ⢸      ⢠⠏
       ⠈⢯⡥⠄      ⡼⠁   ⠳⢄⣀⣀⣀⡴⠃ 
         ⢱⡦⣄⣀⣀⣀⣠⠞⠁      ⠈⠉    
       ⢀⣤⣾⠛⠃   ⢹⠳⡶⣤⡤⣄         
    ⣠⢴⣿⣿⣿⡟⡷⢄⣀⣀⣀⡼⠳⡹⣿⣷⠞⣳        
   ⢰⡯⠭⠹⡟⠿⠧⠷⣄⣀⣟⠛⣦⠔⠋⠛⠛⠋⠙⡆       
  ⢸⣿⠭⠉ ⢠⣤   ⠘⡷⣵⢻    ⣼ ⣇       
  ⡇⣿⠍⠁ ⢸⣗⠂   ⣧⣿⣼    ⣯ ⢸  
"""

images["cool"] = r"""
Essa foi show de bola!
       ⢀⣠⣤⣴⡾⠻⢶⣤⡀ 
     ⢀⣶⠟⠉⠉    ⠉⢷⡄
   ⠉⢿⣿⣿⣿⠏⠈⢿⣿⣿⣿⡿⢟⣿
    ⢸⡏ ⢠⣀ ⢀⡤   ⢨⣿
    ⠸⣿⡀ ⠉⠉⠉  ⢀⣠⡾⠃
     ⠈⠻⠷⠶⣶⡶⠾⠿⠛⠉  
 ⢀⡀     ⢀⣿       
⠿⢿⣧⡀    ⣸⣟       
  ⠘⢿⡄ ⣠⡾⢻⣿⣄      
    ⢿⣴⡟ ⢸⡏⠹⣧     
    ⠈⠛  ⢸⣟ ⠹⣧    
"""

images["among"] = r"""
Sossegue, você não é um importor
           ⣠⣤⣤⣤⣤⣤⣶⣦⣤⣄⡀         
        ⢀⣴⣿⡿⠛⠉⠙⠛⠛⠛⠛⠻⢿⣿⣷⣤⡀      
        ⣼⣿⠋       ⢀⣀⣀⠈⢻⣿⣿⡄     
       ⣸⣿⡏   ⣠⣶⣾⣿⣿⣿⠿⠿⠿⢿⣿⣿⣿⣄    
       ⣿⣿⠁  ⢰⣿⣿⣯⠁       ⠈⠙⢿⣷⡄  
  ⣀⣤⣴⣶⣶⣿⡟   ⢸⣿⣿⣿⣆          ⣿⣷  
 ⢰⣿⡟⠋⠉⣹⣿⡇   ⠘⣿⣿⣿⣿⣷⣦⣤⣤⣤⣶⣶⣶⣶⣿⣿⣿  
 ⢸⣿⡇  ⣿⣿⡇    ⠹⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⠃  
 ⣸⣿⡇  ⣿⣿⡇     ⠉⠻⠿⣿⣿⣿⣿⡿⠿⠿⠛⢻⣿⡇   
 ⣿⣿⠁  ⣿⣿⡇                ⢸⣿⣧   
 ⣿⣿   ⣿⣿⡇                ⢸⣿⣿   
 ⣿⣿   ⣿⣿⡇                ⢸⣿⣿   
 ⢿⣿⡆  ⣿⣿⡇                ⢸⣿⡇   
 ⠸⣿⣧⡀ ⣿⣿⡇                ⣿⣿⠃   
  ⠛⢿⣿⣿⣿⣿⣇     ⣰⣿⣿⣷⣶⣶⣶⣶⠶ ⢠⣿⣿    
       ⣿⣿     ⣿⣿⡇ ⣽⣿⡏⠁  ⢸⣿⡇    
       ⣿⣿     ⣿⣿⡇ ⢹⣿⡆   ⣸⣿⠇    
       ⢿⣿⣦⣄⣀⣠⣴⣿⣿⠁ ⠈⠻⣿⣿⣿⣿⡿⠏     
       ⠈⠛⠻⠿⠿⠿⠿⠋⠁               
"""

images["heart"] = r"""
O código ficou lindo dessa vez!
     ⣀⣀⣀⡀          ⣀⣠⣠⣴⣦⣤⣤⣄⣀   
  ⣰⣼⣿⣯⢭⣿⣿⣿⣻⣶⣤⡀  ⢀⣠⣾⣿⣿⣾⣿⣿⣿⣽⣿⣿⣻⣦⡀
 ⣰⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣧⣴⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿
⢀⣿⣿⣿⣿⣿⣿⣿⣿⡟⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡟
⢸⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⢡⠊⢻⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡇
⢸⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠇⠎⠠⠐⡉⢉⠁⠘⣭⣿⣿⣿⣿⣿⣿⣿⡿ 
⠈⢿⣿⣿⣿⣿⣿⣿⣿⣿⡿⠟⠋⠈⠄⡁⠂⢀⠂⡬⣾⣿⣿⣿⣿⣿⣿⣿⣿⠁ 
 ⠈⢿⣿⣿⣿⣿⣿⣶⣤⣖⡂⠌⠐⠠⠐⢨⢀⠄⠘⢜⢿⣿⣿⣿⣿⣿⣿⠃  
   ⠹⣿⣿⣿⣿⣿⣿⣿⣿⠆⠁⢂⠅⣒⡈⠤⠈⡈ ⠻⣿⣿⣿⡿⠃   
    ⠙⢿⣿⣿⣿⣿⣿⣿⣄⡦⣠⣾⣿⣿⣿⣷⣾⣤⣗⣹⣿⡟     
      ⠘⠿⣿⣿⣿⣿⣴⣾⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠏      
        ⠻⢿⣟⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⠏       
          ⠘⠻⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⠁        
             ⠙⠿⢿⣿⣿⣿⡿⠋          
"""

images["pikachu"] = r"""
        Picapi!          
⢀⣠⣾⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿    ⣠⣤⣶⣶
⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿   ⢰⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣧⣀⣀⣾⣿⣿⣿⣿
⣿⣿⣿⣿⣿⡏⠉⠛⢿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⣿
⣿⣿⣿⣿⣿⣿   ⠈⠛⢿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⠿⠛⠉⠁ ⣿
⣿⣿⣿⣿⣿⣿⣧⡀    ⠙⠿⠿⠿⠻⠿⠿⠟⠿⠛⠉     ⣸⣿
⣿⣿⣿⣿⣿⣿⣿⣷⣄ ⡀               ⢀⣴⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⣿⠏              ⠠⣴⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⡟  ⢰⣹⡆      ⣭⣷   ⠸⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⠃  ⠈⠉  ⠤⠄   ⠉⠁    ⢿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⢾⣿⣷    ⡠⠤⢄   ⠠⣿⣿⣷ ⢸⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⡀⠉     ⢄ ⢀    ⠉⠉⠁  ⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⣧       ⠈          ⢹⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⣿⠃                 ⢸⣿⣿
"""

images["yoda"] = r"""
Que a força esteja com você
 ⢀⣠⣄⣀⣀⣀               ⣀⣤⣴⣶⡾⠿⠿⠿⠿⢷⣶⣦⣤⣀⡀                     
⢰⣿⡟⠛⠛⠛⠻⠿⠿⢿⣶⣶⣦⣤⣤⣀⣀⡀⣀⣴⣾⡿⠟⠋⠉        ⠉⠙⠻⢿⣷⣦⣀         ⢀⣀⣀⣀⣀⣀⣀⣀⡀
 ⠻⣿⣦⡀ ⠉⠓⠶⢦⣄⣀⠉⠉⠛⠛⠻⠿⠟⠋⠁   ⣤⡀  ⢠   ⣠    ⠈⠙⠻⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠟⠛⠛⢻⣿
  ⠈⠻⣿⣦    ⠈⠙⠻⢷⣶⣤⡀    ⢀⣀⡀ ⠙⢷⡀⠸⡇ ⣰⠇ ⢀⣀⣀      ⣀⣠⣤⣤⣶⡶⠶⠶⠒⠂  ⣠⣾⠟
    ⠈⢿⣷⡀      ⠈⢻⣿⡄⣠⣴⣿⣯⣭⣽⣷⣆ ⠁    ⢠⣾⣿⣿⣿⣿⣦⡀ ⣠⣾⠟⠋⠁       ⣠⣾⡟⠁ 
     ⠈⢻⣷⣄       ⣿⡗⢻⣿⣧⣽⣿⣿⣿⣧  ⣀⣀ ⢠⣿⣧⣼⣿⣿⣿⣿⠗⠰⣿⠃        ⣠⣾⡿⠋   
       ⠙⢿⣶⣄⡀    ⠸⠃⠈⠻⣿⣿⣿⣿⣿⡿⠃⠾⣥⡬⠗⠸⣿⣿⣿⣿⣿⡿⠛ ⢀⡟      ⣀⣠⣾⡿⠋     
         ⠉⠛⠿⣷⣶⣤⣤⣄⣰⣄  ⠉⠉⠉⠁ ⢀⣀⣠⣄⣀⡀ ⠉⠉⠉  ⢀⣠⣾⣥⣤⣤⣤⣶⣶⡿⠿⠛⠉       
             ⠈⠉⢻⣿⠛⢿⣷⣦⣤⣴⣶⣶⣦⣤⣤⣤⣤⣬⣥⡴⠶⠾⠿⠿⠿⠿⠛⢛⣿⣿⣿⣯⡉⠁           
               ⠈⣿⣧⡀⠈⠉ ⠈⠁⣾⠛⠉⠉          ⣀⣴⣿⠟⠉⣹⣿⣇            
               ⢀⣸⣿⣿⣦⣀   ⢻⡀       ⢀⣠⣤⣶⣿⠋⣿⠛⠃ ⣈⣿⣿            
               ⣿⡿⢿⡀⠈⢹⡿⠶⣶⣼⡇ ⢀⣀⣀⣤⣴⣾⠟⠋⣡⣿⡟ ⢻⣶⠶⣿⣿⠛⠋            
              ⠘⣿⣷⡈⢿⣦⣸⠇⢀⡿⠿⠿⡿⠿⠿⣿⠛⠋⠁ ⣴⠟⣿⣧⡀⠈⢁⣰⣿⠏              
               ⢸⣿⢻⣦⣈⣽⣀⣾⠃ ⢸⡇ ⢸⡇ ⢀⣠⡾⠋⢰⣿⣿⣿⣿⡿⠟⠋               
               ⠘⠿⢿⣿⣿⡟⠛⠃  ⣾  ⢸⡇⠐⠿⠋  ⣿⢻⣿⣿                   
                  ⢸⣿⠁⢀⡴⠋ ⣿  ⢸⠇     ⠁⢸⣿⣿                   
                 ⢀⣿⡿⠟⠋   ⣿  ⣸       ⢸⣿⣿                   
                 ⢸⣿⣁⣀    ⣿⡀ ⣿      ⢀⣈⣿⣿                   
                 ⠘⠛⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠿⠟⠛⠋                   
"""

images["vader"] = r"""
Sua falta de fé é perturbadora.
                 ⢀⣀⡀   ⢀⣀               
            ⣠⣤⣶⣾⣿⡉⢤⣍⡓⢶⣶⣦⣤⣉⠒⠤⡀           
         ⢀⣴⣿⣿⣿⣿⣿⣿⣷⡀⠙⣿⣷⣌⠻⣿⣿⣿⣶⣌⢳⡀         
        ⣰⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣄⠈⢿⣿⡆⠹⣿⣿⣿⣿⣷⣿⡀        
       ⣰⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣷⣄⠹⣿⡄⢻⣿⣿⣿⣿⣿⣧        
      ⢠⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⠿⠿⣿⣿⣷⣽⣷⢸⣿⡿⣿⡿⠿⠿⣆       
      ⣼⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡄   ⠐⠾⢭⣭⡼⠟⠃⣤⡆⠘⢟⢺⣦⡀     
      ⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⢛⣥⣶⠾⠿⠛⠳⠶⢬⡁  ⠘⣃⠤⠤⠤⢍⠻⡄    
      ⣿⣿⣿⣿⣿⣿⣿⡿⣫⣾⡿⢋⣥⣶⣿⠿⢿⣿⣿⣿⠩⠭⢽⣷⡾⢿⣿⣦⢱⡹⡀   
      ⣿⣿⣿⣿⣿⣿⡟⠈⠛⠏⠰⢿⣿⣿⣧⣤⣼⣿⣿⣿⡏⠩⠽⣿⣀⣼⣿⣿⢻⣷⢡   
     ⢰⣿⣿⣿⣿⣿⣿⢁⣿⣷⣦⡀ ⠉⠙⠛⠛⠛⠋⠁⠙⢻⡆ ⢌⣉⠉⠉ ⠸⣿⣇⠆  
    ⢀⣾⣿⣿⣿⣿⣿⡇⢸⣿⣿⣿⣿⠷⣄⢠⣶⣾⣿⣿⣿⣿⣿⠁  ⢿⣿⣿⣿⣷⠈⣿⠸⡀ 
    ⣼⣿⣿⣿⣿⣿⣿ ⣌⡛⠿⣿⣿ ⠈⢧⢿⣿⡿⠟⠋⠉⣠⣤⣤⣤⣄⠙⢿⣿⠏⣰⣿⡇⢇ 
   ⣼⣿⣿⣿⣿⣿⣿⡇⢸⣿⣿⣶⣤⣙⠣⢀⠈⠘⠏  ⢀⣴⢹⡏⢻⡏⣿⣷⣄⠉⢸⣿⣿⣷⠸⡄
  ⣸⣿⣿⣿⣿⣿⣿⣿⠁⣾⣟⣛⠛⠛⠻⠿⠶⠬⠔ ⣠⡶⠋⠿⠈⠷⠸⠇⠻⠏⠻⠆⣀⢿⣿⣿⡄⢇
 ⢰⣿⣿⣿⣿⠿⠿⠛⠋⣰⣿⣿⣿⣿⠿⠿⠿⠒⠒⠂ ⢨⡤⢶⣶⣶⣶⣶⣶⣶⣶⣶⠆⠃⣀⣿⣿⡇⣸
⢀⣿⣿⠿⠋⣡⣤⣶⣾⣿⣿⣿⡟⠁ ⣠⣤⣴⣶⣶⣾⣿⣿⣷⡈⢿⣿⣿⣿⣿⠿⠛⣡⣴⣿⣿⣿⣿⠟⠁
⣼⠋⢁⣴⣿⣿⣿⣿⣿⣿⣿⣿   ⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣎⠻⠟⠋⣠⣴⣿⣿⣿⣿⠿⠋⠁  
⢿⣷⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿ ⣴ ⠻⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣧⣠⣾⣿⠿⠿⠟⠋⠁     
 ⠉⠛⠛⠿⠿⠿⢿⣿⣿⣿⣵⣾⣿⣧⣾⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡿⠏           
                  ⠉⠉⠉⠉⠉⠉⠉⠁              
"""

images["mario"] = r"""
Vamos lá. Nossa grande aventura começa agora!
                      ⢀⣀⣠⣤⣤⣤⣄⣀            
                   ⣠⣴⡾⣻⣿⣿⣿⣿⣯⣍⠛⠻⢷⣦⣀        
                ⢀⣴⣿⠟⢁⣾⠟⠋⣁⣀⣤⡉⠻⣷⡀ ⠙⢿⣷⣄      
       ⢀⡀      ⣰⣿⠏  ⢸⣿ ⠼⢋⣉⣈⡳⢀⣿⠃   ⠙⣿⣦⡀    
      ⢰⡿⠿⣷⡀   ⣼⣿⠃  ⣀⣤⡿⠟⠛⠋⠉⠉⠙⢛⣻⠶⣦⣄⡀ ⠘⣿⣷⡀   
⢠⣾⠟⠳⣦⣄⢸⡇ ⠈⣷⡀ ⣼⣿⡏⢀⣤⡾⢋⣵⠿⠻⢿⠋⠉⠉⢻⠟⠛⠻⣦⣝⠻⣷⣄⠸⣿⣿   
⠘⣧   ⠙⢿⣿  ⢸⣷ ⣿⣿⣧⣾⣏⡴⠛⢡⠖⢛⣲⣅  ⣴⣋⡉⠳⡄⠈⠳⢬⣿⣿⣿⡿   
 ⠘⠷⣤⣀⣀⣀⣽⡶⠛⠛⠛⢷⣿⣿⣿⣿⣏  ⡏⢰⡿⢿⣿  ⣿⠻⣿ ⡷ ⣠⣾⣿⡿⠛⠷⣦  
  ⢀⣾⠟⠉⠙⣿⣤⣄ ⢀⣾⠉ ⢹⣿⣿⣷ ⠹⡘⣷⠾⠛⠋⠉⠛⠻⢿⡴⢃⣄⣻⣿⣿⣷  ⢹⡇ 
  ⢸⡇⠈⠉⠛⢦⣿⡏ ⢸⣧ ⠈⠻⣿⡿⢣⣾⣦⣽⠃       ⣷⣾⣿⡇⠉⢿⡇ ⢀⣼⠇ 
  ⠘⣷⡠⣄⣀⣼⠇   ⠻⣷⣤⣀⣸⡇ ⠹⣿⣿⣦⣀    ⢀⣴⣿⣿⡟  ⢸⣷⣾⡿⠃  
   ⠈⠻⢦⣍⣀⣀⣀⡄ ⣰⣿⡿⠿⢿⣇  ⠉⠛⠻⣿⣿⡷⠾⣿⣿⡿⠉⠁  ⢀⣾⠋⠁    
      ⠈⠉⠉⠙⠿⢿⣿⣇  ⠈⢿⣧⣄   ⢹⣷⣶⣶⣾⣿⡇  ⣀⣴⡿⣧⣄⡀    
            ⠙⢿⣷⡀  ⠙⢿⣿⣶⣤⡀⠻⢤⣀⡤⠞⢀⣴⣿⣿⠟⢷⡀⠙⠻⣦⣄  
              ⠈⢻⣦ ⢠⡟⠁⠙⢻⣿⠷⠶⣶⠶⠾⠛⠙⣿⠇  ⢻⡄  ⠙⢷⡀
               ⣸⣿⡀⣿⠁⣤⣤⡄⢻⡶⠶⠛⠛⠛⠛⠛⣿⢠⣾⣷⣆⢻⡀  ⠈⣷
               ⣿⣿⣿⣿⢸⣿⣿⣿⡈⢿⡀     ⡿⢸⣿⣿⣿⢸⡇   ⡟
               ⠈⠉⠉⠉⠈⠉⠉⠉⠁⠈⠁    ⠈⠁⠈⠉⠉⠉ ⠁  ⠈⠁
"""

images["mandalorian"] = r"""
Como deve ser
                     ⢀⣀⣀⣀⣀                        
                 ⢀⣠⠴⠚⣹⠁⣶⢲⢈⠉⠓⠶⢤⡀                   
               ⣠⠞⠉ ⢀⣾⢻ ⣿⡈⢸    ⠉⠳⢄⡀                
             ⢠⠞    ⣈⣿⣾⣾⣿⡇⢸       ⠙⢄               
           ⢀⡴⠃ ⢀⡀ ⣴⣿⡏⣿⣿⣿⡇⣼⡇       ⠈⠳⣄⡀            
       ⣠⡴⠶⠟⠋  ⡄⢸⡇⢸⣿⣼⣧⣿⣿⣿⣁⣿⣤⣄⣀⣀ ⢀    ⠈⠙⠛⠒⠦⠄        
            ⣠⣦⣷⣾⡿⠿⢿⣿⣿⣿⣿⣿⣿⣽⣿⣿⣿⣿⣓⣲⠲⠦⢤⣀              
          ⢀⣴⣿⣫⣭⣼⣶⣿⠿⢻⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣟⣿⣟⢻⣶⣌⢻⣶            
         ⢀⣿⡿⡿⢿⠓⠒⣛⠻⣿⣟⣿⣿⣿⣿⣿⣿⡏⠙⠋⠛    ⠈⠉⣿⢹⡆           
         ⠸⣿⡇⢀⣀  ⣿⢀ ⠸⣿⣿⣿⣿⣿⣿⠁     ⣠⣴⣶⣦⣼⣿⣇           
         ⠈⣿⡇⣿⣿⣿⣦⡹⣆  ⣿⣿⣿⣿⣿⣿   ⣴⣿⣾⣿⣿⢿⣿⣿⣿⠛           
          ⢘⣿⣿⣿⣿⣿⣿⡝⣧ ⢹⣿⣿⣿⣿⣿ ⢀⣼⣿⣿⣿⣿⣿⣿⠃⣿⣿            
          ⠈⢻⣿⢸⣿⣿⣿⣿⣿⡇⢸⣿⣿⣿⣿⡗⠈⣼⣿⢿⣿⡿⠿⢿⣯ ⠿⣿            
           ⢸⣿⣸⡇⠈⠙⢿⣷⢿⡘⣿⣿⣿⣿⠃⢠⣿⣿⡿⠉   ⢻⡀⢀⣿            
           ⢸⣿⣿   ⠈⢻⡟⣇⣇⣿⣿⣿ ⢸⣿⡿⠁     ⢷⣄⢻            
           ⢸⣿⡏     ⣿⢿⣿⣿⣿⣿ ⣾⣿⠃      ⠘⣿⡟            
           ⠘⠻⠧⣄⡀   ⢸⣾⣿⣿⣿⣿ ⣿⡟    ⣀⣠⣥⣶⣿⣦⣄⡀          
               ⠉⠙⠲⣦⣄⣿⣿⣿⣿⣿⣷⣿⣧⣴⣶⡾⣛⣯⣭⣷⠤⠶⠤⢬⣭⢽⣆⡀⢠⣶⣶⣶⠶⠶⢤
               ⣀⣀⡤⣽⣿⣿⣿⣿⣿⣿⣿⣿⣿⣻⣟⢿⠏⣉⣡⣤⣶⣾⠿⣿⣿⣿⣿⠛⢸⣾⡿⠛⠛⠛⠶
           ⣀⣠⣤⣿⣛⣾⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣯⣿⣷⣿⣿⡿⢟⣿⡟⣰⣾⠋     
       ⣠⣴⡶⣫⣽⢿⣯⣽⣿⣿⣿⣿⠿⠛⠁⢈⣹⣿⣿⣿⣿⣿⣿⣿⠿⠿⠿⠿⠿⠿⣤⣴⣿⠛⢰⣿⠇      
      ⣰⣿⣿⣼⣟⣽⣼⣿⣿⣿⣿⣯⣷⢍⣣⣶⣿⣿⣿⣿⣿⣿⣿⠟⠁     ⢸⣿⣿⡟ ⣧⣿ ⡀     
"""


images["minion"] = r"""
Bananaaaa!
              ⣀ ⠤⠤⠤ ⣀       
           ⡠⠐⢉⠴⣚⠉⣙⠢⢄⡤⢞⡂⢀⣐⢄  
          ⡔⡤⣞⢁⠊⢀⣀⠐⢿⡄⠰⢁⡀⠈⠺⣦⢡ 
         ⢰⣿⣗⣟⡸ ⠻⡿⠃⢸⣇⢃⠿⠿  ⣽⢸ 
         ⠁ ⠈⠙⢷⣴⡀ ⠠⣪⣾⣷⡄⡀⠠⣐⢕⠁ 
 ⢰⡦      ⡇    ⠙⠲⡖⠓⠉⠁⠈⠉⠒ ⠈⢸  
⢶⣿⣷⣤⢀⣀⡀  ⣏⡑⠢⢄   ⠈⠐ ⠐     ⡸⡀ 
⠛⠛⠛⠟ ⠤⠤⠌⢉ ⠈⠓⢬⣿⣦⡤⣤⣤⠤⠤⣤⣤⣤⣤⣚⣔⣄ 
         ⡇  ⡤⠂  ⢀⠤⠤⢄⡨⠔⠒⢍⠉⢁⣯⡆
         ⡗⢤⡤⣬   ⢇   ⠁  ⡸⢰⣿⣿⡿
         ⠘⢌⡿⣽⡀  ⠈⠒⢄⡀ ⢀⠔⠁⠈⠙⡋ 
           ⠑⠳⢧⣠⣤⣄⣠⣀⣈⣱⡥⠤⠴⠦⠴⠃ 
              ⢹⣿⣿ ⣿⣿⣿⣄      
              ⠙⠉⠉ ⠈⠉⠉⠉      
"""

images["minions2"] = r"""
Banana banana bananáaaaaa!
            ⣀⢀⣠⣤⣄⡀⢀⣀          
         ⣠⡶⠛⢉⠤⣀⠤⡠⢫⠵⠶⢩⡢        
 ⣀      ⢰⠋ ⣠⢡⠋⠉⠙⣆⢂⣤⡄⠈⡇⡇  ⣀⣶⣄⢤ 
⢠⢇⠓⠒⣂⡤⡀ ⡆ ⡜⣿⣜⢄⣿⢆⠜⣤⣝⣓⣢⠜ ⡠⢛⠧⠬⠭⠸⠇
⠈⠒⠓⠂⠙⠓⢌⠢⢷⡫⠐⠉⠛⠴⠶⠖⠊ ⠉⠉ ⢸⠌⡰⠁     
       ⠑⡀⠙⢕⢦  ⠠⣲⣒⠲⢲⠎⢻⢈⣷       
        ⠸⡀ ⢣⡑⡄ ⠑⠠⠄⠘⠴⠂⣸⣹       
         ⠃  ⢹⣼⡶⣄    ⡴⢿⢻       
         ⢀   ⡝⠁ ⠙⠒⠒⠋ ⢸⢸       
         ⢸⢄⣀⣀⡇  ⡖⢦⣴⠊⡆⢸⣸       
         ⢰ ⠉⢸⠁ ⠸⡇⣞⣯⡷⡇⢨⢹       
         ⣸⡀⠔⠃   ⠑⠬⠭⠝ ⣈⡾⡄      
        ⡴⢣⠑⢄⣀⣀⣀⣀⣀ ⠤⣐⢞⣿⡡⠃      
        ⠈⠁⠉⠉       ⠈⠫⠙        
"""

images["slayer"] = r"""
Não há atalhos, apenas trabalho duro.
Treine duro e seja paciente. Vai valer a pena.
⠏⠁⠈⠙⠛⢿⣿⣿⣿⣿⣿⣿⣿⡟ ⠈⠻⣿⣿⣿⣿⣿⠟⢡⡿⢿⣿⠿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿
    ⢀⣎⣏⡏⣟⠛⠿⠿⡟⢁⣀⣀⣠⡼⠟⠛⠉  ⠉⠐⠋  ⠛⠋⠭⠾⢿⣿⣿⠟⣫⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿
⣦⣶⡀   ⠉⠛⣿⣿⣷⣿⣇⣠⠟⠋⠁  ⢀⡄       ⣀⣠⡤⠴⠒⠋⠁⣰⡿⢿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿
⣿⣿⣷  ⡀   ⠉⠉⡿⠋⠁⡠⢀⠄⡠⠔⠋⢀⣀⠔ ⢀⡤⠚⣽⡟⠋   ⢀⡜⢱⠃⠉⣩⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿
⣿⣿⣿⣦⡀⢹   ⢀⡞⠁⡰⠛⣡⢃⣾⠁⠤⡾⢋⣀⡀⠠⠊ ⢾⣏⡾ ⢀⣠⡴⠿⠙⣿⠃ ⠙⠛⢉⣿⣿⣿⣿⣿⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣷⡄  ⡜ ⠐⡅⡜⡇⢠⠃⡠⠊⠐⠝⠋    ⠈⠙⢁⠔⣯⡝⢁⡶⢾⣿⠇   ⠐⠺⠿⢻⣿⣿⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⡀⣠⡇ ⣠⡇⡸ ⢣⠎⢀⣀⣤⣴⣶⠟⠛      ⣭⣷⣤⡴⠋        ⠙⣽⡿⢿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⣿⢿⡇⢀⡟⠃⣡⡿⠃⣰⣾⡯⠚⠉⣀⣠⣄⣤            ⢀ ⢀⡈⠁   ⣠⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣿⡇⢸⣷⠸⠁⢲⡏⢀⣾⣿⠏⣠⠞⠁ ⢾⣿⣽⡆⡀ ⣠        ⣀⡠⠄   ⢀⡾⢧⣿⣿⣿⣿
⣿⣿⣿⣿⣿⣿⣟⣳⣿⣿⣆ ⢸⠁⠸⣿⠏⣰⣿ ⡀  ⢁⣻⣧⣷⣿⡽⠃      ⠉    ⢠⣶⠯⣄⣠⡽⠿⢿⣿
⣿⣿⣿⣿⣿⣿⣟⡁⢈⠟⣁    ⠋⢰⣿⡿⣧⣌⣒⣒⣿⣞⣿⣿⠋           ⢀⣸⣯⠽⠋⠁     
⣿⣿⣿⠿⣿⣿⡿⠟⠁⠊⠱⣣⣶⡀  ⢘⡛⠓⠚⣛⣋⣛⣸⠭⠞⠁          ⣀⡠⣞⡋⠁        
⣿⣿⡃ ⠘⣿⢤⡀   ⣹⣿⡟ ⢀⡎⢱ ⡀                ⣉⡥⠖⠉          
⣿⣟⢿ ⢆⠘⢦⡈⢦⡠⡺⠋⠉⠠⢊⡝ ⢰⣧⡈⠓⢤⣀             ⣽⠶⠄           
⣿⣿⣼⣷⠈⢳⣄⠙⠲⣧  ⣠⠖⠋⠙⠢⠼⠁⠙⠶ ⠈⠉⠛⠤         ⣀⠉⠉            
⣿⣿⣷⣍  ⠻⠷⠄⢘⣧⣞⣡⣶⣏⠉⣳ ⣠⣤⣀ ⢤⣠⡐⠦⣄⡀    ⢀⡐⠒⠉              
⣿⣿⣿⣿⣿⣷⣶⣄⣀⣸⣿⣿⣿⣿⣿⣶⣿⣆⣻⣿⣿⣷⣶⢭⣿⣦⣶⠿⠾⣗⢒⠿ ⠁                
⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⡌⠁⠙⠂⢀⡉⣁⡠⠴⠛⠉⠁                  
⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣦⣀  ⠈ ⣄              ⣠⣤⣶⠶⠖⣶⠁ 
⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣛⡦ ⣀⣨⠟⠲⠤⠤⠬⣷⣀          ⣠⣴⠟⢁⡀ ⣼⠇  
⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣧⣶⣬⣿⣿⣡⣵⣖⣤⣀⣤⣈⣙⣶⣦⣤⣀⣀⣠⡤⠶⠟⠋⠁  ⠉⢷⠉   
"""

images["jujutsu"] = r"""
Não sei como vou me sentir quando estiver morto, 
mas não quero me arrepender da maneira como vivi.
   ⣀                      
⢠⣀⡀⡏⠳⣄   ⢀⡀ ⢠             
⡤⠵ ⢀⡶⠛⠁⢢⢄⡜⠱⡾⠍⠧⠲⡇⣀⡄        
⠈⢶⣤⠛⠁⣀⡹⠉        ⠰⠥⣤       
  ⠁ ⠠⣿⢃⢀⣤⣤⡴⣰⢰⣠⢠  ⢨⣷⡆      
     ⠝⢿⠙⢯⣟ ⣱⡿⠌⡷⣿⣾⣿⡿⠙⢦     
      ⣸ ⠼   ⠃⣠⠄⠘⡟⢘⣄ ⠈⢷    
     ⠘⡏⠉ ⡐⢢ ⢀⡀ ⢰⠖⡩⠊ ⣠⠋    
      ⢈⣷⢄⡑⠚⢀⡠⠤⣒⠡⠊⢀⣠⣾⣿⣦    
    ⢀⣴⣿⣿⣿⣍⠫⠇⠐⠉⢒⣠⣴⣿⣿⣿⣿⣿⡆   
  ⡤⢐⠚⣿⣿⣿⣿⣿⣶⣶⣶⣶⣾⣿⣛⠟⠛⣿⣿⣿⡇   
 ⢸⠐⠠⢌⣺⣿⠿⠛⠻⣿⣿⣿⣿⣿⣿ ⠄ ⠈⣿⣿⣷   
  ⠣⢌⡹⠋⠁ ⢀⣠⣿⣿⣿⣿⣿⣿⣯⣭⣀⣴⣿⣿⣿⠇  
     ⢀⣠⣶⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣍   
   ⢠⣾⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣿⣇  
  ⢀⣾⣿⣿⣿⣿⣿⡿⠏⠁ ⠈⠉⠙⢿⣿⣿⣿⣿⣿⣿⣿⣇ 
  ⣼⣿⣿⣿⣿⡿⠋⠁       ⠙⢿⣿⣿⣿⣿⣿⣿⡆
 ⠘⠛⣿⡿⠛⠋              ⢿⣿⣏⠉⠉
⢀⠤⣾⠛⣿                ⠾⣐⣚⣦ 
⠉⠉⠉⠉⠁                     
"""


images["gollum"] = r"""
Meu precioso!
        ⣀⣠⣴⣶⡿⠟⠋⠁              
     ⢀⣴⣾⣿⣿⣿⠋      ⠈           
   ⢀⣼⡿⠛⠻⣿⣿⠃⢀            ⢀     
  ⢠⣿⣿⠃⢰⣆⠘⢿⡦⠈            ⠸     
 ⢠⣿⣿⣿ ⠙⢿⡆⠈⠁                 ⡀ 
⢀⣿⣿⣿⣿⢀⠐⢿⠃                  ⢀⣷ 
⠈⠉⠉⠙⠛⠃⣷⣮⠃ ⢀⣀⣀⡀             ⢸⣿⡇
      ⠘⣿⡄⠐⠚⢆⠁⠙⢻⣶⣦⣄⡀⡀       ⠘⠋⠁
  ⢀⣶⡀⠐⣠⣿⣷⣤⡀⠐⠙⠶⠶⠿⠿⠛⠿⣿⣿⣿⣤⣴⣀  ⣴⢎ 
  ⠈⣿⣿⣾⣿⣿⣿⣿⣇⣠⠴⠖⠲⡂   ⠹⣿⣟⡛⠹⠛⠂⠘⣡⡿ 
   ⢻⣿⣿⣿⣿⣿⡇⢹⣧   ⠱⢀⣀⡠⠲⣄⣹⣿⡏ ⣠⣾⣿⠃ 
   ⠸⣿⣿⣿⣿⣿⡇ ⠁⠙⣢⣄⣀    ⢹⣿⣿⣫⣾⣿⡿⠃  
    ⠙⢩⢻⣿⣿⣷⡀  ⢈⡙⠛⠿⠓⠐⠉ ⢸⣿⣿⣿⠟⠁   
       ⠽⢀⣤⡀ ⢠⣤⡈⠉⠁⠠⠤  ⠘⠿⠋⠁     
         ⠉⠛⠿⠶⢾⣭⢤⡾ ⠠⠒          
"""
