# iparapheur-internal
iparapheur v5.x main core application.

The main link between every sub-services, integrating business code logic.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: DEVELOP
- Package version: 1.18.1
- Generator version: 7.8.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://libriciel.fr](https://libriciel.fr)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import iparapheur_internal
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import iparapheur_internal
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import iparapheur_internal
from iparapheur_internal.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = iparapheur_internal.Configuration(
    host = "http://localhost:8080"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with iparapheur_internal.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = iparapheur_internal.AdminAdvancedConfigApi(api_client)

    try:
        # Delete signature validation service configuration
        api_instance.delete_signature_validation_service_configuration()
    except ApiException as e:
        print("Exception when calling AdminAdvancedConfigApi->delete_signature_validation_service_configuration: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminAdvancedConfigApi* | [**delete_signature_validation_service_configuration**](docs/AdminAdvancedConfigApi.md#delete_signature_validation_service_configuration) | **DELETE** /api/internal/admin/server-info/signature-validation-service | Delete signature validation service configuration
*AdminAdvancedConfigApi* | [**get_signature_validation_service_configuration**](docs/AdminAdvancedConfigApi.md#get_signature_validation_service_configuration) | **GET** /api/internal/admin/server-info/signature-validation-service | Get signature validation service configuration
*AdminAdvancedConfigApi* | [**update_gdpr_information_details**](docs/AdminAdvancedConfigApi.md#update_gdpr_information_details) | **PUT** /api/internal/admin/server-info/gdpr | Register GDPR information details
*AdminAdvancedConfigApi* | [**update_signature_validation_service_configuration**](docs/AdminAdvancedConfigApi.md#update_signature_validation_service_configuration) | **PUT** /api/internal/admin/server-info/signature-validation-service | Edit signature validation service configuration
*AdminAllUsersApi* | [**count_logged_in_users**](docs/AdminAllUsersApi.md#count_logged_in_users) | **GET** /api/internal/admin/user/count | Count logged in users
*AdminDeskApi* | [**list_desks_by_user**](docs/AdminDeskApi.md#list_desks_by_user) | **GET** /api/internal/admin/tenant/{tenantId}/desks-by-user | List desks by user
*AdminDeskApi* | [**list_hierarchic_desks**](docs/AdminDeskApi.md#list_hierarchic_desks) | **GET** /api/internal/admin/tenant/{tenantId}/desk | List desks
*AdminExternalSignatureApi* | [**test_external_signature_config**](docs/AdminExternalSignatureApi.md#test_external_signature_config) | **POST** /api/internal/admin/tenant/{tenantId}/external-signature-config/test | Test an external signature config
*AdminFolderApi* | [**list_folders_as_admin**](docs/AdminFolderApi.md#list_folders_as_admin) | **POST** /api/internal/admin/tenant/{tenantId}/folder | List folders
*AdminFolderApi* | [**list_folders_as_admin_legacy**](docs/AdminFolderApi.md#list_folders_as_admin_legacy) | **GET** /api/internal/admin/tenant/{tenantId}/folder/legacy-list | Legacy method for Listing folders from &lt;&#x3D; 5.1 versions
*AdminLayerApi* | [**create_file_stamp**](docs/AdminLayerApi.md#create_file_stamp) | **POST** /api/internal/admin/tenant/{tenantId}/layer/{layerId}/stamp | Create a file stamp
*AdminLayerApi* | [**create_layer**](docs/AdminLayerApi.md#create_layer) | **POST** /api/internal/admin/tenant/{tenantId}/layer | Create a layer
*AdminLayerApi* | [**delete_file_stamp**](docs/AdminLayerApi.md#delete_file_stamp) | **DELETE** /api/internal/admin/tenant/{tenantId}/layer/{layerId}/stamp/{stampId} | Delete a stored image stamp
*AdminLayerApi* | [**delete_layer**](docs/AdminLayerApi.md#delete_layer) | **DELETE** /api/internal/admin/tenant/{tenantId}/layer/{layerId} | Delete layer
*AdminLayerApi* | [**get_layer**](docs/AdminLayerApi.md#get_layer) | **GET** /api/internal/admin/tenant/{tenantId}/layer/{layerId} | Get a layer with every information set
*AdminLayerApi* | [**get_layer_example_pdf**](docs/AdminLayerApi.md#get_layer_example_pdf) | **POST** /api/internal/admin/tenant/{tenantId}/layer/example-pdf | Test the given layer on a blank PDF
*AdminLayerApi* | [**get_stamp_image**](docs/AdminLayerApi.md#get_stamp_image) | **GET** /api/internal/admin/tenant/{tenantId}/layer/{layerId}/stamp/{stampId}/image | get the image of a file stamp
*AdminLayerApi* | [**list_layers**](docs/AdminLayerApi.md#list_layers) | **GET** /api/internal/admin/tenant/{tenantId}/layer | List layers
*AdminLayerApi* | [**update_layer**](docs/AdminLayerApi.md#update_layer) | **PUT** /api/internal/admin/tenant/{tenantId}/layer/{layerId} | Edit a layer
*AdminSealCertificateApi* | [**get_seal_signature_image**](docs/AdminSealCertificateApi.md#get_seal_signature_image) | **GET** /api/internal/admin/tenant/{tenantId}/sealCertificate/{sealCertificateId}/signatureImage | Get seal&#39;s signature image
*AdminSealCertificateApi* | [**list_subtype_usage**](docs/AdminSealCertificateApi.md#list_subtype_usage) | **GET** /api/internal/admin/tenant/{tenantId}/sealCertificate/{sealCertificateId}/subtypeUsage | List subtypes using the given certificate
*AdminTemplateApi* | [**test_docket_pdf_template**](docs/AdminTemplateApi.md#test_docket_pdf_template) | **POST** /api/internal/admin/tenant/{tenantId}/test-docket-pdf-template | Test the given docket PDF template
*AdminTemplateApi* | [**test_mail_template**](docs/AdminTemplateApi.md#test_mail_template) | **POST** /api/internal/admin/tenant/{tenantId}/test-mail-template | Test the given mail template
*AdminTemplateApi* | [**test_signature_pdf_template**](docs/AdminTemplateApi.md#test_signature_pdf_template) | **POST** /api/internal/admin/tenant/{tenantId}/test-signature-pdf-template | Get the server default signature template
*AdminTrashBinApi* | [**list_trash_bin_listable_folders**](docs/AdminTrashBinApi.md#list_trash_bin_listable_folders) | **GET** /api/internal/admin/tenant/{tenantId}/trash-bin | List folders in the trash-bin
*AdminTypologyApi* | [**get_typology_hierarchy**](docs/AdminTypologyApi.md#get_typology_hierarchy) | **GET** /api/internal/admin/tenant/{tenantId}/typology | Get typology list, sorted by hierarchy.
*AdminWorkflowDefinitionApi* | [**get_subtypes_referencing_workflow_definition_key**](docs/AdminWorkflowDefinitionApi.md#get_subtypes_referencing_workflow_definition_key) | **GET** /api/internal/admin/tenant/{tenantId}/workflowDefinitionByKey/{workflowDefinitionKey}/referencingSubtypes | Get subtypes referencing the given workflow definition key
*CurrentUserApi* | [**delete_table_layout**](docs/CurrentUserApi.md#delete_table_layout) | **DELETE** /api/internal/currentUser/table-layout/{tableLayoutId} | Delete tableLayout
*CurrentUserApi* | [**update_current_user_password**](docs/CurrentUserApi.md#update_current_user_password) | **PUT** /api/internal/currentUser/password | Update user password
*CurrentUserApi* | [**update_table_layout**](docs/CurrentUserApi.md#update_table_layout) | **PUT** /api/internal/currentUser/table-layout/{tableLayoutName} | Update tableLayout
*DeskApi* | [**create_delegation**](docs/DeskApi.md#create_delegation) | **POST** /api/internal/tenant/{tenantId}/desk/{deskId}/delegation | Create a new delegation (active or planned) from target desk
*DeskApi* | [**delete_delegation**](docs/DeskApi.md#delete_delegation) | **DELETE** /api/internal/tenant/{tenantId}/desk/{deskId}/delegation/{delegationId} | Remove an active or planned delegation from target Desk
*DeskApi* | [**get_associated_desks**](docs/DeskApi.md#get_associated_desks) | **GET** /api/internal/tenant/{tenantId}/desk/{deskId}/associatedDesks | Get the target desk&#39;s associated ones
*DeskApi* | [**get_associated_desks_by_user**](docs/DeskApi.md#get_associated_desks_by_user) | **GET** /api/internal/tenant/{tenantId}/desk/{deskId}/associated-desks-by-user | Get the target desk&#39;s associated ones by user
*DeskApi* | [**list_delegations**](docs/DeskApi.md#list_delegations) | **GET** /api/internal/tenant/{tenantId}/desk/{deskId}/delegation | List delegations (active and planned) for the given delegating desk
*DeskApi* | [**update_delegation**](docs/DeskApi.md#update_delegation) | **PUT** /api/internal/admin/tenant/{tenantId}/desk/{deskId}/delegation/{delegationId} | Update a delegation from target Desk
*DocumentApi* | [**create_annotation**](docs/DocumentApi.md#create_annotation) | **POST** /api/internal/tenant/{tenantId}/folder/{folderId}/document/{documentId}/annotations | Creates a PDF annotation
*DocumentApi* | [**create_signature_placement_annotation**](docs/DocumentApi.md#create_signature_placement_annotation) | **POST** /api/internal/tenant/{tenantId}/folder/{folderId}/document/{documentId}/signaturePlacement | Creates a signature placement annotation
*DocumentApi* | [**delete_annotation**](docs/DocumentApi.md#delete_annotation) | **DELETE** /api/internal/tenant/{tenantId}/folder/{folderId}/document/{documentId}/annotations/{annotationId} | Deletes the given PDF annotation
*DocumentApi* | [**get_signature_placement_annotations**](docs/DocumentApi.md#get_signature_placement_annotations) | **GET** /api/internal/tenant/{tenantId}/folder/{folderId}/document/{documentId}/signaturePlacement | Get all signaturePlacement Annotations of a document
*FolderApi* | [**generate_document_signature_verification**](docs/FolderApi.md#generate_document_signature_verification) | **POST** /api/internal/tenant/{tenantId}/folder/{folderId}/signature-report | Get the document(s) signature validation report
*FolderApi* | [**get_folder_by_legacy_id**](docs/FolderApi.md#get_folder_by_legacy_id) | **GET** /api/internal/tenant/{tenantId}/folder/by-legacy-id/{legacyId} | Get the current folder and its data, from a &#39;legacyId&#39; (an id set at creation time)
*FolderApi* | [**list_folder_with_columns**](docs/FolderApi.md#list_folder_with_columns) | **POST** /api/internal/tenant/{tenantId}/desk/{deskId}/folder/{state} | 
*FolderApi* | [**list_folders**](docs/FolderApi.md#list_folders) | **POST** /api/internal/tenant/{tenantId}/desk/{deskId}/search/{state} | Query folders
*FolderApi* | [**print_folder**](docs/FolderApi.md#print_folder) | **GET** /api/internal/tenant/{tenantId}/folder/{folderId}/print | Get the PDF printable version of a folder
*FolderApi* | [**send_folder_by_mail**](docs/FolderApi.md#send_folder_by_mail) | **POST** /api/internal/tenant/{tenantId}/folder/{folderId}/mail | Send given folder by mail
*FolderApi* | [**update_folder**](docs/FolderApi.md#update_folder) | **PUT** /api/internal/tenant/{tenantId}/folder/{folderId} | Edit folder parameters
*SecureMailApi* | [**get_secure_mail_status**](docs/SecureMailApi.md#get_secure_mail_status) | **GET** /api/internal/tenant/{tenantId}/folder/{folderId}/task/{taskId}/secure-mail | Get the current state
*ServerInfoApi* | [**get_server_info**](docs/ServerInfoApi.md#get_server_info) | **GET** /api/internal/server-info | Get server information: GDPR definition, password rules and signature validation service activation status
*TemplateApi* | [**test_signature_template**](docs/TemplateApi.md#test_signature_template) | **POST** /api/internal/tenant/{tenantId}/templates/{templateType}/example | Test the tenant signature template
*TenantApi* | [**get_tenant**](docs/TenantApi.md#get_tenant) | **GET** /api/internal/tenant/{tenantId} | Get a tenant with every information set
*TenantApi* | [**list_tenants_for_user**](docs/TenantApi.md#list_tenants_for_user) | **GET** /api/internal/tenant | List tenants attached with the current user
*TypologyApi* | [**get_subtype**](docs/TypologyApi.md#get_subtype) | **GET** /api/internal/tenant/{tenantId}/typology/type/{typeId}/subtype/{subtypeId} | Get a subtype
*TypologyApi* | [**get_type**](docs/TypologyApi.md#get_type) | **GET** /api/internal/tenant/{tenantId}/typology/type/{typeId} | Get a type with every informations set
*WorkflowApi* | [**evaluate_workflow_selection_script**](docs/WorkflowApi.md#evaluate_workflow_selection_script) | **POST** /api/internal/tenant/{tenantId}/desk/{deskId}/evaluate-workflow-selection-script | Returns the evaluated workflow definition, using current parent desks, and given metadata on a possible selection script
*WorkflowApi* | [**get_workflow_definition**](docs/WorkflowApi.md#get_workflow_definition) | **GET** /api/internal/tenant/{tenantId}/desk/{deskId}/workflow-definition/{workflowDefinitionKey} | Get a workflow definition with every information set


## Documentation For Models

 - [Action](docs/Action.md)
 - [ColumnedTaskListRequest](docs/ColumnedTaskListRequest.md)
 - [CompositeId](docs/CompositeId.md)
 - [CreateFileStampRequest](docs/CreateFileStampRequest.md)
 - [CreateFolderRequest](docs/CreateFolderRequest.md)
 - [DelegationDto](docs/DelegationDto.md)
 - [DelegationSortBy](docs/DelegationSortBy.md)
 - [DeskRepresentation](docs/DeskRepresentation.md)
 - [DetachedSignature](docs/DetachedSignature.md)
 - [DetachedSignatureDto](docs/DetachedSignatureDto.md)
 - [DocumentDto](docs/DocumentDto.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ExternalSignatureConfig](docs/ExternalSignatureConfig.md)
 - [ExternalSignatureConfigDto](docs/ExternalSignatureConfigDto.md)
 - [ExternalSignatureConfigRepresentation](docs/ExternalSignatureConfigRepresentation.md)
 - [ExternalSignatureLevel](docs/ExternalSignatureLevel.md)
 - [ExternalSignatureProvider](docs/ExternalSignatureProvider.md)
 - [ExternalState](docs/ExternalState.md)
 - [FolderDto](docs/FolderDto.md)
 - [FolderFilterDto](docs/FolderFilterDto.md)
 - [FolderListableDto](docs/FolderListableDto.md)
 - [FolderSortBy](docs/FolderSortBy.md)
 - [FolderVisibility](docs/FolderVisibility.md)
 - [GdprApplication](docs/GdprApplication.md)
 - [GdprCookie](docs/GdprCookie.md)
 - [GdprDataElement](docs/GdprDataElement.md)
 - [GdprDataSet](docs/GdprDataSet.md)
 - [GdprDeclaringEntity](docs/GdprDeclaringEntity.md)
 - [GdprDeclaringEntityDpo](docs/GdprDeclaringEntityDpo.md)
 - [GdprDeclaringEntityResponsible](docs/GdprDeclaringEntityResponsible.md)
 - [GdprEntity](docs/GdprEntity.md)
 - [GdprInformationDetailsDto](docs/GdprInformationDetailsDto.md)
 - [HierarchisedDeskRepresentation](docs/HierarchisedDeskRepresentation.md)
 - [LabelledColumn](docs/LabelledColumn.md)
 - [LabelledColumnType](docs/LabelledColumnType.md)
 - [LayerDto](docs/LayerDto.md)
 - [LayerRepresentation](docs/LayerRepresentation.md)
 - [MailParams](docs/MailParams.md)
 - [MailTemplateTestRequest](docs/MailTemplateTestRequest.md)
 - [MediaType](docs/MediaType.md)
 - [Metadata](docs/Metadata.md)
 - [MetadataDto](docs/MetadataDto.md)
 - [MetadataRepresentation](docs/MetadataRepresentation.md)
 - [MetadataType](docs/MetadataType.md)
 - [PageDelegationDto](docs/PageDelegationDto.md)
 - [PageDeskRepresentation](docs/PageDeskRepresentation.md)
 - [PageFolderDto](docs/PageFolderDto.md)
 - [PageFolderListableDto](docs/PageFolderListableDto.md)
 - [PageHierarchisedDeskRepresentation](docs/PageHierarchisedDeskRepresentation.md)
 - [PageInfo](docs/PageInfo.md)
 - [PageLayerRepresentation](docs/PageLayerRepresentation.md)
 - [PageSubtypeRepresentation](docs/PageSubtypeRepresentation.md)
 - [PageTenantRepresentation](docs/PageTenantRepresentation.md)
 - [PageTypologyRepresentation](docs/PageTypologyRepresentation.md)
 - [PageableObject](docs/PageableObject.md)
 - [PasswordPolicies](docs/PasswordPolicies.md)
 - [PasswordResetRequest](docs/PasswordResetRequest.md)
 - [PdfSignaturePosition](docs/PdfSignaturePosition.md)
 - [PdfSignaturePositionDto](docs/PdfSignaturePositionDto.md)
 - [PdfTemplateTestRequest](docs/PdfTemplateTestRequest.md)
 - [SealCertificateRepresentation](docs/SealCertificateRepresentation.md)
 - [SecureMailDocument](docs/SecureMailDocument.md)
 - [SecureMailDocumentMailInfo](docs/SecureMailDocumentMailInfo.md)
 - [ServerInfoDto](docs/ServerInfoDto.md)
 - [SignatureFormat](docs/SignatureFormat.md)
 - [SignaturePlacement](docs/SignaturePlacement.md)
 - [SignatureProof](docs/SignatureProof.md)
 - [SignatureProtocol](docs/SignatureProtocol.md)
 - [SortObject](docs/SortObject.md)
 - [StampDto](docs/StampDto.md)
 - [StampTextColor](docs/StampTextColor.md)
 - [StampType](docs/StampType.md)
 - [State](docs/State.md)
 - [StepDefinitionDto](docs/StepDefinitionDto.md)
 - [StepDefinitionParallelType](docs/StepDefinitionParallelType.md)
 - [StepDefinitionType](docs/StepDefinitionType.md)
 - [StickyNote](docs/StickyNote.md)
 - [Subtype](docs/Subtype.md)
 - [SubtypeDto](docs/SubtypeDto.md)
 - [SubtypeLayer](docs/SubtypeLayer.md)
 - [SubtypeLayerAssociation](docs/SubtypeLayerAssociation.md)
 - [SubtypeLayerDto](docs/SubtypeLayerDto.md)
 - [SubtypeMetadata](docs/SubtypeMetadata.md)
 - [SubtypeMetadataDto](docs/SubtypeMetadataDto.md)
 - [SubtypeRepresentation](docs/SubtypeRepresentation.md)
 - [TableLayoutDto](docs/TableLayoutDto.md)
 - [TableName](docs/TableName.md)
 - [Task](docs/Task.md)
 - [TemplateInfo](docs/TemplateInfo.md)
 - [TemplateType](docs/TemplateType.md)
 - [TenantDto](docs/TenantDto.md)
 - [TenantRepresentation](docs/TenantRepresentation.md)
 - [TestSignatureTemplateRequest](docs/TestSignatureTemplateRequest.md)
 - [TypeDto](docs/TypeDto.md)
 - [TypeRepresentation](docs/TypeRepresentation.md)
 - [TypologyRepresentation](docs/TypologyRepresentation.md)
 - [UserPrivilege](docs/UserPrivilege.md)
 - [UserRepresentation](docs/UserRepresentation.md)
 - [ValidatedSignatureInformation](docs/ValidatedSignatureInformation.md)
 - [ValidatedSignatureInformationDto](docs/ValidatedSignatureInformationDto.md)
 - [ValidationServiceConfigurationDto](docs/ValidationServiceConfigurationDto.md)
 - [WorkflowDefinitionDto](docs/WorkflowDefinitionDto.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="spring_oauth"></a>
### spring_oauth

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: ./auth/realms/api/protocol/openid-connect/auth
- **Scopes**: N/A


## Author

iparapheur@libriciel.coop


