# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.desk_representation import DeskRepresentation
from iparapheur_internal.models.subtype_representation import SubtypeRepresentation
from iparapheur_internal.models.type_representation import TypeRepresentation
from typing import Optional, Set
from typing_extensions import Self

class DelegationDto(BaseModel):
    """
    target substitute desk, optional type/subtype; and schedule containing Dates and actions to perform.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    substitute_desk_id: Optional[StrictStr] = Field(default=None, alias="substituteDeskId")
    substitute_desk: Optional[DeskRepresentation] = Field(default=None, alias="substituteDesk")
    type_id: Optional[StrictStr] = Field(default=None, alias="typeId")
    type: Optional[TypeRepresentation] = None
    subtype_id: Optional[StrictStr] = Field(default=None, alias="subtypeId")
    subtype: Optional[SubtypeRepresentation] = None
    start: Optional[datetime] = None
    end: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "substituteDeskId", "substituteDesk", "typeId", "type", "subtypeId", "subtype", "start", "end"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DelegationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of substitute_desk
        if self.substitute_desk:
            _dict['substituteDesk'] = self.substitute_desk.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subtype
        if self.subtype:
            _dict['subtype'] = self.subtype.to_dict()
        # set to None if type_id (nullable) is None
        # and model_fields_set contains the field
        if self.type_id is None and "type_id" in self.model_fields_set:
            _dict['typeId'] = None

        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if subtype_id (nullable) is None
        # and model_fields_set contains the field
        if self.subtype_id is None and "subtype_id" in self.model_fields_set:
            _dict['subtypeId'] = None

        # set to None if subtype (nullable) is None
        # and model_fields_set contains the field
        if self.subtype is None and "subtype" in self.model_fields_set:
            _dict['subtype'] = None

        # set to None if start (nullable) is None
        # and model_fields_set contains the field
        if self.start is None and "start" in self.model_fields_set:
            _dict['start'] = None

        # set to None if end (nullable) is None
        # and model_fields_set contains the field
        if self.end is None and "end" in self.model_fields_set:
            _dict['end'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DelegationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "substituteDeskId": obj.get("substituteDeskId"),
            "substituteDesk": DeskRepresentation.from_dict(obj["substituteDesk"]) if obj.get("substituteDesk") is not None else None,
            "typeId": obj.get("typeId"),
            "type": TypeRepresentation.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "subtypeId": obj.get("subtypeId"),
            "subtype": SubtypeRepresentation.from_dict(obj["subtype"]) if obj.get("subtype") is not None else None,
            "start": obj.get("start"),
            "end": obj.get("end")
        })
        return _obj


