# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iparapheur_internal.models.external_signature_level import ExternalSignatureLevel
from iparapheur_internal.models.external_signature_provider import ExternalSignatureProvider
from typing import Optional, Set
from typing_extensions import Self

class ExternalSignatureConfigDto(BaseModel):
    """
    ExternalSignatureConfigDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[Annotated[str, Field(min_length=2, strict=True, max_length=255)]] = None
    service_name: Optional[ExternalSignatureProvider] = Field(default=None, alias="serviceName")
    signature_level: Optional[ExternalSignatureLevel] = Field(default=None, alias="signatureLevel")
    url: Optional[StrictStr] = None
    login: Optional[StrictStr] = None
    password: Optional[StrictStr] = None
    token: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "serviceName", "signatureLevel", "url", "login", "password", "token"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExternalSignatureConfigDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if token (nullable) is None
        # and model_fields_set contains the field
        if self.token is None and "token" in self.model_fields_set:
            _dict['token'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExternalSignatureConfigDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "serviceName": obj.get("serviceName"),
            "signatureLevel": obj.get("signatureLevel"),
            "url": obj.get("url"),
            "login": obj.get("login"),
            "password": obj.get("password"),
            "token": obj.get("token")
        })
        return _obj


