# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iparapheur_internal.models.gdpr_declaring_entity_dpo import GdprDeclaringEntityDpo
from iparapheur_internal.models.gdpr_declaring_entity_responsible import GdprDeclaringEntityResponsible
from typing import Optional, Set
from typing_extensions import Self

class GdprDeclaringEntity(BaseModel):
    """
    GdprDeclaringEntity
    """ # noqa: E501
    name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = None
    address: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = None
    siret: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = None
    ape_code: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = Field(default=None, alias="apeCode")
    phone_number: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = Field(default=None, alias="phoneNumber")
    mail: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=255)]] = None
    dpo: Optional[GdprDeclaringEntityDpo] = None
    responsible: Optional[GdprDeclaringEntityResponsible] = None
    __properties: ClassVar[List[str]] = ["name", "address", "siret", "apeCode", "phoneNumber", "mail", "dpo", "responsible"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GdprDeclaringEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dpo
        if self.dpo:
            _dict['dpo'] = self.dpo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of responsible
        if self.responsible:
            _dict['responsible'] = self.responsible.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GdprDeclaringEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "address": obj.get("address"),
            "siret": obj.get("siret"),
            "apeCode": obj.get("apeCode"),
            "phoneNumber": obj.get("phoneNumber"),
            "mail": obj.get("mail"),
            "dpo": GdprDeclaringEntityDpo.from_dict(obj["dpo"]) if obj.get("dpo") is not None else None,
            "responsible": GdprDeclaringEntityResponsible.from_dict(obj["responsible"]) if obj.get("responsible") is not None else None
        })
        return _obj


