# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.gdpr_information_details_dto import GdprInformationDetailsDto
from iparapheur_internal.models.password_policies import PasswordPolicies
from typing import Optional, Set
from typing_extensions import Self

class ServerInfoDto(BaseModel):
    """
    ServerInfoDto
    """ # noqa: E501
    gdpr_information_details_dto: Optional[GdprInformationDetailsDto] = Field(default=None, alias="gdprInformationDetailsDto")
    password_policies: Optional[PasswordPolicies] = Field(default=None, alias="passwordPolicies")
    signature_validation_service_activated: Optional[StrictBool] = Field(default=None, alias="signatureValidationServiceActivated")
    __properties: ClassVar[List[str]] = ["gdprInformationDetailsDto", "passwordPolicies", "signatureValidationServiceActivated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServerInfoDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of gdpr_information_details_dto
        if self.gdpr_information_details_dto:
            _dict['gdprInformationDetailsDto'] = self.gdpr_information_details_dto.to_dict()
        # override the default output from pydantic by calling `to_dict()` of password_policies
        if self.password_policies:
            _dict['passwordPolicies'] = self.password_policies.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServerInfoDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "gdprInformationDetailsDto": GdprInformationDetailsDto.from_dict(obj["gdprInformationDetailsDto"]) if obj.get("gdprInformationDetailsDto") is not None else None,
            "passwordPolicies": PasswordPolicies.from_dict(obj["passwordPolicies"]) if obj.get("passwordPolicies") is not None else None,
            "signatureValidationServiceActivated": obj.get("signatureValidationServiceActivated")
        })
        return _obj


