# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.desk_representation import DeskRepresentation
from iparapheur_internal.models.metadata_dto import MetadataDto
from iparapheur_internal.models.step_definition_parallel_type import StepDefinitionParallelType
from iparapheur_internal.models.step_definition_type import StepDefinitionType
from typing import Optional, Set
from typing_extensions import Self

class StepDefinitionDto(BaseModel):
    """
    StepDefinitionDto
    """ # noqa: E501
    type: Optional[StepDefinitionType] = None
    validating_desk_ids: Optional[List[StrictStr]] = Field(default=None, alias="validatingDeskIds")
    validating_desks: Optional[List[DeskRepresentation]] = Field(default=None, alias="validatingDesks")
    notified_desk_ids: Optional[List[StrictStr]] = Field(default=None, alias="notifiedDeskIds")
    notified_desks: Optional[List[DeskRepresentation]] = Field(default=None, alias="notifiedDesks")
    mandatory_validation_metadata_ids: Optional[List[StrictStr]] = Field(default=None, alias="mandatoryValidationMetadataIds")
    mandatory_validation_metadata: Optional[List[MetadataDto]] = Field(default=None, alias="mandatoryValidationMetadata")
    mandatory_rejection_metadata_ids: Optional[List[StrictStr]] = Field(default=None, alias="mandatoryRejectionMetadataIds")
    mandatory_rejection_metadata: Optional[List[MetadataDto]] = Field(default=None, alias="mandatoryRejectionMetadata")
    parallel_type: Optional[StepDefinitionParallelType] = Field(default=None, alias="parallelType")
    __properties: ClassVar[List[str]] = ["type", "validatingDeskIds", "validatingDesks", "notifiedDeskIds", "notifiedDesks", "mandatoryValidationMetadataIds", "mandatoryValidationMetadata", "mandatoryRejectionMetadataIds", "mandatoryRejectionMetadata", "parallelType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StepDefinitionDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "validating_desks",
            "notified_desks",
            "mandatory_validation_metadata",
            "mandatory_rejection_metadata",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in validating_desks (list)
        _items = []
        if self.validating_desks:
            for _item_validating_desks in self.validating_desks:
                if _item_validating_desks:
                    _items.append(_item_validating_desks.to_dict())
            _dict['validatingDesks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in notified_desks (list)
        _items = []
        if self.notified_desks:
            for _item_notified_desks in self.notified_desks:
                if _item_notified_desks:
                    _items.append(_item_notified_desks.to_dict())
            _dict['notifiedDesks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mandatory_validation_metadata (list)
        _items = []
        if self.mandatory_validation_metadata:
            for _item_mandatory_validation_metadata in self.mandatory_validation_metadata:
                if _item_mandatory_validation_metadata:
                    _items.append(_item_mandatory_validation_metadata.to_dict())
            _dict['mandatoryValidationMetadata'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mandatory_rejection_metadata (list)
        _items = []
        if self.mandatory_rejection_metadata:
            for _item_mandatory_rejection_metadata in self.mandatory_rejection_metadata:
                if _item_mandatory_rejection_metadata:
                    _items.append(_item_mandatory_rejection_metadata.to_dict())
            _dict['mandatoryRejectionMetadata'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StepDefinitionDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "validatingDeskIds": obj.get("validatingDeskIds"),
            "validatingDesks": [DeskRepresentation.from_dict(_item) for _item in obj["validatingDesks"]] if obj.get("validatingDesks") is not None else None,
            "notifiedDeskIds": obj.get("notifiedDeskIds"),
            "notifiedDesks": [DeskRepresentation.from_dict(_item) for _item in obj["notifiedDesks"]] if obj.get("notifiedDesks") is not None else None,
            "mandatoryValidationMetadataIds": obj.get("mandatoryValidationMetadataIds"),
            "mandatoryValidationMetadata": [MetadataDto.from_dict(_item) for _item in obj["mandatoryValidationMetadata"]] if obj.get("mandatoryValidationMetadata") is not None else None,
            "mandatoryRejectionMetadataIds": obj.get("mandatoryRejectionMetadataIds"),
            "mandatoryRejectionMetadata": [MetadataDto.from_dict(_item) for _item in obj["mandatoryRejectionMetadata"]] if obj.get("mandatoryRejectionMetadata") is not None else None,
            "parallelType": obj.get("parallelType")
        })
        return _obj


