# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iparapheur_internal.models.user_privilege import UserPrivilege
from typing import Optional, Set
from typing_extensions import Self

class UserRepresentation(BaseModel):
    """
    UserRepresentation
    """ # noqa: E501
    id: Optional[StrictStr] = None
    user_name: Annotated[str, Field(min_length=1, strict=True, max_length=128)] = Field(alias="userName")
    first_name: Annotated[str, Field(min_length=0, strict=True, max_length=128)] = Field(alias="firstName")
    last_name: Annotated[str, Field(min_length=0, strict=True, max_length=128)] = Field(alias="lastName")
    email: Optional[StrictStr] = None
    privilege: Optional[UserPrivilege] = None
    is_ldap_synchronized: Optional[StrictBool] = Field(default=None, alias="isLdapSynchronized")
    is_from_identity_provider: Optional[StrictBool] = Field(default=None, alias="isFromIdentityProvider")
    __properties: ClassVar[List[str]] = ["id", "userName", "firstName", "lastName", "email", "privilege", "isLdapSynchronized", "isFromIdentityProvider"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserRepresentation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "is_ldap_synchronized",
            "is_from_identity_provider",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserRepresentation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "userName": obj.get("userName"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "email": obj.get("email"),
            "privilege": obj.get("privilege"),
            "isLdapSynchronized": obj.get("isLdapSynchronized"),
            "isFromIdentityProvider": obj.get("isFromIdentityProvider")
        })
        return _obj


