# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.pdf_signature_position_dto import PdfSignaturePositionDto
from typing import Optional, Set
from typing_extensions import Self

class ValidatedSignatureInformationDto(BaseModel):
    """
    ValidatedSignatureInformationDto
    """ # noqa: E501
    signature_date_time: Optional[StrictInt] = Field(default=None, alias="signatureDateTime")
    position: Optional[PdfSignaturePositionDto] = None
    principal_issuer: Optional[StrictStr] = Field(default=None, alias="principalIssuer")
    principal_subject_issuer: Optional[StrictStr] = Field(default=None, alias="principalSubjectIssuer")
    is_signature_valid: Optional[StrictBool] = Field(default=None, alias="isSignatureValid")
    certificate_begin_date: Optional[StrictInt] = Field(default=None, alias="certificateBeginDate")
    certificate_end_date: Optional[StrictInt] = Field(default=None, alias="certificateEndDate")
    eidas_level: Optional[StrictStr] = Field(default=None, alias="eidasLevel")
    error: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["signatureDateTime", "position", "principalIssuer", "principalSubjectIssuer", "isSignatureValid", "certificateBeginDate", "certificateEndDate", "eidasLevel", "error"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ValidatedSignatureInformationDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of position
        if self.position:
            _dict['position'] = self.position.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ValidatedSignatureInformationDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "signatureDateTime": obj.get("signatureDateTime"),
            "position": PdfSignaturePositionDto.from_dict(obj["position"]) if obj.get("position") is not None else None,
            "principalIssuer": obj.get("principalIssuer"),
            "principalSubjectIssuer": obj.get("principalSubjectIssuer"),
            "isSignatureValid": obj.get("isSignatureValid"),
            "certificateBeginDate": obj.get("certificateBeginDate"),
            "certificateEndDate": obj.get("certificateEndDate"),
            "eidasLevel": obj.get("eidasLevel"),
            "error": obj.get("error")
        })
        return _obj


