from maggma.api.resource import ReadOnlyResource
from emmet.core.magnetism import MagnetismDoc

from maggma.api.query_operator import PaginationQuery, SparseFieldsQuery
from emmet.api.routes.materials.magnetism.query_operators import MagneticQuery
from emmet.api.routes.materials.materials.query_operators import MultiMaterialIDQuery
from emmet.api.core.global_header import GlobalHeaderProcessor
from emmet.api.core.settings import MAPISettings


def magnetism_resource(magnetism_store):
    resource = ReadOnlyResource(
        magnetism_store,
        MagnetismDoc,
        query_operators=[
            MultiMaterialIDQuery(),
            MagneticQuery(),
            PaginationQuery(),
            SparseFieldsQuery(
                MagnetismDoc, default_fields=["material_id", "last_updated"]
            ),
        ],
        header_processor=GlobalHeaderProcessor(),
        tags=["Materials Magnetism"],
        sub_path="/magnetism/",
        disable_validation=True,
        timeout=MAPISettings().TIMEOUT,
    )

    return resource
