from maggma.api.resource import ReadOnlyResource
from emmet.core.molecules.metal_binding import MetalBindingDoc

from maggma.api.query_operator import PaginationQuery, SparseFieldsQuery

from emmet.api.routes.molecules.molecules.query_operators import (
    MultiMPculeIDQuery,
    ExactCalcMethodQuery,
    FormulaQuery,
    ChemsysQuery,
    ElementsQuery,
    ChargeSpinQuery,
)
from emmet.api.routes.molecules.metal_binding.query_operators import BindingDataQuery
from emmet.api.routes.molecules.utils import MethodQuery, MultiPropertyIDQuery
from emmet.api.core.settings import MAPISettings
from emmet.api.core.global_header import GlobalHeaderProcessor


def metal_binding_resource(metal_binding_store):
    resource = ReadOnlyResource(
        metal_binding_store,
        MetalBindingDoc,
        query_operators=[
            MultiMPculeIDQuery(),
            ExactCalcMethodQuery(),
            FormulaQuery(),
            ChemsysQuery(),
            ElementsQuery(),
            ChargeSpinQuery(),
            MethodQuery(),
            BindingDataQuery(),
            MultiPropertyIDQuery(),
            PaginationQuery(),
            SparseFieldsQuery(
                MetalBindingDoc,
                default_fields=[
                    "molecule_id",
                    "property_id",
                    "solvent",
                    "method",
                    "last_updated",
                ],
            ),
        ],
        header_processor=GlobalHeaderProcessor(),
        tags=["Molecules Metal Binding"],
        sub_path="/metal_binding/",
        disable_validation=True,
        timeout=MAPISettings().TIMEOUT,
    )

    return resource
