"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from fathom_python.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CreateWebhookTriggeredFor(str, Enum):
    MY_RECORDINGS = "my_recordings"
    SHARED_EXTERNAL_RECORDINGS = "shared_external_recordings"
    MY_SHARED_WITH_TEAM_RECORDINGS = "my_shared_with_team_recordings"
    SHARED_TEAM_RECORDINGS = "shared_team_recordings"


class CreateWebhookRequestTypedDict(TypedDict):
    destination_url: str
    r"""The URL to send the webhook to."""
    triggered_for: List[CreateWebhookTriggeredFor]
    r"""You must send at least one of the following types of recordings to trigger on.
    - `my_recordings`: Your private recordings, as well as those you've shared with individuals. (On Team Plans, this excludes recordings you've shared with any teams.)
    - `shared_external_recordings`: Recordings shared with you by other users. (For Team Plans, this does not include recordings shared by other users on your Team Plan.)
    - `my_shared_with_team_recordings`: (Team Plans only). All recordings that you have shared with other teams (e.g. Marketing or Sales). Recordings you've shared with individuals but not with teams are not included.
    - `shared_team_recordings`: (Team Plans only) All recordings you can access from other users on your Team Plan, whether shared with you individually or with your team.

    """
    include_action_items: NotRequired[bool]
    r"""Include the action items for each meeting."""
    include_crm_matches: NotRequired[bool]
    r"""Include CRM matches for each meeting. Only returns data from your or your team's linked CRM."""
    include_summary: NotRequired[bool]
    r"""Include the summary for each meeting."""
    include_transcript: NotRequired[bool]
    r"""Include the transcript for each meeting."""


class CreateWebhookRequest(BaseModel):
    destination_url: str
    r"""The URL to send the webhook to."""

    triggered_for: List[CreateWebhookTriggeredFor]
    r"""You must send at least one of the following types of recordings to trigger on.
    - `my_recordings`: Your private recordings, as well as those you've shared with individuals. (On Team Plans, this excludes recordings you've shared with any teams.)
    - `shared_external_recordings`: Recordings shared with you by other users. (For Team Plans, this does not include recordings shared by other users on your Team Plan.)
    - `my_shared_with_team_recordings`: (Team Plans only). All recordings that you have shared with other teams (e.g. Marketing or Sales). Recordings you've shared with individuals but not with teams are not included.
    - `shared_team_recordings`: (Team Plans only) All recordings you can access from other users on your Team Plan, whether shared with you individually or with your team.

    """

    include_action_items: Optional[bool] = False
    r"""Include the action items for each meeting."""

    include_crm_matches: Optional[bool] = False
    r"""Include CRM matches for each meeting. Only returns data from your or your team's linked CRM."""

    include_summary: Optional[bool] = False
    r"""Include the summary for each meeting."""

    include_transcript: Optional[bool] = False
    r"""Include the transcript for each meeting."""
