# PostgreSQL Connection Helper

A lightweight Python utility class for connecting to PostgreSQL databases, executing CRUD operations, and performing common table actions (insert, update, delete, add column, etc.).
Supports environment variable configuration.



## 🚀 Features:

* Connect easily to PostgreSQL using direct arguments or environment variables

* Insert single or multiple rows

* Batch inserts using execute_values for high performance

* Conditional inserts with conflict checks (ON CONFLICT DO NOTHING)

* Table maintenance utilities (add columns, update rows, delete rows)

* Check for record existence (check_exists, check_exists_long)

* Fetch specific column values based on conditions

* Clean and explicit API for common database actions


## ⚙️ Usage
1. Basic Connection
    ```
    import pyconnpg 

    db = pyconnpg.Connect(
        host='hostname or IP',
        port=5432,
        db='mydatabase',
        user='myuser',
        password='mypassword'
    )
    ```

2. Using Environment Variables

    You can define these variables in your shell or $HOME/.pgenv file:
    | Variable    | Description                 |
    | ----------- | --------------------------- |
    | `PG_HOST`   | PostgreSQL host             |
    | `PG_PORT`   | PostgreSQL port             |
    | `PG_DB`     | Database name               |
    | `PG_USER`   | Database username           |
    | `PG_PASSWD` | Database password |


    Then, simply initialize:
    ```
    db = Connect()
    ```

## 🧪 Example Workflow

    db = Connect(schema='public', table='products')

    # Insert new record
    db.insert_with_conflict_check('id', id='123', name='Widget', price=9.99)

    # Update a record
    db.update_row('price', 10.99, "id='123'")

    # Verify existence
    if db.check_exists('id', '123'):
        print("Record exists!")

    # Batch insert
    data = [
        {"id": "124", "name": "Gadget", "price": 12.99},
        {"id": "125", "name": "Thingy", "price": 7.99}
    ]
    db.batch_insert(data)

    # Close connection
    db.close()



## 🧱 Requirements

* Python ≥ 3.10

* PostgreSQL ≥ 13

* psycopg2

* cryptography

