## dbt-snowflake 1.10.0 - July 10, 2025

### Features

- Add row_access_policy and table_tag config for Snowflake models ([#697](https://github.com/dbt-labs/dbt-adapters/issues/697))
- Use catalog_name as signifier for logical catalog ([#1134](https://github.com/dbt-labs/dbt-adapters/issues/1134))
- Add support for optional iceberg builtin catalog relation parameters for data retention/extension, storage serialization & change tracking ([#1158](https://github.com/dbt-labs/dbt-adapters/issues/1158))
- Add 's3_stage_vpce_dns_name' session parameter ([#1161](https://github.com/dbt-labs/dbt-adapters/issues/1161))

### Fixes

- Set append=True as default query comment append behaviour ([#1066](https://github.com/dbt-labs/dbt-adapters/issues/1066))
- Apply cluster keys via a separate ALTER statement after creating a table via a CTAS statement. ([#1071](https://github.com/dbt-labs/dbt-adapters/issues/1071))
- Respect QUOTED_IDENTIFIERS_IGNORE_CASE with dynamic tables. ([#993](https://github.com/dbt-labs/dbt-adapters/issues/993))

### Under the Hood

- Remove enable_iceberg_materializations behavior flag now that 2025_01 is required ([#1025](https://github.com/dbt-labs/dbt-adapters/issues/1025))
- Expand snapshot testing. ([#1068](https://github.com/dbt-labs/dbt-adapters/issues/1068))
- Raise the dbt-adapters pin to 1.14.3 to make dbt-adapter dependency resolution more reliable for higher versions of snowflake. ([#1098](https://github.com/dbt-labs/dbt-adapters/issues/1098))
- populate file_format from top level integration config field ([#1134](https://github.com/dbt-labs/dbt-adapters/issues/1134))
- remove reliance on setting session `quoted_identifiers_ignore_case` parameter to normalize snowflake metadata queries ([#1159](https://github.com/dbt-labs/dbt-adapters/issues/1159))

### Dependencies

- update the lower bound for dbt-adapters version in dbt-snowflake to >=1.16 ([#1148](https://github.com/dbt-labs/dbt-adapters/pull/1148))

### Contributors
- [@b-per](https://github.com/b-per) ([#697](https://github.com/dbt-labs/dbt-adapters/issues/697))
- [@csquire](https://github.com/csquire) ([#1161](https://github.com/dbt-labs/dbt-adapters/issues/1161))
- [@mikealfare](https://github.com/mikealfare) ([#1071](https://github.com/dbt-labs/dbt-adapters/issues/1071), [#1025](https://github.com/dbt-labs/dbt-adapters/issues/1025))
- [@peterallenwebb](https://github.com/peterallenwebb) ([#1068](https://github.com/dbt-labs/dbt-adapters/issues/1068))
