import logging
from contextvars import ContextVar
from importlib.metadata import entry_points
from typing import Final, Literal

from wool._cli import WoolPoolCommand, cli
from wool._client import NullClient, WoolClient
from wool._future import WoolFuture
from wool._logging import __log_format__
from wool._pool import WoolPool
from wool._task import (
    WoolTask,
    WoolTaskEvent,
    WoolTaskEventCallback,
    WoolTaskException,
    current_task,
    task,
)
from wool._worker import Worker

# PUBLIC
__log_format__: str = __log_format__

# PUBLIC
__log_level__: int = logging.INFO

# PUBLIC
__wool_client__: Final[ContextVar[WoolClient]] = ContextVar(
    "__wool_client__", default=NullClient()
)

__wool_worker__: Worker | Literal[True] | None = None

__all__ = [
    "WoolTaskException",
    "WoolFuture",
    "WoolTask",
    "WoolTaskEvent",
    "WoolTaskEventCallback",
    "WoolPool",
    "WoolClient",
    "WoolPoolCommand",
    "__log_format__",
    "__log_level__",
    "__wool_client__",
    "cli",
    "current_task",
    "task",
]

for plugin in entry_points(group="wool.cli.plugins"):
    try:
        plugin.load()
        logging.info(f"Loaded CLI plugin {plugin.name}")
    except Exception as e:
        logging.error(f"Failed to load CLI plugin {plugin.name}: {e}")
        continue
