---
mode: 'agent'
description: 'Guide for generating a Python API client from an OpenAPI 3 specification'
---
Explain the following process in a clear, beginner-friendly way:
Topic: Generating a Python API Client from an OpenAPI 3 Spec
Target audience: Developers who are new to working with OpenAPI or client code generation
Please provide:
* A brief overview of what this process achieves
* A step-by-step breakdown of how to do it:
  1. Install the `openapi-python-client` generator via pip
  2. Run the generator on a local OpenAPI JSON file with `--path`
  3. Alternative: Generate directly from a URL with `--url`
  4. Optional flags like `--output-path` to set a directory or `--overwrite` to regenerate
* Explanation of key concepts (e.g., OpenAPI spec, client library, why generate clients instead of writing them manually)
* A simple example of running the command and what files get produced
* Common use cases (e.g., quickly integrating with REST APIs, avoiding manual boilerplate code)
Use clear, simple language and avoid unnecessary jargon.