"""
Synqed - Inbox-based multi-agent communication system.

This module provides high-level abstractions for creating, managing,
and coordinating AI agents using an inbox-based messaging architecture.

Architecture:
- Agents run as microservices with inbox endpoints (POST /inbox, GET /inbox, POST /respond)
- Agents maintain their own internal conversation memory
- MessageRouter routes messages between agents one at a time
- Agents respond with structured JSON: {"send_to": "AgentName", "content": "text"}
- True agent-to-agent communication via structured actions
"""

import asyncio
import aiohttp

from synqed.agent import Agent, AgentLogicContext, ResponseBuilder
from synqed.server import AgentServer
from synqed.memory import AgentMemory, InboxMessage
from synqed.router import MessageRouter
from synqed.planner import PlannerLLM, TaskTreePlan, TaskTreeNode
from synqed.display import MessageDisplay
from synqed.execution_engine import WorkspaceExecutionEngine

__version__ = "2.0.0"

__all__ = [
    # === Core Agent Components ===
    "Agent",
    "AgentLogicContext",
    "ResponseBuilder",
    "AgentServer",
    
    # === Memory ===
    "AgentMemory",
    "InboxMessage",
    
    # === Routing ===
    "MessageRouter",
    
    # === Planning ===
    "PlannerLLM",
    "TaskTreePlan",
    "TaskTreeNode",
    
    # === Execution ===
    "WorkspaceExecutionEngine",
    "MessageDisplay",
    
    # === Utils ===
    "asyncio",
    "aiohttp",
]
