# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.94
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from jfjoch_client.models.dataset_settings_xray_fluorescence_spectrum import DatasetSettingsXrayFluorescenceSpectrum
from jfjoch_client.models.grid_scan import GridScan
from jfjoch_client.models.rotation_axis import RotationAxis
from jfjoch_client.models.unit_cell import UnitCell
from typing import Optional, Set
from typing_extensions import Self

class DatasetSettings(BaseModel):
    """
    DatasetSettings
    """ # noqa: E501
    images_per_trigger: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=1, description="For standard synchrotron data collection - this is number of images collected per one TTL trigger For XFEL (pulsed source) - this number is ignored and set to 1 For storage cell mode - this number is ignored and set to number of storage cells ")
    ntrigger: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=1, description="Number of TTL trigger that the detector is expected to receive during data collection ")
    image_time_us: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Image time.  If not provided (or zero value) the frame time is assumed as default. For JUNGFRAU image time must be multiple of frame time and max value is 256 * frame_time.             In XFEL mode: summation happens for frames collected with multiple triggers. Ignored for storage cells and if raw data are saved. ")
    beam_x_pxl: Union[StrictFloat, StrictInt] = Field(description="/entry/detector/beam_center_x in NXmx Beam center in X direction [pixels] ")
    beam_y_pxl: Union[StrictFloat, StrictInt] = Field(description="/entry/detector/beam_center_y in NXmx Beam center in X direction [pixels] ")
    detector_distance_mm: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="/entry/detector/distance in NXmx Detector distance [mm]")
    incident_energy_ke_v: Union[Annotated[float, Field(le=500.0, strict=True, ge=0.001)], Annotated[int, Field(le=500, strict=True, ge=1)]] = Field(description="Used to calculate /entry/beam/incident_wavelength in NXmx Incident particle (photon, electron) energy in keV ", alias="incident_energy_keV")
    file_prefix: Optional[StrictStr] = Field(default='', description="Prefix for filenames. If left empty, no file will be saved.")
    images_per_file: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=1000, description="Number of files in a single HDF5 data file (0 = write all images to a single data file).")
    space_group_number: Optional[Annotated[int, Field(le=194, strict=True, ge=1)]] = Field(default=None, description="Number of space group for the crystal. Currently used solely as metadata, not relevant for image processing done in Jungfraujoch.")
    sample_name: Optional[StrictStr] = Field(default='', description="/entry/sample/name in NXmx Sample name ")
    compression: Optional[StrictStr] = Field(default='bslz4', description="Compression type for the images transferred over ZeroMQ and saved to HDF5 file. ")
    total_flux: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="/entry/beam/total_flux in NXmx Flux incident on beam plane in photons per second. In other words this is the flux integrated over area. [photons/s] ")
    transmission: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, description="/entry/instrument/attenuator/attenuator_transmission Transmission of attenuator (filter) [no units] ")
    goniometer: Optional[RotationAxis] = None
    grid_scan: Optional[GridScan] = None
    header_appendix: Optional[Any] = Field(default=None, description="Header appendix, added as user_data/user to start ZeroMQ message (can be any valid JSON) In general, it is not saved in HDF5 file.  However, if values are placed in \"hdf5\" object, `jfjoch_writer` will write them in /entry/data of the HDF5 file.  This applies solely to string and number (double floating-point). No arrays/sub-objects is allowed. For example {\"hdf5\": {\"val1\":1, \"val2\":\"xyz\"}}, will write /entry/user/val1 and /entry/user/val2. ")
    image_appendix: Optional[Any] = Field(default=None, description="Image appendix, added as user_data to image ZeroMQ message (can be any valid JSON) Not saved in HDF5 file ")
    data_reduction_factor_serialmx: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=1.0, description="Rate at which non-indexed images are accepted to be forwarded to writer.  Value of 1.0 (default) means that all images are written. Values below zero mean that non-indexed images will be accepted with a given probability. ")
    pixel_value_low_threshold: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Set all counts lower than the value to zero.  When the value is set, negative numbers other than error pixel value are always set to zero. Setting to zero is equivalent to turning the option off. ")
    run_number: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Number of run within an experimental session.  Transferred over CBOR stream as \"series ID\", though not saved in HDF5 file. It is highly recommended to keep this number unique for each data collection during experimental series. If not provided, the number will be automatically incremented. ")
    run_name: Optional[StrictStr] = Field(default=None, description="Unique ID of run. Transferred over CBOR stream as \"unique series ID\", though not saved in HDF5 file. It is highly recommended to keep this name unique for each data collection during experimental series. If not provided, the name will be automatically generated as number + colon + file_prefix. ")
    experiment_group: Optional[StrictStr] = Field(default=None, description="Name of group owning the data (e.g. p-group or proposal number).  Transferred over CBOR stream, though not saved in HDF5 file. ")
    poisson_compression: Optional[Annotated[int, Field(le=16, strict=True, ge=0)]] = Field(default=None, description="Enable lossy compression of pixel values that preserves Poisson statistics.  Requires to provide a numerical factor SQ. Pixel value P will be transformed to round(sqrt(P) * SQ), with rounding to the closest integer. Compression is turned off if the value is missing or it is set to zero. ")
    write_nxmx_hdf5_master: Optional[StrictBool] = Field(default=True, description="Write NXmx formatted HDF5 master file. Recommended to use for macromolecular crystallography experiments and to turn off for other experiments. ")
    save_calibration: Optional[StrictBool] = Field(default=None, description="Forward image calibration (at the moment pedestal and pedestal RMS for JUNGFRAU) using the ZeroMQ stream to writer. If parameter is not provided calibration will be saved only if more than 4 images are recorded. ")
    polarization_factor: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=-1.0)], Annotated[int, Field(le=1, strict=True, ge=-1)]]] = Field(default=None, description="Polarization factor for integration; 1.0 is horizontal polarization; -1.0 is vertical polarization")
    ring_current_m_a: Optional[Union[Annotated[float, Field(strict=True, ge=0.0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, description="Ring current at the beginning of the data collection", alias="ring_current_mA")
    sample_temperature_k: Optional[Union[Annotated[float, Field(strict=True, ge=0.0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, description="Sample temperature in Kelvin", alias="sample_temperature_K")
    poni_rot1_rad: Optional[Union[Annotated[float, Field(le=6.28318530718, strict=True, ge=-6.28318530718)], Annotated[int, Field(le=6, strict=True, ge=-6)]]] = Field(default=0.0, description="PONI angle rot1 (see PyFAI documentation for details) in radians")
    poni_rot2_rad: Optional[Union[Annotated[float, Field(le=6.28318530718, strict=True, ge=-6.28318530718)], Annotated[int, Field(le=6, strict=True, ge=-6)]]] = Field(default=0.0, description="PONI angle rot2 (see PyFAI documentation for details) in radians")
    poni_rot3_rad: Optional[Union[Annotated[float, Field(le=6.28318530718, strict=True, ge=-6.28318530718)], Annotated[int, Field(le=6, strict=True, ge=-6)]]] = Field(default=0.0, description="PONI angle rot3 (see PyFAI documentation for details) in radians")
    unit_cell: Optional[UnitCell] = None
    spot_finding: Optional[StrictBool] = Field(default=True, description="Enable spot finding and save spots")
    max_spot_count: Optional[Annotated[int, Field(le=2000, strict=True, ge=10)]] = Field(default=250, description="Maximum number of spots that are saved/used for indexing; spots with highest intensity are selected")
    detect_ice_rings: Optional[StrictBool] = Field(default=None, description="Flag spots as ice rings and reduce their effect on indexing")
    xray_fluorescence_spectrum: Optional[DatasetSettingsXrayFluorescenceSpectrum] = None
    __properties: ClassVar[List[str]] = ["images_per_trigger", "ntrigger", "image_time_us", "beam_x_pxl", "beam_y_pxl", "detector_distance_mm", "incident_energy_keV", "file_prefix", "images_per_file", "space_group_number", "sample_name", "compression", "total_flux", "transmission", "goniometer", "grid_scan", "header_appendix", "image_appendix", "data_reduction_factor_serialmx", "pixel_value_low_threshold", "run_number", "run_name", "experiment_group", "poisson_compression", "write_nxmx_hdf5_master", "save_calibration", "polarization_factor", "ring_current_mA", "sample_temperature_K", "poni_rot1_rad", "poni_rot2_rad", "poni_rot3_rad", "unit_cell", "spot_finding", "max_spot_count", "detect_ice_rings", "xray_fluorescence_spectrum"]

    @field_validator('compression')
    def compression_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['bslz4', 'bszstd', 'bszstd_rle', 'none']):
            raise ValueError("must be one of enum values ('bslz4', 'bszstd', 'bszstd_rle', 'none')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DatasetSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of goniometer
        if self.goniometer:
            _dict['goniometer'] = self.goniometer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of grid_scan
        if self.grid_scan:
            _dict['grid_scan'] = self.grid_scan.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unit_cell
        if self.unit_cell:
            _dict['unit_cell'] = self.unit_cell.to_dict()
        # override the default output from pydantic by calling `to_dict()` of xray_fluorescence_spectrum
        if self.xray_fluorescence_spectrum:
            _dict['xray_fluorescence_spectrum'] = self.xray_fluorescence_spectrum.to_dict()
        # set to None if header_appendix (nullable) is None
        # and model_fields_set contains the field
        if self.header_appendix is None and "header_appendix" in self.model_fields_set:
            _dict['header_appendix'] = None

        # set to None if image_appendix (nullable) is None
        # and model_fields_set contains the field
        if self.image_appendix is None and "image_appendix" in self.model_fields_set:
            _dict['image_appendix'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DatasetSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "images_per_trigger": obj.get("images_per_trigger") if obj.get("images_per_trigger") is not None else 1,
            "ntrigger": obj.get("ntrigger") if obj.get("ntrigger") is not None else 1,
            "image_time_us": obj.get("image_time_us"),
            "beam_x_pxl": obj.get("beam_x_pxl"),
            "beam_y_pxl": obj.get("beam_y_pxl"),
            "detector_distance_mm": obj.get("detector_distance_mm"),
            "incident_energy_keV": obj.get("incident_energy_keV"),
            "file_prefix": obj.get("file_prefix") if obj.get("file_prefix") is not None else '',
            "images_per_file": obj.get("images_per_file") if obj.get("images_per_file") is not None else 1000,
            "space_group_number": obj.get("space_group_number"),
            "sample_name": obj.get("sample_name") if obj.get("sample_name") is not None else '',
            "compression": obj.get("compression") if obj.get("compression") is not None else 'bslz4',
            "total_flux": obj.get("total_flux"),
            "transmission": obj.get("transmission"),
            "goniometer": RotationAxis.from_dict(obj["goniometer"]) if obj.get("goniometer") is not None else None,
            "grid_scan": GridScan.from_dict(obj["grid_scan"]) if obj.get("grid_scan") is not None else None,
            "header_appendix": obj.get("header_appendix"),
            "image_appendix": obj.get("image_appendix"),
            "data_reduction_factor_serialmx": obj.get("data_reduction_factor_serialmx") if obj.get("data_reduction_factor_serialmx") is not None else 1.0,
            "pixel_value_low_threshold": obj.get("pixel_value_low_threshold"),
            "run_number": obj.get("run_number"),
            "run_name": obj.get("run_name"),
            "experiment_group": obj.get("experiment_group"),
            "poisson_compression": obj.get("poisson_compression"),
            "write_nxmx_hdf5_master": obj.get("write_nxmx_hdf5_master") if obj.get("write_nxmx_hdf5_master") is not None else True,
            "save_calibration": obj.get("save_calibration"),
            "polarization_factor": obj.get("polarization_factor"),
            "ring_current_mA": obj.get("ring_current_mA"),
            "sample_temperature_K": obj.get("sample_temperature_K"),
            "poni_rot1_rad": obj.get("poni_rot1_rad") if obj.get("poni_rot1_rad") is not None else 0.0,
            "poni_rot2_rad": obj.get("poni_rot2_rad") if obj.get("poni_rot2_rad") is not None else 0.0,
            "poni_rot3_rad": obj.get("poni_rot3_rad") if obj.get("poni_rot3_rad") is not None else 0.0,
            "unit_cell": UnitCell.from_dict(obj["unit_cell"]) if obj.get("unit_cell") is not None else None,
            "spot_finding": obj.get("spot_finding") if obj.get("spot_finding") is not None else True,
            "max_spot_count": obj.get("max_spot_count") if obj.get("max_spot_count") is not None else 250,
            "detect_ice_rings": obj.get("detect_ice_rings"),
            "xray_fluorescence_spectrum": DatasetSettingsXrayFluorescenceSpectrum.from_dict(obj["xray_fluorescence_spectrum"]) if obj.get("xray_fluorescence_spectrum") is not None else None
        })
        return _obj


