# coding: utf-8

"""
    Jungfraujoch

    API to control Jungfraujoch developed by the Paul Scherrer Institute (Switzerland). Jungfraujoch is a data acquisition and analysis system for pixel array detectors, primarly PSI JUNGFRAU. Jungfraujoch uses FPGA boards to acquire data at high data rates.  # License Clarification  While this API definition is licensed under GPL-3.0, **the GPL copyleft provisions do not apply** when this file is used solely to generate OpenAPI clients or when implementing applications that interact with the API. Generated client code and applications using this API definition are not subject to the GPL license requirements and may be distributed under terms of your choosing.  This exception is similar in spirit to the Linux Kernel's approach to userspace API headers and the GCC Runtime Library Exception. The Linux Kernel developers have explicitly stated that user programs that merely use the kernel interfaces (syscalls, ioctl definitions, etc.) are not derivative works of the kernel and are not subject to the terms of the GPL.  This exception is intended to allow wider use of this API specification without imposing GPL requirements on applications that merely interact with the API, regardless of whether they communicate through network calls or other mechanisms. 

    The version of the OpenAPI document: 1.0.0-rc.94
    Contact: filip.leonarski@psi.ch
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from jfjoch_client.models.unit_cell import UnitCell
from typing import Optional, Set
from typing_extensions import Self

class ScanResultImagesInner(BaseModel):
    """
    ScanResultImagesInner
    """ # noqa: E501
    efficiency: Union[StrictFloat, StrictInt]
    number: StrictInt = Field(description="Detector image number for a given cell")
    nx: Optional[StrictInt] = Field(default=None, description="Cell position in X for grid scan")
    ny: Optional[StrictInt] = Field(default=None, description="Cell position in Y for grid scan")
    bkg: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Background estimate")
    spots: Optional[StrictInt] = Field(default=None, description="Spot count")
    spots_low_res: Optional[StrictInt] = Field(default=None, description="Spot count in low resolution range")
    spots_indexed: Optional[StrictInt] = Field(default=None, description="Spot count within indexing tolerance")
    spots_ice: Optional[StrictInt] = Field(default=None, description="Spot count within common ice ring resolutions")
    index: Optional[StrictInt] = Field(default=None, description="Indexing solution")
    pr: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Profile radius, i.e. how far reflections are from the Ewald sphere")
    b: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="B-Factor estimate")
    uc: Optional[UnitCell] = None
    xfel_pulseid: Optional[StrictInt] = Field(default=None, description="XFEL pulse ID")
    pixel_sum: Optional[StrictInt] = Field(default=None, description="Total sum of all pixels")
    max: Optional[StrictInt] = Field(default=None, description="Max viable pixel")
    sat: Optional[StrictInt] = Field(default=None, description="Number of saturated pixels")
    err: Optional[StrictInt] = Field(default=None, description="Number of error pixels")
    res: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Diffraction resolution estimate")
    __properties: ClassVar[List[str]] = ["efficiency", "number", "nx", "ny", "bkg", "spots", "spots_low_res", "spots_indexed", "spots_ice", "index", "pr", "b", "uc", "xfel_pulseid", "pixel_sum", "max", "sat", "err", "res"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScanResultImagesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of uc
        if self.uc:
            _dict['uc'] = self.uc.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScanResultImagesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "efficiency": obj.get("efficiency"),
            "number": obj.get("number"),
            "nx": obj.get("nx"),
            "ny": obj.get("ny"),
            "bkg": obj.get("bkg"),
            "spots": obj.get("spots"),
            "spots_low_res": obj.get("spots_low_res"),
            "spots_indexed": obj.get("spots_indexed"),
            "spots_ice": obj.get("spots_ice"),
            "index": obj.get("index"),
            "pr": obj.get("pr"),
            "b": obj.get("b"),
            "uc": UnitCell.from_dict(obj["uc"]) if obj.get("uc") is not None else None,
            "xfel_pulseid": obj.get("xfel_pulseid"),
            "pixel_sum": obj.get("pixel_sum"),
            "max": obj.get("max"),
            "sat": obj.get("sat"),
            "err": obj.get("err"),
            "res": obj.get("res")
        })
        return _obj


