from fastapi import APIRouter
from . import models, chat, complete, tokens

def add_routes(router: APIRouter) -> APIRouter:
    router.add_api_route(
        '/v1/models',
        models.get_models,
        methods=['GET'],
        response_model=models.ModelResponse,
        tags=['Anthropic'],
    )

    router.add_api_route(
        '/v1/models/{model_id}',
        models.get_model,
        methods=['GET'],
        response_model=models.ModelItem,
        tags=['Anthropic'],
    )

    router.add_api_route(
        '/v1/messages',
        chat.create_chat_message,
        methods=['POST'],
        response_model=chat.MessagesResponse,
        tags=['Anthropic'],
    )

    router.add_api_route(
        '/v1/messages/count_tokens',
        tokens.count_messages_tokens,
        methods=['POST'],
        response_model=tokens.CountTokensResponse,
        tags=['Anthropic'],
    )

    router.add_api_route(
        '/v1/complete',
        complete.create_completion,
        methods=['POST'],
        response_model=complete.CompleteResponse,
        tags=['Anthropic'],
    )

    return router
