# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from datetime import datetime

from pydantic.v1 import Field, StrictBool, StrictStr, conint, conlist, constr, validator

from typing import Optional

from lusid.models.compliance_rule_response import ComplianceRuleResponse
from lusid.models.compliance_rule_result_v2 import ComplianceRuleResultV2
from lusid.models.compliance_rule_template import ComplianceRuleTemplate
from lusid.models.compliance_run_configuration import ComplianceRunConfiguration
from lusid.models.compliance_run_info_v2 import ComplianceRunInfoV2
from lusid.models.compliance_template import ComplianceTemplate
from lusid.models.create_compliance_template_request import CreateComplianceTemplateRequest
from lusid.models.decorated_compliance_run_summary import DecoratedComplianceRunSummary
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.paged_resource_list_of_compliance_rule_response import PagedResourceListOfComplianceRuleResponse
from lusid.models.paged_resource_list_of_compliance_run_info_v2 import PagedResourceListOfComplianceRunInfoV2
from lusid.models.paged_resource_list_of_compliance_template import PagedResourceListOfComplianceTemplate
from lusid.models.paged_resource_list_of_order_breach_history import PagedResourceListOfOrderBreachHistory
from lusid.models.update_compliance_template_request import UpdateComplianceTemplateRequest
from lusid.models.upsert_compliance_rule_request import UpsertComplianceRuleRequest
from lusid.models.upsert_compliance_run_summary_request import UpsertComplianceRunSummaryRequest
from lusid.models.upsert_compliance_run_summary_result import UpsertComplianceRunSummaryResult

from lusid.api_client import ApiClient
from lusid.api_response import ApiResponse
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class ComplianceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], create_compliance_template_request : Annotated[CreateComplianceTemplateRequest, Field(..., description="Request to create a compliance rule template.")], **kwargs) -> ComplianceRuleTemplate:  # noqa: E501
        ...

    @overload
    def create_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], create_compliance_template_request : Annotated[CreateComplianceTemplateRequest, Field(..., description="Request to create a compliance rule template.")], async_req: Optional[bool]=True, **kwargs) -> ComplianceRuleTemplate:  # noqa: E501
        ...

    @validate_arguments
    def create_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], create_compliance_template_request : Annotated[CreateComplianceTemplateRequest, Field(..., description="Request to create a compliance rule template.")], async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRuleTemplate, Awaitable[ComplianceRuleTemplate]]:  # noqa: E501
        """[EARLY ACCESS] CreateComplianceTemplate: Create a Compliance Rule Template  # noqa: E501

        Use this endpoint to create a compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_compliance_template(scope, create_compliance_template_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Compliance Rule Template. (required)
        :type scope: str
        :param create_compliance_template_request: Request to create a compliance rule template. (required)
        :type create_compliance_template_request: CreateComplianceTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_compliance_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_compliance_template_with_http_info(scope, create_compliance_template_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_compliance_template_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], create_compliance_template_request : Annotated[CreateComplianceTemplateRequest, Field(..., description="Request to create a compliance rule template.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] CreateComplianceTemplate: Create a Compliance Rule Template  # noqa: E501

        Use this endpoint to create a compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_compliance_template_with_http_info(scope, create_compliance_template_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Compliance Rule Template. (required)
        :type scope: str
        :param create_compliance_template_request: Request to create a compliance rule template. (required)
        :type create_compliance_template_request: CreateComplianceTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRuleTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'create_compliance_template_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_compliance_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_compliance_template_request'] is not None:
            _body_params = _params['create_compliance_template_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "ComplianceRuleTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates/{scope}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_compliance_rule(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_compliance_rule(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_compliance_rule(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeleteComplianceRule: Delete compliance rule.  # noqa: E501

        Use this endpoint to delete a compliance rule. The rule will be recoverable for asat times earlier than the  delete time, but will otherwise appear to have never existed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_compliance_rule(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_compliance_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_compliance_rule_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_compliance_rule_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteComplianceRule: Delete compliance rule.  # noqa: E501

        Use this endpoint to delete a compliance rule. The rule will be recoverable for asat times earlier than the  delete time, but will otherwise appear to have never existed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_compliance_rule_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_compliance_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the template to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the template to be deleted.")], **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @overload
    def delete_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the template to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the template to be deleted.")], async_req: Optional[bool]=True, **kwargs) -> DeletedEntityResponse:  # noqa: E501
        ...

    @validate_arguments
    def delete_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the template to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the template to be deleted.")], async_req: Optional[bool]=None, **kwargs) -> Union[DeletedEntityResponse, Awaitable[DeletedEntityResponse]]:  # noqa: E501
        """[EARLY ACCESS] DeleteComplianceTemplate: Delete a ComplianceRuleTemplate  # noqa: E501

        Delete the compliance rule template uniquely defined by the scope and code.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_compliance_template(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the template to be deleted. (required)
        :type scope: str
        :param code: The code of the template to be deleted. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_compliance_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_compliance_template_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_compliance_template_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the template to be deleted.")], code : Annotated[StrictStr, Field(..., description="The code of the template to be deleted.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] DeleteComplianceTemplate: Delete a ComplianceRuleTemplate  # noqa: E501

        Delete the compliance rule template uniquely defined by the scope and code.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_compliance_template_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the template to be deleted. (required)
        :type scope: str
        :param code: The code of the template to be deleted. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DeletedEntityResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_compliance_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DeletedEntityResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates/{scope}/{code}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_compliance_rule(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time for query.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.")] = None, **kwargs) -> ComplianceRuleResponse:  # noqa: E501
        ...

    @overload
    def get_compliance_rule(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time for query.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.")] = None, async_req: Optional[bool]=True, **kwargs) -> ComplianceRuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def get_compliance_rule(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time for query.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRuleResponse, Awaitable[ComplianceRuleResponse]]:  # noqa: E501
        """[EARLY ACCESS] GetComplianceRule: Get compliance rule.  # noqa: E501

        Use this endpoint to retrieve a single compliance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule(scope, code, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param as_at: Optional. Asat time for query.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_compliance_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_compliance_rule_with_http_info(scope, code, as_at, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def get_compliance_rule_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The compliance rule's scope.")], code : Annotated[StrictStr, Field(..., description="The compliance rule's code.")], as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time for query.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetComplianceRule: Get compliance rule.  # noqa: E501

        Use this endpoint to retrieve a single compliance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule_with_http_info(scope, code, as_at, property_keys, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param as_at: Optional. Asat time for query.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compliance_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceRuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_compliance_rule_result(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], run_code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Rule Scope.")], rule_code : Annotated[StrictStr, Field(..., description="Required: Rule Code.")], **kwargs) -> ComplianceRuleResultV2:  # noqa: E501
        ...

    @overload
    def get_compliance_rule_result(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], run_code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Rule Scope.")], rule_code : Annotated[StrictStr, Field(..., description="Required: Rule Code.")], async_req: Optional[bool]=True, **kwargs) -> ComplianceRuleResultV2:  # noqa: E501
        ...

    @validate_arguments
    def get_compliance_rule_result(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], run_code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Rule Scope.")], rule_code : Annotated[StrictStr, Field(..., description="Required: Rule Code.")], async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRuleResultV2, Awaitable[ComplianceRuleResultV2]]:  # noqa: E501
        """[EARLY ACCESS] GetComplianceRuleResult: Get detailed results for a specific rule within a compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check, and the scope and code of a rule within that run, to get detailed results for that rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule_result(run_scope, run_code, rule_scope, rule_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Run Scope. (required)
        :type run_scope: str
        :param run_code: Required: Run Code. (required)
        :type run_code: str
        :param rule_scope: Required: Rule Scope. (required)
        :type rule_scope: str
        :param rule_code: Required: Rule Code. (required)
        :type rule_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleResultV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_compliance_rule_result_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_compliance_rule_result_with_http_info(run_scope, run_code, rule_scope, rule_code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_compliance_rule_result_with_http_info(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], run_code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Rule Scope.")], rule_code : Annotated[StrictStr, Field(..., description="Required: Rule Code.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetComplianceRuleResult: Get detailed results for a specific rule within a compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check, and the scope and code of a rule within that run, to get detailed results for that rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule_result_with_http_info(run_scope, run_code, rule_scope, rule_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Run Scope. (required)
        :type run_scope: str
        :param run_code: Required: Run Code. (required)
        :type run_code: str
        :param rule_scope: Required: Rule Scope. (required)
        :type rule_scope: str
        :param rule_code: Required: Rule Code. (required)
        :type rule_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRuleResultV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'run_scope',
            'run_code',
            'rule_scope',
            'rule_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compliance_rule_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['run_scope']:
            _path_params['runScope'] = _params['run_scope']

        if _params['run_code']:
            _path_params['runCode'] = _params['run_code']

        if _params['rule_scope']:
            _path_params['ruleScope'] = _params['rule_scope']

        if _params['rule_code']:
            _path_params['ruleCode'] = _params['rule_code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceRuleResultV2",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/summary/{runScope}/{runCode}/{ruleScope}/{ruleCode}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="Scope of TemplateID")], code : Annotated[StrictStr, Field(..., description="Code of TemplateID")], as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, **kwargs) -> ComplianceTemplate:  # noqa: E501
        ...

    @overload
    def get_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="Scope of TemplateID")], code : Annotated[StrictStr, Field(..., description="Code of TemplateID")], as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, async_req: Optional[bool]=True, **kwargs) -> ComplianceTemplate:  # noqa: E501
        ...

    @validate_arguments
    def get_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="Scope of TemplateID")], code : Annotated[StrictStr, Field(..., description="Code of TemplateID")], as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceTemplate, Awaitable[ComplianceTemplate]]:  # noqa: E501
        """[EARLY ACCESS] GetComplianceTemplate: Get the requested compliance template.  # noqa: E501

        Use this endpoint to fetch a specific compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_template(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of TemplateID (required)
        :type scope: str
        :param code: Code of TemplateID (required)
        :type code: str
        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_compliance_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_compliance_template_with_http_info(scope, code, as_at, **kwargs)  # noqa: E501

    @validate_arguments
    def get_compliance_template_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Scope of TemplateID")], code : Annotated[StrictStr, Field(..., description="Code of TemplateID")], as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetComplianceTemplate: Get the requested compliance template.  # noqa: E501

        Use this endpoint to fetch a specific compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_template_with_http_info(scope, code, as_at, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of TemplateID (required)
        :type scope: str
        :param code: Code of TemplateID (required)
        :type code: str
        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'as_at'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compliance_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates/{scope}/{code}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_decorated_compliance_run_summary(self, scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], **kwargs) -> DecoratedComplianceRunSummary:  # noqa: E501
        ...

    @overload
    def get_decorated_compliance_run_summary(self, scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], async_req: Optional[bool]=True, **kwargs) -> DecoratedComplianceRunSummary:  # noqa: E501
        ...

    @validate_arguments
    def get_decorated_compliance_run_summary(self, scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], async_req: Optional[bool]=None, **kwargs) -> Union[DecoratedComplianceRunSummary, Awaitable[DecoratedComplianceRunSummary]]:  # noqa: E501
        """[EARLY ACCESS] GetDecoratedComplianceRunSummary: Get decorated summary results for a specific compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check to get an overview of result details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_decorated_compliance_run_summary(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Required: Run Scope. (required)
        :type scope: str
        :param code: Required: Run Code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DecoratedComplianceRunSummary
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_decorated_compliance_run_summary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_decorated_compliance_run_summary_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def get_decorated_compliance_run_summary_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="Required: Run Scope.")], code : Annotated[StrictStr, Field(..., description="Required: Run Code.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] GetDecoratedComplianceRunSummary: Get decorated summary results for a specific compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check to get an overview of result details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_decorated_compliance_run_summary_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Required: Run Scope. (required)
        :type scope: str
        :param code: Required: Run Code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DecoratedComplianceRunSummary, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decorated_compliance_run_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "DecoratedComplianceRunSummary",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/summary/{scope}/{code}/$decorate', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_compliance_rules(self, as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. Pagination token.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. Entries per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Filter.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.")] = None, **kwargs) -> PagedResourceListOfComplianceRuleResponse:  # noqa: E501
        ...

    @overload
    def list_compliance_rules(self, as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. Pagination token.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. Entries per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Filter.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfComplianceRuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def list_compliance_rules(self, as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. Pagination token.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. Entries per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Filter.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfComplianceRuleResponse, Awaitable[PagedResourceListOfComplianceRuleResponse]]:  # noqa: E501
        """[EARLY ACCESS] ListComplianceRules: List compliance rules.  # noqa: E501

        Use this endpoint to retrieve all compliance rules, or a subset defined by an optional filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_rules(as_at, page, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Asat time.
        :type as_at: datetime
        :param page: Optional. Pagination token.
        :type page: str
        :param limit: Optional. Entries per page.
        :type limit: int
        :param filter: Optional. Filter.
        :type filter: str
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfComplianceRuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_compliance_rules_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_compliance_rules_with_http_info(as_at, page, limit, filter, property_keys, **kwargs)  # noqa: E501

    @validate_arguments
    def list_compliance_rules_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="Optional. Asat time.")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. Pagination token.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. Entries per page.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Filter.")] = None, property_keys : Annotated[Optional[conlist(StrictStr)], Field(description="A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListComplianceRules: List compliance rules.  # noqa: E501

        Use this endpoint to retrieve all compliance rules, or a subset defined by an optional filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_rules_with_http_info(as_at, page, limit, filter, property_keys, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Asat time.
        :type as_at: datetime
        :param page: Optional. Pagination token.
        :type page: str
        :param limit: Optional. Entries per page.
        :type limit: int
        :param filter: Optional. Filter.
        :type filter: str
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.
        :type property_keys: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfComplianceRuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_compliance_rules" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('property_keys') is not None:  # noqa: E501
            _query_params.append(('propertyKeys', _params['property_keys']))
            _collection_formats['propertyKeys'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfComplianceRuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_compliance_runs(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, **kwargs) -> PagedResourceListOfComplianceRunInfoV2:  # noqa: E501
        ...

    @overload
    def list_compliance_runs(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfComplianceRunInfoV2:  # noqa: E501
        ...

    @validate_arguments
    def list_compliance_runs(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfComplianceRunInfoV2, Awaitable[PagedResourceListOfComplianceRunInfoV2]]:  # noqa: E501
        """[EARLY ACCESS] ListComplianceRuns: List historical compliance run identifiers.  # noqa: E501

        Lists RunIds of prior compliance runs, or a subset with a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_runs(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfComplianceRunInfoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_compliance_runs_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_compliance_runs_with_http_info(as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_compliance_runs_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListComplianceRuns: List historical compliance run identifiers.  # noqa: E501

        Lists RunIds of prior compliance runs, or a subset with a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_runs_with_http_info(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfComplianceRunInfoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_compliance_runs" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfComplianceRunInfoV2",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_compliance_templates(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> PagedResourceListOfComplianceTemplate:  # noqa: E501
        ...

    @overload
    def list_compliance_templates(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfComplianceTemplate:  # noqa: E501
        ...

    @validate_arguments
    def list_compliance_templates(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfComplianceTemplate, Awaitable[PagedResourceListOfComplianceTemplate]]:  # noqa: E501
        """[EARLY ACCESS] ListComplianceTemplates: List compliance templates.  # noqa: E501

        Use this endpoint to fetch a list of all available compliance template ids, or a subset using a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_templates(as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfComplianceTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_compliance_templates_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_compliance_templates_with_http_info(as_at, page, limit, filter, **kwargs)  # noqa: E501

    @validate_arguments
    def list_compliance_templates_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] ListComplianceTemplates: List compliance templates.  # noqa: E501

        Use this endpoint to fetch a list of all available compliance template ids, or a subset using a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_templates_with_http_info(as_at, page, limit, filter, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfComplianceTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_compliance_templates" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfComplianceTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_order_breach_history(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing historical order breaches from a previous call to list historical order breaches.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, **kwargs) -> PagedResourceListOfOrderBreachHistory:  # noqa: E501
        ...

    @overload
    def list_order_breach_history(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing historical order breaches from a previous call to list historical order breaches.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, async_req: Optional[bool]=True, **kwargs) -> PagedResourceListOfOrderBreachHistory:  # noqa: E501
        ...

    @validate_arguments
    def list_order_breach_history(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing historical order breaches from a previous call to list historical order breaches.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[PagedResourceListOfOrderBreachHistory, Awaitable[PagedResourceListOfOrderBreachHistory]]:  # noqa: E501
        """[EXPERIMENTAL] ListOrderBreachHistory: List Historical Order Breaches.  # noqa: E501

        Lists Order Ids and Run Ids of prior compliance runs, with the breached Rules Ids specified, or a subset with a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_breach_history(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing historical order breaches from a previous call to list historical order breaches.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfOrderBreachHistory
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_order_breach_history_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_order_breach_history_with_http_info(as_at, page, limit, filter, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_order_breach_history_with_http_info(self, as_at : Annotated[Optional[datetime], Field(description="Optional. The time at which to get results from. Default : latest")] = None, page : Annotated[Optional[StrictStr], Field( description="Optional. The pagination token to use to continue listing historical order breaches from a previous call to list historical order breaches.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.")] = None, limit : Annotated[Optional[conint(strict=True)], Field(description="Optional. When paginating, limit the number of returned results to this many.")] = None, filter : Annotated[Optional[StrictStr], Field( description="Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.")] = None, sort_by : Annotated[Optional[conlist(StrictStr)], Field(description="Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EXPERIMENTAL] ListOrderBreachHistory: List Historical Order Breaches.  # noqa: E501

        Lists Order Ids and Run Ids of prior compliance runs, with the breached Rules Ids specified, or a subset with a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_order_breach_history_with_http_info(as_at, page, limit, filter, sort_by, async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing historical order breaches from a previous call to list historical order breaches.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PagedResourceListOfOrderBreachHistory, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_order_breach_history" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('as_at') is not None:  # noqa: E501
            if isinstance(_params['as_at'], datetime):
                _query_params.append(('asAt', _params['as_at'].strftime(self.api_client.configuration.datetime_format)))
            else:
                _query_params.append(('asAt', _params['as_at']))

        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('filter') is not None:  # noqa: E501
            _query_params.append(('filter', _params['filter']))

        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sortBy', _params['sort_by']))
            _collection_formats['sortBy'] = 'multi'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "PagedResourceListOfOrderBreachHistory",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/breaches', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def run_compliance(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], is_pre_trade : Annotated[StrictBool, Field(..., description="Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], **kwargs) -> ComplianceRunInfoV2:  # noqa: E501
        ...

    @overload
    def run_compliance(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], is_pre_trade : Annotated[StrictBool, Field(..., description="Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], async_req: Optional[bool]=True, **kwargs) -> ComplianceRunInfoV2:  # noqa: E501
        ...

    @validate_arguments
    def run_compliance(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], is_pre_trade : Annotated[StrictBool, Field(..., description="Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRunInfoV2, Awaitable[ComplianceRunInfoV2]]:  # noqa: E501
        """[EARLY ACCESS] RunCompliance: Run a compliance check.  # noqa: E501

        Use this endpoint to run a compliance check using rules from a specific scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_compliance(run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Scope to save the run results in. (required)
        :type run_scope: str
        :param rule_scope: Required: Scope from which to select rules to be run. (required)
        :type rule_scope: str
        :param is_pre_trade: Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false (required)
        :type is_pre_trade: bool
        :param recipe_id_scope: Required: the scope of the recipe to be used (required)
        :type recipe_id_scope: str
        :param recipe_id_code: Required: The code of the recipe to be used. If left blank, the default recipe will be used. (required)
        :type recipe_id_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRunInfoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the run_compliance_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.run_compliance_with_http_info(run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, **kwargs)  # noqa: E501

    @validate_arguments
    def run_compliance_with_http_info(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], is_pre_trade : Annotated[StrictBool, Field(..., description="Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] RunCompliance: Run a compliance check.  # noqa: E501

        Use this endpoint to run a compliance check using rules from a specific scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_compliance_with_http_info(run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Scope to save the run results in. (required)
        :type run_scope: str
        :param rule_scope: Required: Scope from which to select rules to be run. (required)
        :type rule_scope: str
        :param is_pre_trade: Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false (required)
        :type is_pre_trade: bool
        :param recipe_id_scope: Required: the scope of the recipe to be used (required)
        :type recipe_id_scope: str
        :param recipe_id_code: Required: The code of the recipe to be used. If left blank, the default recipe will be used. (required)
        :type recipe_id_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRunInfoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'run_scope',
            'rule_scope',
            'is_pre_trade',
            'recipe_id_scope',
            'recipe_id_code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_compliance" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('run_scope') is not None:  # noqa: E501
            _query_params.append(('runScope', _params['run_scope']))

        if _params.get('rule_scope') is not None:  # noqa: E501
            _query_params.append(('ruleScope', _params['rule_scope']))

        if _params.get('is_pre_trade') is not None:  # noqa: E501
            _query_params.append(('isPreTrade', _params['is_pre_trade']))

        if _params.get('recipe_id_scope') is not None:  # noqa: E501
            _query_params.append(('recipeIdScope', _params['recipe_id_scope']))

        if _params.get('recipe_id_code') is not None:  # noqa: E501
            _query_params.append(('recipeIdCode', _params['recipe_id_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceRunInfoV2",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def run_compliance_preview(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], compliance_run_configuration : Annotated[Optional[ComplianceRunConfiguration], Field(description="Configuration options for the compliance run.")] = None, **kwargs) -> ComplianceRunInfoV2:  # noqa: E501
        ...

    @overload
    def run_compliance_preview(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], compliance_run_configuration : Annotated[Optional[ComplianceRunConfiguration], Field(description="Configuration options for the compliance run.")] = None, async_req: Optional[bool]=True, **kwargs) -> ComplianceRunInfoV2:  # noqa: E501
        ...

    @validate_arguments
    def run_compliance_preview(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], compliance_run_configuration : Annotated[Optional[ComplianceRunConfiguration], Field(description="Configuration options for the compliance run.")] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRunInfoV2, Awaitable[ComplianceRunInfoV2]]:  # noqa: E501
        """[EARLY ACCESS] RunCompliancePreview: Run a compliance check.  # noqa: E501

        Use this endpoint to run a compliance check using rules from a specific scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_compliance_preview(run_scope, rule_scope, recipe_id_scope, recipe_id_code, compliance_run_configuration, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Scope to save the run results in. (required)
        :type run_scope: str
        :param rule_scope: Required: Scope from which to select rules to be run. (required)
        :type rule_scope: str
        :param recipe_id_scope: Required: the scope of the recipe to be used (required)
        :type recipe_id_scope: str
        :param recipe_id_code: Required: The code of the recipe to be used. If left blank, the default recipe will be used. (required)
        :type recipe_id_code: str
        :param compliance_run_configuration: Configuration options for the compliance run.
        :type compliance_run_configuration: ComplianceRunConfiguration
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRunInfoV2
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the run_compliance_preview_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.run_compliance_preview_with_http_info(run_scope, rule_scope, recipe_id_scope, recipe_id_code, compliance_run_configuration, **kwargs)  # noqa: E501

    @validate_arguments
    def run_compliance_preview_with_http_info(self, run_scope : Annotated[StrictStr, Field(..., description="Required: Scope to save the run results in.")], rule_scope : Annotated[StrictStr, Field(..., description="Required: Scope from which to select rules to be run.")], recipe_id_scope : Annotated[StrictStr, Field(..., description="Required: the scope of the recipe to be used")], recipe_id_code : Annotated[StrictStr, Field(..., description="Required: The code of the recipe to be used. If left blank, the default recipe will be used.")], compliance_run_configuration : Annotated[Optional[ComplianceRunConfiguration], Field(description="Configuration options for the compliance run.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] RunCompliancePreview: Run a compliance check.  # noqa: E501

        Use this endpoint to run a compliance check using rules from a specific scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_compliance_preview_with_http_info(run_scope, rule_scope, recipe_id_scope, recipe_id_code, compliance_run_configuration, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Scope to save the run results in. (required)
        :type run_scope: str
        :param rule_scope: Required: Scope from which to select rules to be run. (required)
        :type rule_scope: str
        :param recipe_id_scope: Required: the scope of the recipe to be used (required)
        :type recipe_id_scope: str
        :param recipe_id_code: Required: The code of the recipe to be used. If left blank, the default recipe will be used. (required)
        :type recipe_id_code: str
        :param compliance_run_configuration: Configuration options for the compliance run.
        :type compliance_run_configuration: ComplianceRunConfiguration
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRunInfoV2, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'run_scope',
            'rule_scope',
            'recipe_id_scope',
            'recipe_id_code',
            'compliance_run_configuration'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_compliance_preview" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('run_scope') is not None:  # noqa: E501
            _query_params.append(('runScope', _params['run_scope']))

        if _params.get('rule_scope') is not None:  # noqa: E501
            _query_params.append(('ruleScope', _params['rule_scope']))

        if _params.get('recipe_id_scope') is not None:  # noqa: E501
            _query_params.append(('recipeIdScope', _params['recipe_id_scope']))

        if _params.get('recipe_id_code') is not None:  # noqa: E501
            _query_params.append(('recipeIdCode', _params['recipe_id_code']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['compliance_run_configuration'] is not None:
            _body_params = _params['compliance_run_configuration']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceRunInfoV2",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/preview/runs', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], code : Annotated[StrictStr, Field(..., description="The code of the Compliance Rule Template.")], update_compliance_template_request : Annotated[UpdateComplianceTemplateRequest, Field(..., description="Request to update a compliance rule template.")], **kwargs) -> ComplianceRuleTemplate:  # noqa: E501
        ...

    @overload
    def update_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], code : Annotated[StrictStr, Field(..., description="The code of the Compliance Rule Template.")], update_compliance_template_request : Annotated[UpdateComplianceTemplateRequest, Field(..., description="Request to update a compliance rule template.")], async_req: Optional[bool]=True, **kwargs) -> ComplianceRuleTemplate:  # noqa: E501
        ...

    @validate_arguments
    def update_compliance_template(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], code : Annotated[StrictStr, Field(..., description="The code of the Compliance Rule Template.")], update_compliance_template_request : Annotated[UpdateComplianceTemplateRequest, Field(..., description="Request to update a compliance rule template.")], async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRuleTemplate, Awaitable[ComplianceRuleTemplate]]:  # noqa: E501
        """[EARLY ACCESS] UpdateComplianceTemplate: Update a ComplianceRuleTemplate  # noqa: E501

        Use this endpoint to update a specified compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_compliance_template(scope, code, update_compliance_template_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Compliance Rule Template. (required)
        :type scope: str
        :param code: The code of the Compliance Rule Template. (required)
        :type code: str
        :param update_compliance_template_request: Request to update a compliance rule template. (required)
        :type update_compliance_template_request: UpdateComplianceTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleTemplate
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_compliance_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_compliance_template_with_http_info(scope, code, update_compliance_template_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_compliance_template_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope of the Compliance Rule Template.")], code : Annotated[StrictStr, Field(..., description="The code of the Compliance Rule Template.")], update_compliance_template_request : Annotated[UpdateComplianceTemplateRequest, Field(..., description="Request to update a compliance rule template.")], **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpdateComplianceTemplate: Update a ComplianceRuleTemplate  # noqa: E501

        Use this endpoint to update a specified compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_compliance_template_with_http_info(scope, code, update_compliance_template_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Compliance Rule Template. (required)
        :type scope: str
        :param code: The code of the Compliance Rule Template. (required)
        :type code: str
        :param update_compliance_template_request: Request to update a compliance rule template. (required)
        :type update_compliance_template_request: UpdateComplianceTemplateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRuleTemplate, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'update_compliance_template_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_compliance_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_compliance_template_request'] is not None:
            _body_params = _params['update_compliance_template_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceRuleTemplate",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates/{scope}/{code}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_compliance_rule(self, upsert_compliance_rule_request : Optional[UpsertComplianceRuleRequest] = None, **kwargs) -> ComplianceRuleResponse:  # noqa: E501
        ...

    @overload
    def upsert_compliance_rule(self, upsert_compliance_rule_request : Optional[UpsertComplianceRuleRequest] = None, async_req: Optional[bool]=True, **kwargs) -> ComplianceRuleResponse:  # noqa: E501
        ...

    @validate_arguments
    def upsert_compliance_rule(self, upsert_compliance_rule_request : Optional[UpsertComplianceRuleRequest] = None, async_req: Optional[bool]=None, **kwargs) -> Union[ComplianceRuleResponse, Awaitable[ComplianceRuleResponse]]:  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRule: Upsert a compliance rule.  # noqa: E501

        Use this endpoint to upsert a single compliance rule. The template and variation specified must already  exist, as must the portfolio group. The parameters passed must match those required by the template variation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_rule(upsert_compliance_rule_request, async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_rule_request:
        :type upsert_compliance_rule_request: UpsertComplianceRuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_compliance_rule_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_compliance_rule_with_http_info(upsert_compliance_rule_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_compliance_rule_with_http_info(self, upsert_compliance_rule_request : Optional[UpsertComplianceRuleRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRule: Upsert a compliance rule.  # noqa: E501

        Use this endpoint to upsert a single compliance rule. The template and variation specified must already  exist, as must the portfolio group. The parameters passed must match those required by the template variation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_rule_with_http_info(upsert_compliance_rule_request, async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_rule_request:
        :type upsert_compliance_rule_request: UpsertComplianceRuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ComplianceRuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_compliance_rule_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_compliance_rule" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_compliance_rule_request'] is not None:
            _body_params = _params['upsert_compliance_rule_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ComplianceRuleResponse",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def upsert_compliance_run_summary(self, upsert_compliance_run_summary_request : Optional[UpsertComplianceRunSummaryRequest] = None, **kwargs) -> UpsertComplianceRunSummaryResult:  # noqa: E501
        ...

    @overload
    def upsert_compliance_run_summary(self, upsert_compliance_run_summary_request : Optional[UpsertComplianceRunSummaryRequest] = None, async_req: Optional[bool]=True, **kwargs) -> UpsertComplianceRunSummaryResult:  # noqa: E501
        ...

    @validate_arguments
    def upsert_compliance_run_summary(self, upsert_compliance_run_summary_request : Optional[UpsertComplianceRunSummaryRequest] = None, async_req: Optional[bool]=None, **kwargs) -> Union[UpsertComplianceRunSummaryResult, Awaitable[UpsertComplianceRunSummaryResult]]:  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRunSummary: Upsert a compliance run summary.  # noqa: E501

        Use this endpoint to upsert a compliance run result summary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_run_summary(upsert_compliance_run_summary_request, async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_run_summary_request:
        :type upsert_compliance_run_summary_request: UpsertComplianceRunSummaryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertComplianceRunSummaryResult
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the upsert_compliance_run_summary_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.upsert_compliance_run_summary_with_http_info(upsert_compliance_run_summary_request, **kwargs)  # noqa: E501

    @validate_arguments
    def upsert_compliance_run_summary_with_http_info(self, upsert_compliance_run_summary_request : Optional[UpsertComplianceRunSummaryRequest] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRunSummary: Upsert a compliance run summary.  # noqa: E501

        Use this endpoint to upsert a compliance run result summary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_run_summary_with_http_info(upsert_compliance_run_summary_request, async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_run_summary_request:
        :type upsert_compliance_run_summary_request: UpsertComplianceRunSummaryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(UpsertComplianceRunSummaryResult, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'upsert_compliance_run_summary_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_compliance_run_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['upsert_compliance_run_summary_request'] is not None:
            _body_params = _params['upsert_compliance_run_summary_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "UpsertComplianceRunSummaryResult",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/summary', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
