# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt, StrictStr, conlist, constr 
from lusid.models.currency_and_amount import CurrencyAndAmount
from lusid.models.link import Link
from lusid.models.model_property import ModelProperty
from lusid.models.perpetual_property import PerpetualProperty
from lusid.models.resource_id import ResourceId

class JournalEntryLine(BaseModel):
    """
    A Journal Entry line entity.  # noqa: E501
    """
    accounting_date: datetime = Field(..., alias="accountingDate", description="The Journal Entry Line accounting date.")
    activity_date: datetime = Field(..., alias="activityDate", description="The actual date of the activity. Differs from the accounting date when creating journals that would occur in a closed period.")
    portfolio_id: ResourceId = Field(..., alias="portfolioId")
    instrument_id:  StrictStr = Field(...,alias="instrumentId", description="To indicate the instrument of the transaction that the Journal Entry Line posted for, if applicable.") 
    instrument_scope:  StrictStr = Field(...,alias="instrumentScope", description="The scope in which the Journal Entry Line instrument is in.") 
    sub_holding_keys: Optional[Dict[str, PerpetualProperty]] = Field(None, alias="subHoldingKeys", description="The sub-holding properties which are part of the AccountingKey.")
    tax_lot_id:  Optional[StrictStr] = Field(None,alias="taxLotId", description="If the holding type is 'B' (settled cash balance), this is 1. Otherwise, this is the ID of a tax lot if applicable, or the source ID of the original transaction if not.") 
    general_ledger_account_code:  StrictStr = Field(...,alias="generalLedgerAccountCode", description="The code of the account in the general ledger the Journal Entry was posted to.") 
    local: CurrencyAndAmount = Field(...)
    base: CurrencyAndAmount = Field(...)
    units: Union[StrictFloat, StrictInt] = Field(..., description="Units held for the Journal Entry Line.")
    posting_module_code:  Optional[StrictStr] = Field(None,alias="postingModuleCode", description="The code of the posting module where the posting rules derived the Journal Entry lines.") 
    posting_rule:  StrictStr = Field(...,alias="postingRule", description="The rule generating the Journal Entry Line.") 
    as_at_date: datetime = Field(..., alias="asAtDate", description="The corresponding input date and time of the Transaction generating the Journal Entry Line.")
    activities_description:  Optional[StrictStr] = Field(None,alias="activitiesDescription", description="This would be the description of the business activities this Journal Entry Line is for.") 
    source_type:  StrictStr = Field(...,alias="sourceType", description="So far are 4 types: LusidTxn, LusidValuation, Manual and External.") 
    source_id:  StrictStr = Field(...,alias="sourceId", description="For the Lusid Source Type this will be the txn Id. For the rest will be what the user populates.") 
    properties: Optional[Dict[str, ModelProperty]] = Field(None, description="A set of properties for the Abor.")
    movement_name:  Optional[StrictStr] = Field(None,alias="movementName", description="If the JE Line is generated from a transaction, the name of the side in the transaction type's movement. If from a valuation, this is 'MarkToMarket'.") 
    holding_type:  StrictStr = Field(...,alias="holdingType", description="One of the LUSID holding types such as 'P' for position or 'B' for settled cash balance.") 
    economic_bucket:  StrictStr = Field(...,alias="economicBucket", description="LUSID automatically categorises a JE Line into a broad economic bucket such as 'NA_Cost' or 'PL_RealPriceGL'.") 
    economic_bucket_component:  Optional[StrictStr] = Field(None,alias="economicBucketComponent", description="Sub bucket of the economic bucket.") 
    economic_bucket_variant:  Optional[StrictStr] = Field(None,alias="economicBucketVariant", description="Categorisation of a Mark-to-market journal entry line into LongTerm or ShortTerm based on whether the ActivityDate is more than a year after the purchase trade date or not.") 
    levels: Optional[conlist(StrictStr)] = Field(None, description="Resolved data from the general ledger profile where the GeneralLedgerProfileCode is specified in the GetJournalEntryLines request body.")
    source_levels: Optional[conlist(StrictStr)] = Field(None, alias="sourceLevels", description="Source data from the general ledger profile where the GeneralLedgerProfileCode is specified in the GetJournalEntryLines request body.")
    movement_sign:  Optional[StrictStr] = Field(None,alias="movementSign", description="Indicates if the Journal Entry Line corresponds to a Long or Short movement.") 
    holding_sign:  Optional[StrictStr] = Field(None,alias="holdingSign", description="Indicates if the Journal Entry Line is operating against a Long or Short holding.") 
    ledger_column:  Optional[StrictStr] = Field(None,alias="ledgerColumn", description="Indicates if the Journal Entry Line is credit or debit.") 
    journal_entry_line_type:  Optional[StrictStr] = Field(None,alias="journalEntryLineType", description="Indicates the Journal Entry Line type") 
    links: Optional[conlist(Link)] = None
    __properties = ["accountingDate", "activityDate", "portfolioId", "instrumentId", "instrumentScope", "subHoldingKeys", "taxLotId", "generalLedgerAccountCode", "local", "base", "units", "postingModuleCode", "postingRule", "asAtDate", "activitiesDescription", "sourceType", "sourceId", "properties", "movementName", "holdingType", "economicBucket", "economicBucketComponent", "economicBucketVariant", "levels", "sourceLevels", "movementSign", "holdingSign", "ledgerColumn", "journalEntryLineType", "links"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JournalEntryLine:
        """Create an instance of JournalEntryLine from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of portfolio_id
        if self.portfolio_id:
            _dict['portfolioId'] = self.portfolio_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in sub_holding_keys (dict)
        _field_dict = {}
        if self.sub_holding_keys:
            for _key in self.sub_holding_keys:
                if self.sub_holding_keys[_key]:
                    _field_dict[_key] = self.sub_holding_keys[_key].to_dict()
            _dict['subHoldingKeys'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of local
        if self.local:
            _dict['local'] = self.local.to_dict()
        # override the default output from pydantic by calling `to_dict()` of base
        if self.base:
            _dict['base'] = self.base.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        # set to None if sub_holding_keys (nullable) is None
        # and __fields_set__ contains the field
        if self.sub_holding_keys is None and "sub_holding_keys" in self.__fields_set__:
            _dict['subHoldingKeys'] = None

        # set to None if tax_lot_id (nullable) is None
        # and __fields_set__ contains the field
        if self.tax_lot_id is None and "tax_lot_id" in self.__fields_set__:
            _dict['taxLotId'] = None

        # set to None if posting_module_code (nullable) is None
        # and __fields_set__ contains the field
        if self.posting_module_code is None and "posting_module_code" in self.__fields_set__:
            _dict['postingModuleCode'] = None

        # set to None if activities_description (nullable) is None
        # and __fields_set__ contains the field
        if self.activities_description is None and "activities_description" in self.__fields_set__:
            _dict['activitiesDescription'] = None

        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if movement_name (nullable) is None
        # and __fields_set__ contains the field
        if self.movement_name is None and "movement_name" in self.__fields_set__:
            _dict['movementName'] = None

        # set to None if economic_bucket_component (nullable) is None
        # and __fields_set__ contains the field
        if self.economic_bucket_component is None and "economic_bucket_component" in self.__fields_set__:
            _dict['economicBucketComponent'] = None

        # set to None if economic_bucket_variant (nullable) is None
        # and __fields_set__ contains the field
        if self.economic_bucket_variant is None and "economic_bucket_variant" in self.__fields_set__:
            _dict['economicBucketVariant'] = None

        # set to None if levels (nullable) is None
        # and __fields_set__ contains the field
        if self.levels is None and "levels" in self.__fields_set__:
            _dict['levels'] = None

        # set to None if source_levels (nullable) is None
        # and __fields_set__ contains the field
        if self.source_levels is None and "source_levels" in self.__fields_set__:
            _dict['sourceLevels'] = None

        # set to None if movement_sign (nullable) is None
        # and __fields_set__ contains the field
        if self.movement_sign is None and "movement_sign" in self.__fields_set__:
            _dict['movementSign'] = None

        # set to None if holding_sign (nullable) is None
        # and __fields_set__ contains the field
        if self.holding_sign is None and "holding_sign" in self.__fields_set__:
            _dict['holdingSign'] = None

        # set to None if ledger_column (nullable) is None
        # and __fields_set__ contains the field
        if self.ledger_column is None and "ledger_column" in self.__fields_set__:
            _dict['ledgerColumn'] = None

        # set to None if journal_entry_line_type (nullable) is None
        # and __fields_set__ contains the field
        if self.journal_entry_line_type is None and "journal_entry_line_type" in self.__fields_set__:
            _dict['journalEntryLineType'] = None

        # set to None if links (nullable) is None
        # and __fields_set__ contains the field
        if self.links is None and "links" in self.__fields_set__:
            _dict['links'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JournalEntryLine:
        """Create an instance of JournalEntryLine from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return JournalEntryLine.parse_obj(obj)

        _obj = JournalEntryLine.parse_obj({
            "accounting_date": obj.get("accountingDate"),
            "activity_date": obj.get("activityDate"),
            "portfolio_id": ResourceId.from_dict(obj.get("portfolioId")) if obj.get("portfolioId") is not None else None,
            "instrument_id": obj.get("instrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "sub_holding_keys": dict(
                (_k, PerpetualProperty.from_dict(_v))
                for _k, _v in obj.get("subHoldingKeys").items()
            )
            if obj.get("subHoldingKeys") is not None
            else None,
            "tax_lot_id": obj.get("taxLotId"),
            "general_ledger_account_code": obj.get("generalLedgerAccountCode"),
            "local": CurrencyAndAmount.from_dict(obj.get("local")) if obj.get("local") is not None else None,
            "base": CurrencyAndAmount.from_dict(obj.get("base")) if obj.get("base") is not None else None,
            "units": obj.get("units"),
            "posting_module_code": obj.get("postingModuleCode"),
            "posting_rule": obj.get("postingRule"),
            "as_at_date": obj.get("asAtDate"),
            "activities_description": obj.get("activitiesDescription"),
            "source_type": obj.get("sourceType"),
            "source_id": obj.get("sourceId"),
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "movement_name": obj.get("movementName"),
            "holding_type": obj.get("holdingType"),
            "economic_bucket": obj.get("economicBucket"),
            "economic_bucket_component": obj.get("economicBucketComponent"),
            "economic_bucket_variant": obj.get("economicBucketVariant"),
            "levels": obj.get("levels"),
            "source_levels": obj.get("sourceLevels"),
            "movement_sign": obj.get("movementSign"),
            "holding_sign": obj.get("holdingSign"),
            "ledger_column": obj.get("ledgerColumn"),
            "journal_entry_line_type": obj.get("journalEntryLineType"),
            "links": [Link.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj
