# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist, constr, validator 
from lusid.models.mapping_rule import MappingRule

class Mapping(BaseModel):
    """
    Defines the rule set to be used to determine if entries should be considered as a match.  # noqa: E501
    """
    scope:  StrictStr = Field(...,alias="scope", description="The scope for this mapping.") 
    code:  StrictStr = Field(...,alias="code", description="The code for this mapping.") 
    name:  StrictStr = Field(...,alias="name", description="The mapping name") 
    reconciliation_type:  StrictStr = Field(...,alias="reconciliationType", description="What type of reconciliation this mapping is for") 
    rules: Optional[conlist(MappingRule)] = Field(None, description="The rules in this mapping, keyed by the left field/property name")
    __properties = ["scope", "code", "name", "reconciliationType", "rules"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Mapping:
        """Create an instance of Mapping from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item in self.rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rules'] = _items
        # set to None if rules (nullable) is None
        # and __fields_set__ contains the field
        if self.rules is None and "rules" in self.__fields_set__:
            _dict['rules'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Mapping:
        """Create an instance of Mapping from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Mapping.parse_obj(obj)

        _obj = Mapping.parse_obj({
            "scope": obj.get("scope"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "reconciliation_type": obj.get("reconciliationType"),
            "rules": [MappingRule.from_dict(_item) for _item in obj.get("rules")] if obj.get("rules") is not None else None
        })
        return _obj
