---
hide:
  - navigation
---

# 🧪 Scientific contributions

## 📰 Scientific Papers `Sklong` Authored

Within each paper's tab, we will point to which Git branch to see the experiments of a given paper.

=== "Scikit-Longitudinal official paper"

    **Paper Name**: Scikit-Longitudinal: A Machine Learning Library for Longitudinal Classification in Python

    **Dataset Source**: No datasets. No experiments.

    **Paper Link**: [https://doi.org/10.21105/joss.08481](https://doi.org/10.21105/joss.08481)

    **Git branch**: No experiments, but `joss-paper` for the markdown original.


=== "SepWav paper"

    **Paper Name**: A New Longitudinal Classification Method Based on Stacking Predictions for Separate Time Points

    **Dataset Source**: https://www.elsa-project.ac.uk/

    **Git branch**: `papers/sepwav`, then navigate to `experiments/`.

    !!! success "Status"
        Paper has been submitted to a conference (cannot be disclosed yet) and is currently under review.

=== "Lexicographical Trees paper"

    **Paper Name**: Longitudinal Classification Approached with Lexicographically Optimised Deep Forests and Gradient Boosting

    **Dataset Source**: https://www.elsa-project.ac.uk/

    **Git branch**: To be announced.

    !!! warning "Status"
        Experiments completed and results reported in the paper.
        Paper is in preparation for submission.

!!! tip "Before You Begin"
    Ensure you have your dataset ready in a compatible format (e.g., CSV) and are familiar with the basic usage of
    Scikit-Longitudinal. Check out the [Getting Started](getting-started.md) page if you need a refresher!

## 📰 Scientific Papers Sklong Reimplemented


=== "Ribeiro and Freitas (2024)"

    **Paper Name**: Ribeiro, C. and Freitas, A.A. (2024). A lexicographic optimisation approach to promote more recent features on longitudinal decision-tree-based classifiers: applications to the English Longitudinal Study of Ageing. Artificial Intelligence Review, 57(4), 84.

    **Paper Link**: [https://link.springer.com/article/10.1007/s10462-024-10718-1](https://link.springer.com/article/10.1007/s10462-024-10718-1)

    **Primitive Name**: Lexicographical Decision Tree

=== "Ovchinnik et al. (2022)"

    **Paper Name**: Ovchinnik, S., Otero, F., & Freitas, A.A. (2022). Nested trees for longitudinal classification. In Proceedings of the ACM/SIGAPP Symposium on Applied Computing (pp. 441-444).

    **Paper Link**: [https://dl.acm.org/doi/abs/10.1145/3477314.3507240](https://dl.acm.org/doi/abs/10.1145/3477314.3507240)

    **Primitive Name**: Nested Tree

=== "Ribeiro and Freitas (2020)"

    **Paper Name**: Ribeiro, C. and Freitas, A. (2020). A new random forest method for longitudinal data classification using a lexicographic bi-objective approach. In 2020 IEEE Symposium Series on Computational Intelligence (SSCI) (pp. 806-813). IEEE.

    **Paper Link**: [https://ieeexplore.ieee.org/abstract/document/9308198/](https://ieeexplore.ieee.org/abstract/document/9308198/)

    **Primitive Name**: Lexicographical Random Forest

=== "Pomsuwan and Freitas (2017)"

    **Paper Name**: Pomsuwan, T. and Freitas, A.A. (2017). Feature selection for the classification of longitudinal human ageing data. In 2017 IEEE International Conference on Data Mining Workshops (ICDMW) (pp. 739-746). IEEE.

    **Paper Link**: [https://ieeexplore.ieee.org/abstract/document/8215734/](https://ieeexplore.ieee.org/abstract/document/8215734/)

    **Primitive Name**: CFS Per Group Feature Selection

=== "Pomsuwan and Freitas (2018)"

    **Paper Name**: Pomsuwan, T. and Freitas, A.A. (2018). Feature selection for the classification of longitudinal human ageing data. Master's thesis, University of Kent.

    **Paper Link**: [https://kar.kent.ac.uk/66776/](https://kar.kent.ac.uk/66776/)

    **Primitive Name**: CFS Per Group Feature Selection

