from setuptools import find_packages, setup  # pragma: no cover

setup(  # pragma: no cover
    name="Scikit-longitudinal",
    version="0.1.4",
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    url="https://github.com/simonprovost/scikit-longitudinal",
    description="Scikit-longitudinal is an open-source Python library for longitudinal data analysis, building on Scikit-learn's foundation with tools tailored for repeated measures data.",
    author="Provost Simon, Alex Freitas",
    author_email="simon.gilbert.provost@gmail.com, a.a.freitas@kent.ac.uk",
    packages=find_packages(),
    project_urls={
        'Homepage': 'https://github.com/simonprovost/scikit-longitudinal',
        'Documentation': 'https://scikit-longitudinal.readthedocs.io/latest/',
        'Releases': 'https://github.com/simonprovost/scikit-longitudinal/releases',
        'Repository': 'https://github.com/simonprovost/scikit-longitudinal',
        'Issues': 'https://github.com/simonprovost/scikit-longitudinal/issues/',
        'Scientific Paper': 'https://joss.theoj.org/papers/10.21105/joss.08481',
    },
    classifiers=[
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
    ],
    install_requires=[
        "scipy>=1.5.0",
        "pandas<2.0.0,>=1.5.3",
        "matplotlib<4.0.0,>=3.7.0",
        "jupyter<2.0.0,>=1.0.0",
        "overrides<8.0.0,>=7.3.1",
        "statsmodels<1.0.0,>=0.14.0",
        "numpy==1.23.3",
        "graphviz<1.0.0,>=0.20.1",
        "liac-arff>=2.2.2",
        "threadpoolctl<4.0.0,>=3.1.0",
        "stopit>=1.1.2",
        "rich>=13.6.0",
        "joblib>=0.11",
        "deep-forest>=0.1.7",
        "scikit-lexicographical-trees==0.0.4",
        "ray>=2.40.0",
    ],
    extras_require={
        "dev": [
            "pytest>=4.4.0",
            "pytest-cov>=4.0.0",
            "black>=23.10.1",
            "isort>=5.12.0",
            "pylint>=3.3.3",
            "black>=24.10.0",
            "ruff>=0.9.1",
            "mkdocs-material-extensions==1.3.1",
            "mkdocs-minify-plugin==0.8.0",
            "markdown-callouts>=0.4",
            "markdown-exec>=1.8",
            "mkdocs>=1.6.1",
            "mkdocs-coverage>=1.0",
            "mkdocs-gen-files>=0.5",
            "mkdocs-git-revision-date-localized-plugin>=1.2",
            "mkdocs-literate-nav>=0.6",
            "mkdocs-minify-plugin>=0.8",
            "mkdocstrings[python]>=0.25",
            "tomli>=2.0; python_version < '3.11'",
            "mkdocstrings-python>=1.16.10",
            "mkdocs-jupyter>=0.25.1",
            "pymdown-extensions>=10.14.3",
            "mkdocs-material[emoji,imaging]>=9.6.11",
            "mkdocs-document-dates>=3.1.5",
            "mkdocs-glightbox>=0.4.0",
        ]
    },
    python_requires=">=3.9,<3.10",
    license="MIT",
)