# Generated by Django 1.10.5 on 2017-02-07 10:16
import django.contrib.postgres.fields
import django.db.models.deletion
import mptt.fields
from django.db import (
    migrations,
    models,
)


class Migration(migrations.Migration):
    dependencies = [
        ('report_constructor', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ReportFilter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('index', models.PositiveSmallIntegerField(verbose_name='Порядковый номер')),
                (
                    'operator',
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, 'Меньше или равно'),
                            (2, 'Меньше'),
                            (3, 'Равно'),
                            (4, 'Не равно'),
                            (5, 'Больше'),
                            (6, 'Больше или равно'),
                            (7, 'Пусто'),
                            (8, 'Не пусто'),
                            (9, 'Содержит'),
                            (10, 'Не содержит'),
                            (11, 'Начинается с'),
                            (12, 'Заканчивается на'),
                            (13, 'Между'),
                            (14, 'Равно одному из'),
                        ],
                        verbose_name='Оператор сравнения',
                    ),
                ),
                ('case_sensitive', models.NullBooleanField(verbose_name='Учет регистра')),
                (
                    'values',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TextField(verbose_name='Значение'), size=None
                    ),
                ),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Описание фильтра')),
                (
                    'column',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='filters',
                        to='report_constructor.ReportColumn',
                        verbose_name='Столбец',
                    ),
                ),
            ],
            options={
                'ordering': ('index',),
                'verbose_name': 'Фильтр',
                'verbose_name_plural': 'Фильтры',
            },
        ),
        migrations.CreateModel(
            name='ReportFilterGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'operator',
                    models.PositiveSmallIntegerField(
                        choices=[(1, 'И'), (2, 'ИЛИ')],
                        help_text=('Логический оператор, объединяющий фильтры в группе'),
                        verbose_name='Логический оператор',
                    ),
                ),
                ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
                ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
                ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
                ('level', models.PositiveIntegerField(db_index=True, editable=False)),
                (
                    'parent',
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='nested_groups',
                        to='report_constructor.ReportFilterGroup',
                        verbose_name='Родительская группа',
                    ),
                ),
                (
                    'report_template',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='filter_groups',
                        to='report_constructor.ReportTemplate',
                        verbose_name='Отчет',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Группа фильтров',
                'verbose_name_plural': 'Группы фильтров',
            },
        ),
        migrations.AddField(
            model_name='reportfilter',
            name='group',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='filters',
                to='report_constructor.ReportFilterGroup',
                verbose_name='Группа фильтров',
            ),
        ),
        migrations.AlterUniqueTogether(
            name='reportfilter',
            unique_together=set([('column', 'index')]),
        ),
    ]
