# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppsecWafCustomRuleArgs', 'AppsecWafCustomRule']

@pulumi.input_type
class AppsecWafCustomRuleArgs:
    def __init__(__self__, *,
                 blocking: pulumi.Input[_builtins.bool],
                 enabled: pulumi.Input[_builtins.bool],
                 name: pulumi.Input[_builtins.str],
                 tags: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 action: Optional[pulumi.Input['AppsecWafCustomRuleActionArgs']] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleConditionArgs']]]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleScopeArgs']]]] = None):
        """
        The set of arguments for constructing a AppsecWafCustomRule resource.
        :param pulumi.Input[_builtins.bool] blocking: Indicates whether the WAF custom rule will block the request.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the WAF custom rule is enabled.
        :param pulumi.Input[_builtins.str] name: The Name of the WAF custom rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        :param pulumi.Input[_builtins.str] path_glob: The path glob for the WAF custom rule.
        """
        pulumi.set(__self__, "blocking", blocking)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tags", tags)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if path_glob is not None:
            pulumi.set(__self__, "path_glob", path_glob)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter
    def blocking(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether the WAF custom rule will block the request.
        """
        return pulumi.get(self, "blocking")

    @blocking.setter
    def blocking(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "blocking", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Indicates whether the WAF custom rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the WAF custom rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AppsecWafCustomRuleActionArgs']]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AppsecWafCustomRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleConditionArgs']]]]:
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="pathGlob")
    def path_glob(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path glob for the WAF custom rule.
        """
        return pulumi.get(self, "path_glob")

    @path_glob.setter
    def path_glob(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_glob", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleScopeArgs']]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleScopeArgs']]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _AppsecWafCustomRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['AppsecWafCustomRuleActionArgs']] = None,
                 blocking: Optional[pulumi.Input[_builtins.bool]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleConditionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleScopeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AppsecWafCustomRule resources.
        :param pulumi.Input[_builtins.bool] blocking: Indicates whether the WAF custom rule will block the request.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the WAF custom rule is enabled.
        :param pulumi.Input[_builtins.str] name: The Name of the WAF custom rule.
        :param pulumi.Input[_builtins.str] path_glob: The path glob for the WAF custom rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if blocking is not None:
            pulumi.set(__self__, "blocking", blocking)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_glob is not None:
            pulumi.set(__self__, "path_glob", path_glob)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['AppsecWafCustomRuleActionArgs']]:
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['AppsecWafCustomRuleActionArgs']]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def blocking(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the WAF custom rule will block the request.
        """
        return pulumi.get(self, "blocking")

    @blocking.setter
    def blocking(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "blocking", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleConditionArgs']]]]:
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the WAF custom rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the WAF custom rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pathGlob")
    def path_glob(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path glob for the WAF custom rule.
        """
        return pulumi.get(self, "path_glob")

    @path_glob.setter
    def path_glob(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_glob", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleScopeArgs']]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppsecWafCustomRuleScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/appsecWafCustomRule:AppsecWafCustomRule")
class AppsecWafCustomRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['AppsecWafCustomRuleActionArgs', 'AppsecWafCustomRuleActionArgsDict']]] = None,
                 blocking: Optional[pulumi.Input[_builtins.bool]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafCustomRuleConditionArgs', 'AppsecWafCustomRuleConditionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafCustomRuleScopeArgs', 'AppsecWafCustomRuleScopeArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog AppsecWafCustomRule resource. This can be used to create and manage Datadog appsec_waf_custom_rule.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/appsecWafCustomRule:AppsecWafCustomRule new_list ""
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] blocking: Indicates whether the WAF custom rule will block the request.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the WAF custom rule is enabled.
        :param pulumi.Input[_builtins.str] name: The Name of the WAF custom rule.
        :param pulumi.Input[_builtins.str] path_glob: The path glob for the WAF custom rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppsecWafCustomRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog AppsecWafCustomRule resource. This can be used to create and manage Datadog appsec_waf_custom_rule.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/appsecWafCustomRule:AppsecWafCustomRule new_list ""
        ```

        :param str resource_name: The name of the resource.
        :param AppsecWafCustomRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppsecWafCustomRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['AppsecWafCustomRuleActionArgs', 'AppsecWafCustomRuleActionArgsDict']]] = None,
                 blocking: Optional[pulumi.Input[_builtins.bool]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafCustomRuleConditionArgs', 'AppsecWafCustomRuleConditionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path_glob: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafCustomRuleScopeArgs', 'AppsecWafCustomRuleScopeArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppsecWafCustomRuleArgs.__new__(AppsecWafCustomRuleArgs)

            __props__.__dict__["action"] = action
            if blocking is None and not opts.urn:
                raise TypeError("Missing required property 'blocking'")
            __props__.__dict__["blocking"] = blocking
            __props__.__dict__["conditions"] = conditions
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["path_glob"] = path_glob
            __props__.__dict__["scopes"] = scopes
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__.__dict__["tags"] = tags
        super(AppsecWafCustomRule, __self__).__init__(
            'datadog:index/appsecWafCustomRule:AppsecWafCustomRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['AppsecWafCustomRuleActionArgs', 'AppsecWafCustomRuleActionArgsDict']]] = None,
            blocking: Optional[pulumi.Input[_builtins.bool]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafCustomRuleConditionArgs', 'AppsecWafCustomRuleConditionArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            path_glob: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppsecWafCustomRuleScopeArgs', 'AppsecWafCustomRuleScopeArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'AppsecWafCustomRule':
        """
        Get an existing AppsecWafCustomRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] blocking: Indicates whether the WAF custom rule will block the request.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the WAF custom rule is enabled.
        :param pulumi.Input[_builtins.str] name: The Name of the WAF custom rule.
        :param pulumi.Input[_builtins.str] path_glob: The path glob for the WAF custom rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppsecWafCustomRuleState.__new__(_AppsecWafCustomRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["blocking"] = blocking
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["path_glob"] = path_glob
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["tags"] = tags
        return AppsecWafCustomRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional['outputs.AppsecWafCustomRuleAction']]:
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def blocking(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the WAF custom rule will block the request.
        """
        return pulumi.get(self, "blocking")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.AppsecWafCustomRuleCondition']]]:
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the WAF custom rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the WAF custom rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pathGlob")
    def path_glob(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path glob for the WAF custom rule.
        """
        return pulumi.get(self, "path_glob")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence['outputs.AppsecWafCustomRuleScope']]]:
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Tags associated with the WAF custom rule. `category` and `type` tags are required. Supported categories include `business_logic`, `attack_attempt` and `security_response`.
        """
        return pulumi.get(self, "tags")

