# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CsmThreatsAgentRuleArgs', 'CsmThreatsAgentRule']

@pulumi.input_type
class CsmThreatsAgentRuleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CsmThreatsAgentRule resource.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        :param pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]] actions: The list of actions the rule can perform
        :param pulumi.Input[_builtins.str] description: A description for the Agent rule.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the agent policy in which the rule is saved
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_tags: The list of product tags associated with the rule
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "name", name)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if product_tags is not None:
            pulumi.set(__self__, "product_tags", product_tags)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        """
        The SECL expression of the Agent rule
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Agent rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]]]:
        """
        The list of actions the rule can perform
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the Agent rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the agent policy in which the rule is saved
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="productTags")
    def product_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of product tags associated with the rule
        """
        return pulumi.get(self, "product_tags")

    @product_tags.setter
    def product_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "product_tags", value)


@pulumi.input_type
class _CsmThreatsAgentRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CsmThreatsAgentRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]] actions: The list of actions the rule can perform
        :param pulumi.Input[_builtins.str] description: A description for the Agent rule.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the agent policy in which the rule is saved
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_tags: The list of product tags associated with the rule
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if product_tags is not None:
            pulumi.set(__self__, "product_tags", product_tags)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]]]:
        """
        The list of actions the rule can perform
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CsmThreatsAgentRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the Agent rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SECL expression of the Agent rule
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Agent rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the agent policy in which the rule is saved
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="productTags")
    def product_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of product tags associated with the rule
        """
        return pulumi.get(self, "product_tags")

    @product_tags.setter
    def product_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "product_tags", value)


@pulumi.type_token("datadog:index/csmThreatsAgentRule:CsmThreatsAgentRule")
class CsmThreatsAgentRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsmThreatsAgentRuleActionArgs', 'CsmThreatsAgentRuleActionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog CSM Threats Agent Rule API resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_agent_rule = datadog.CsmThreatsAgentRule("my_agent_rule",
            name="my_agent_rule",
            enabled=True,
            description="im a rule",
            expression="open.file.name == \\"etc/shadow/password\\"")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        CSM Agent Rules can be imported using ID. For example:

        ```sh
        $ pulumi import datadog:index/csmThreatsAgentRule:CsmThreatsAgentRule my_agent_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CsmThreatsAgentRuleActionArgs', 'CsmThreatsAgentRuleActionArgsDict']]]] actions: The list of actions the rule can perform
        :param pulumi.Input[_builtins.str] description: A description for the Agent rule.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the agent policy in which the rule is saved
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_tags: The list of product tags associated with the rule
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CsmThreatsAgentRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog CSM Threats Agent Rule API resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_agent_rule = datadog.CsmThreatsAgentRule("my_agent_rule",
            name="my_agent_rule",
            enabled=True,
            description="im a rule",
            expression="open.file.name == \\"etc/shadow/password\\"")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        CSM Agent Rules can be imported using ID. For example:

        ```sh
        $ pulumi import datadog:index/csmThreatsAgentRule:CsmThreatsAgentRule my_agent_rule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param CsmThreatsAgentRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CsmThreatsAgentRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsmThreatsAgentRuleActionArgs', 'CsmThreatsAgentRuleActionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 expression: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CsmThreatsAgentRuleArgs.__new__(CsmThreatsAgentRuleArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["product_tags"] = product_tags
        super(CsmThreatsAgentRule, __self__).__init__(
            'datadog:index/csmThreatsAgentRule:CsmThreatsAgentRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CsmThreatsAgentRuleActionArgs', 'CsmThreatsAgentRuleActionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            expression: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            product_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'CsmThreatsAgentRule':
        """
        Get an existing CsmThreatsAgentRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CsmThreatsAgentRuleActionArgs', 'CsmThreatsAgentRuleActionArgsDict']]]] actions: The list of actions the rule can perform
        :param pulumi.Input[_builtins.str] description: A description for the Agent rule.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        :param pulumi.Input[_builtins.str] expression: The SECL expression of the Agent rule
        :param pulumi.Input[_builtins.str] name: The name of the Agent rule.
        :param pulumi.Input[_builtins.str] policy_id: The ID of the agent policy in which the rule is saved
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] product_tags: The list of product tags associated with the rule
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CsmThreatsAgentRuleState.__new__(_CsmThreatsAgentRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["expression"] = expression
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["product_tags"] = product_tags
        return CsmThreatsAgentRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional[Sequence['outputs.CsmThreatsAgentRuleAction']]]:
        """
        The list of actions the rule can perform
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for the Agent rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the Agent rule is enabled. Must not be used without policy_id.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Output[_builtins.str]:
        """
        The SECL expression of the Agent rule
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Agent rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the agent policy in which the rule is saved
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="productTags")
    def product_tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of product tags associated with the rule
        """
        return pulumi.get(self, "product_tags")

