# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CsmThreatsPolicyArgs', 'CsmThreatsPolicy']

@pulumi.input_type
class CsmThreatsPolicyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_tags_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CsmThreatsPolicy resource.
        :param pulumi.Input[_builtins.str] name: The name of the policy.
        :param pulumi.Input[_builtins.str] description: A description for the policy.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the policy is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] host_tags_lists: Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host_tags_lists is not None:
            pulumi.set(__self__, "host_tags_lists", host_tags_lists)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the policy is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostTagsLists")
    def host_tags_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]]:
        """
        Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        """
        return pulumi.get(self, "host_tags_lists")

    @host_tags_lists.setter
    def host_tags_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "host_tags_lists", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CsmThreatsPolicyState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_tags_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CsmThreatsPolicy resources.
        :param pulumi.Input[_builtins.str] description: A description for the policy.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the policy is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] host_tags_lists: Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        :param pulumi.Input[_builtins.str] name: The name of the policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if host_tags_lists is not None:
            pulumi.set(__self__, "host_tags_lists", host_tags_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the policy is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="hostTagsLists")
    def host_tags_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]]:
        """
        Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        """
        return pulumi.get(self, "host_tags_lists")

    @host_tags_lists.setter
    def host_tags_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "host_tags_lists", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("datadog:index/csmThreatsPolicy:CsmThreatsPolicy")
class CsmThreatsPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_tags_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog CSM Threats policy API resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the policy.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the policy is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] host_tags_lists: Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        :param pulumi.Input[_builtins.str] name: The name of the policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CsmThreatsPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog CSM Threats policy API resource.

        :param str resource_name: The name of the resource.
        :param CsmThreatsPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CsmThreatsPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 host_tags_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CsmThreatsPolicyArgs.__new__(CsmThreatsPolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["host_tags_lists"] = host_tags_lists
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
        super(CsmThreatsPolicy, __self__).__init__(
            'datadog:index/csmThreatsPolicy:CsmThreatsPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            host_tags_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'CsmThreatsPolicy':
        """
        Get an existing CsmThreatsPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for the policy.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the policy is enabled. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]] host_tags_lists: Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        :param pulumi.Input[_builtins.str] name: The name of the policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CsmThreatsPolicyState.__new__(_CsmThreatsPolicyState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["host_tags_lists"] = host_tags_lists
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        return CsmThreatsPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A description for the policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the policy is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="hostTagsLists")
    def host_tags_lists(self) -> pulumi.Output[Optional[Sequence[Sequence[_builtins.str]]]]:
        """
        Host tags that define where the policy is deployed. Inner values are ANDed, outer arrays are ORed.
        """
        return pulumi.get(self, "host_tags_lists")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Host tags that define where the policy is deployed. Deprecated, use host*tags*lists instead.
        """
        return pulumi.get(self, "tags")

