# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DomainAllowlistArgs', 'DomainAllowlist']

@pulumi.input_type
class DomainAllowlistArgs:
    def __init__(__self__, *,
                 domains: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 enabled: pulumi.Input[_builtins.bool]):
        """
        The set of arguments for constructing a DomainAllowlist resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: The domains within the domain allowlist.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Email Domain Allowlist is enabled.
        """
        pulumi.set(__self__, "domains", domains)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The domains within the domain allowlist.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the Email Domain Allowlist is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class _DomainAllowlistState:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering DomainAllowlist resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: The domains within the domain allowlist.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Email Domain Allowlist is enabled.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The domains within the domain allowlist.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Email Domain Allowlist is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.type_token("datadog:index/domainAllowlist:DomainAllowlist")
class DomainAllowlist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides the Datadog Email Domain Allowlist resource. This can be used to manage the Datadog Email Domain Allowlist.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        example = datadog.DomainAllowlist("example",
            enabled=True,
            domains=["@gmail.com"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: The domains within the domain allowlist.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Email Domain Allowlist is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainAllowlistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides the Datadog Email Domain Allowlist resource. This can be used to manage the Datadog Email Domain Allowlist.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        example = datadog.DomainAllowlist("example",
            enabled=True,
            domains=["@gmail.com"])
        ```

        :param str resource_name: The name of the resource.
        :param DomainAllowlistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainAllowlistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainAllowlistArgs.__new__(DomainAllowlistArgs)

            if domains is None and not opts.urn:
                raise TypeError("Missing required property 'domains'")
            __props__.__dict__["domains"] = domains
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
        super(DomainAllowlist, __self__).__init__(
            'datadog:index/domainAllowlist:DomainAllowlist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'DomainAllowlist':
        """
        Get an existing DomainAllowlist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] domains: The domains within the domain allowlist.
        :param pulumi.Input[_builtins.bool] enabled: Whether the Email Domain Allowlist is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainAllowlistState.__new__(_DomainAllowlistState)

        __props__.__dict__["domains"] = domains
        __props__.__dict__["enabled"] = enabled
        return DomainAllowlist(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The domains within the domain allowlist.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Email Domain Allowlist is enabled.
        """
        return pulumi.get(self, "enabled")

