# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetApmRetentionFiltersOrderResult',
    'AwaitableGetApmRetentionFiltersOrderResult',
    'get_apm_retention_filters_order',
    'get_apm_retention_filters_order_output',
]

@pulumi.output_type
class GetApmRetentionFiltersOrderResult:
    """
    A collection of values returned by getApmRetentionFiltersOrder.
    """
    def __init__(__self__, filter_ids=None, id=None):
        if filter_ids and not isinstance(filter_ids, list):
            raise TypeError("Expected argument 'filter_ids' to be a list")
        pulumi.set(__self__, "filter_ids", filter_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="filterIds")
    def filter_ids(self) -> Sequence[_builtins.str]:
        """
        The filter IDs list. The order of filters IDs in this attribute defines the overall APM retention filters order.
        """
        return pulumi.get(self, "filter_ids")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetApmRetentionFiltersOrderResult(GetApmRetentionFiltersOrderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApmRetentionFiltersOrderResult(
            filter_ids=self.filter_ids,
            id=self.id)


def get_apm_retention_filters_order(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApmRetentionFiltersOrderResult:
    """
    Provides a Datadog [APM Retention Filters API](https://docs.datadoghq.com/api/v2/apm-retention-filters/) order datasource. This can be used to retrieve APM retention filters order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    foo = datadog.get_apm_retention_filters_order()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getApmRetentionFiltersOrder:getApmRetentionFiltersOrder', __args__, opts=opts, typ=GetApmRetentionFiltersOrderResult).value

    return AwaitableGetApmRetentionFiltersOrderResult(
        filter_ids=pulumi.get(__ret__, 'filter_ids'),
        id=pulumi.get(__ret__, 'id'))
def get_apm_retention_filters_order_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApmRetentionFiltersOrderResult]:
    """
    Provides a Datadog [APM Retention Filters API](https://docs.datadoghq.com/api/v2/apm-retention-filters/) order datasource. This can be used to retrieve APM retention filters order.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    foo = datadog.get_apm_retention_filters_order()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getApmRetentionFiltersOrder:getApmRetentionFiltersOrder', __args__, opts=opts, typ=GetApmRetentionFiltersOrderResult)
    return __ret__.apply(lambda __response__: GetApmRetentionFiltersOrderResult(
        filter_ids=pulumi.get(__response__, 'filter_ids'),
        id=pulumi.get(__response__, 'id')))
