# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetHostsResult',
    'AwaitableGetHostsResult',
    'get_hosts',
    'get_hosts_output',
]

@pulumi.output_type
class GetHostsResult:
    """
    A collection of values returned by getHosts.
    """
    def __init__(__self__, filter=None, from_=None, host_lists=None, id=None, include_muted_hosts_data=None, sort_dir=None, sort_field=None, total_matching=None, total_returned=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if from_ and not isinstance(from_, int):
            raise TypeError("Expected argument 'from_' to be a int")
        pulumi.set(__self__, "from_", from_)
        if host_lists and not isinstance(host_lists, list):
            raise TypeError("Expected argument 'host_lists' to be a list")
        pulumi.set(__self__, "host_lists", host_lists)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_muted_hosts_data and not isinstance(include_muted_hosts_data, bool):
            raise TypeError("Expected argument 'include_muted_hosts_data' to be a bool")
        pulumi.set(__self__, "include_muted_hosts_data", include_muted_hosts_data)
        if sort_dir and not isinstance(sort_dir, str):
            raise TypeError("Expected argument 'sort_dir' to be a str")
        pulumi.set(__self__, "sort_dir", sort_dir)
        if sort_field and not isinstance(sort_field, str):
            raise TypeError("Expected argument 'sort_field' to be a str")
        pulumi.set(__self__, "sort_field", sort_field)
        if total_matching and not isinstance(total_matching, int):
            raise TypeError("Expected argument 'total_matching' to be a int")
        pulumi.set(__self__, "total_matching", total_matching)
        if total_returned and not isinstance(total_returned, int):
            raise TypeError("Expected argument 'total_returned' to be a int")
        pulumi.set(__self__, "total_returned", total_returned)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        """
        String to filter search results.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter(name="from")
    def from_(self) -> Optional[_builtins.int]:
        """
        Number of seconds since UNIX epoch from which you want to search your hosts.
        """
        return pulumi.get(self, "from_")

    @_builtins.property
    @pulumi.getter(name="hostLists")
    def host_lists(self) -> Sequence['outputs.GetHostsHostListResult']:
        """
        List of hosts (1000 Max).
        """
        return pulumi.get(self, "host_lists")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeMutedHostsData")
    def include_muted_hosts_data(self) -> Optional[_builtins.bool]:
        """
        Include information on the muted status of hosts and when the mute expires.
        """
        return pulumi.get(self, "include_muted_hosts_data")

    @_builtins.property
    @pulumi.getter(name="sortDir")
    def sort_dir(self) -> Optional[_builtins.str]:
        """
        Direction of sort.
        """
        return pulumi.get(self, "sort_dir")

    @_builtins.property
    @pulumi.getter(name="sortField")
    def sort_field(self) -> Optional[_builtins.str]:
        """
        Sort hosts by this field.
        """
        return pulumi.get(self, "sort_field")

    @_builtins.property
    @pulumi.getter(name="totalMatching")
    def total_matching(self) -> _builtins.int:
        """
        Number of host matching the query.
        """
        return pulumi.get(self, "total_matching")

    @_builtins.property
    @pulumi.getter(name="totalReturned")
    def total_returned(self) -> _builtins.int:
        """
        Number of host returned.
        """
        return pulumi.get(self, "total_returned")


class AwaitableGetHostsResult(GetHostsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostsResult(
            filter=self.filter,
            from_=self.from_,
            host_lists=self.host_lists,
            id=self.id,
            include_muted_hosts_data=self.include_muted_hosts_data,
            sort_dir=self.sort_dir,
            sort_field=self.sort_field,
            total_matching=self.total_matching,
            total_returned=self.total_returned)


def get_hosts(filter: Optional[_builtins.str] = None,
              from_: Optional[_builtins.int] = None,
              include_muted_hosts_data: Optional[_builtins.bool] = None,
              sort_dir: Optional[_builtins.str] = None,
              sort_field: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostsResult:
    """
    Use this data source to retrieve information about your live hosts in Datadog.


    :param _builtins.str filter: String to filter search results.
    :param _builtins.int from_: Number of seconds since UNIX epoch from which you want to search your hosts.
    :param _builtins.bool include_muted_hosts_data: Include information on the muted status of hosts and when the mute expires.
    :param _builtins.str sort_dir: Direction of sort.
    :param _builtins.str sort_field: Sort hosts by this field.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['from'] = from_
    __args__['includeMutedHostsData'] = include_muted_hosts_data
    __args__['sortDir'] = sort_dir
    __args__['sortField'] = sort_field
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getHosts:getHosts', __args__, opts=opts, typ=GetHostsResult).value

    return AwaitableGetHostsResult(
        filter=pulumi.get(__ret__, 'filter'),
        from_=pulumi.get(__ret__, 'from_'),
        host_lists=pulumi.get(__ret__, 'host_lists'),
        id=pulumi.get(__ret__, 'id'),
        include_muted_hosts_data=pulumi.get(__ret__, 'include_muted_hosts_data'),
        sort_dir=pulumi.get(__ret__, 'sort_dir'),
        sort_field=pulumi.get(__ret__, 'sort_field'),
        total_matching=pulumi.get(__ret__, 'total_matching'),
        total_returned=pulumi.get(__ret__, 'total_returned'))
def get_hosts_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     from_: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                     include_muted_hosts_data: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     sort_dir: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     sort_field: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostsResult]:
    """
    Use this data source to retrieve information about your live hosts in Datadog.


    :param _builtins.str filter: String to filter search results.
    :param _builtins.int from_: Number of seconds since UNIX epoch from which you want to search your hosts.
    :param _builtins.bool include_muted_hosts_data: Include information on the muted status of hosts and when the mute expires.
    :param _builtins.str sort_dir: Direction of sort.
    :param _builtins.str sort_field: Sort hosts by this field.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['from'] = from_
    __args__['includeMutedHostsData'] = include_muted_hosts_data
    __args__['sortDir'] = sort_dir
    __args__['sortField'] = sort_field
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getHosts:getHosts', __args__, opts=opts, typ=GetHostsResult)
    return __ret__.apply(lambda __response__: GetHostsResult(
        filter=pulumi.get(__response__, 'filter'),
        from_=pulumi.get(__response__, 'from_'),
        host_lists=pulumi.get(__response__, 'host_lists'),
        id=pulumi.get(__response__, 'id'),
        include_muted_hosts_data=pulumi.get(__response__, 'include_muted_hosts_data'),
        sort_dir=pulumi.get(__response__, 'sort_dir'),
        sort_field=pulumi.get(__response__, 'sort_field'),
        total_matching=pulumi.get(__response__, 'total_matching'),
        total_returned=pulumi.get(__response__, 'total_returned')))
