# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTeamsResult',
    'AwaitableGetTeamsResult',
    'get_teams',
    'get_teams_output',
]

@pulumi.output_type
class GetTeamsResult:
    """
    A collection of values returned by getTeams.
    """
    def __init__(__self__, filter_keyword=None, filter_me=None, id=None, teams=None):
        if filter_keyword and not isinstance(filter_keyword, str):
            raise TypeError("Expected argument 'filter_keyword' to be a str")
        pulumi.set(__self__, "filter_keyword", filter_keyword)
        if filter_me and not isinstance(filter_me, bool):
            raise TypeError("Expected argument 'filter_me' to be a bool")
        pulumi.set(__self__, "filter_me", filter_me)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if teams and not isinstance(teams, list):
            raise TypeError("Expected argument 'teams' to be a list")
        pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter(name="filterKeyword")
    def filter_keyword(self) -> Optional[_builtins.str]:
        """
        Search query. Can be team name, team handle, or email of team member.
        """
        return pulumi.get(self, "filter_keyword")

    @_builtins.property
    @pulumi.getter(name="filterMe")
    def filter_me(self) -> Optional[_builtins.bool]:
        """
        When true, only returns teams the current user belongs to.
        """
        return pulumi.get(self, "filter_me")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[Sequence['outputs.GetTeamsTeamResult']]:
        """
        List of teams
        """
        return pulumi.get(self, "teams")


class AwaitableGetTeamsResult(GetTeamsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamsResult(
            filter_keyword=self.filter_keyword,
            filter_me=self.filter_me,
            id=self.id,
            teams=self.teams)


def get_teams(filter_keyword: Optional[_builtins.str] = None,
              filter_me: Optional[_builtins.bool] = None,
              teams: Optional[Sequence[Union['GetTeamsTeamArgs', 'GetTeamsTeamArgsDict']]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamsResult:
    """
    Use this data source to retrieve information about existing teams for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_teams(filter_keyword="team-member@company.com",
        filter_me=True)
    ```


    :param _builtins.str filter_keyword: Search query. Can be team name, team handle, or email of team member.
    :param _builtins.bool filter_me: When true, only returns teams the current user belongs to.
    :param Sequence[Union['GetTeamsTeamArgs', 'GetTeamsTeamArgsDict']] teams: List of teams
    """
    __args__ = dict()
    __args__['filterKeyword'] = filter_keyword
    __args__['filterMe'] = filter_me
    __args__['teams'] = teams
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getTeams:getTeams', __args__, opts=opts, typ=GetTeamsResult).value

    return AwaitableGetTeamsResult(
        filter_keyword=pulumi.get(__ret__, 'filter_keyword'),
        filter_me=pulumi.get(__ret__, 'filter_me'),
        id=pulumi.get(__ret__, 'id'),
        teams=pulumi.get(__ret__, 'teams'))
def get_teams_output(filter_keyword: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     filter_me: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                     teams: Optional[pulumi.Input[Optional[Sequence[Union['GetTeamsTeamArgs', 'GetTeamsTeamArgsDict']]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTeamsResult]:
    """
    Use this data source to retrieve information about existing teams for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    example = datadog.get_teams(filter_keyword="team-member@company.com",
        filter_me=True)
    ```


    :param _builtins.str filter_keyword: Search query. Can be team name, team handle, or email of team member.
    :param _builtins.bool filter_me: When true, only returns teams the current user belongs to.
    :param Sequence[Union['GetTeamsTeamArgs', 'GetTeamsTeamArgsDict']] teams: List of teams
    """
    __args__ = dict()
    __args__['filterKeyword'] = filter_keyword
    __args__['filterMe'] = filter_me
    __args__['teams'] = teams
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getTeams:getTeams', __args__, opts=opts, typ=GetTeamsResult)
    return __ret__.apply(lambda __response__: GetTeamsResult(
        filter_keyword=pulumi.get(__response__, 'filter_keyword'),
        filter_me=pulumi.get(__response__, 'filter_me'),
        id=pulumi.get(__response__, 'id'),
        teams=pulumi.get(__response__, 'teams')))
