# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, created_at=None, disabled=None, email=None, exact_match=None, filter=None, handle=None, icon=None, id=None, mfa_enabled=None, modified_at=None, name=None, service_account=None, status=None, title=None, verified=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if disabled and not isinstance(disabled, bool):
            raise TypeError("Expected argument 'disabled' to be a bool")
        pulumi.set(__self__, "disabled", disabled)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if exact_match and not isinstance(exact_match, bool):
            raise TypeError("Expected argument 'exact_match' to be a bool")
        pulumi.set(__self__, "exact_match", exact_match)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if handle and not isinstance(handle, str):
            raise TypeError("Expected argument 'handle' to be a str")
        pulumi.set(__self__, "handle", handle)
        if icon and not isinstance(icon, str):
            raise TypeError("Expected argument 'icon' to be a str")
        pulumi.set(__self__, "icon", icon)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mfa_enabled and not isinstance(mfa_enabled, bool):
            raise TypeError("Expected argument 'mfa_enabled' to be a bool")
        pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        if modified_at and not isinstance(modified_at, str):
            raise TypeError("Expected argument 'modified_at' to be a str")
        pulumi.set(__self__, "modified_at", modified_at)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_account and not isinstance(service_account, bool):
            raise TypeError("Expected argument 'service_account' to be a bool")
        pulumi.set(__self__, "service_account", service_account)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)
        if verified and not isinstance(verified, bool):
            raise TypeError("Expected argument 'verified' to be a bool")
        pulumi.set(__self__, "verified", verified)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The time when the user was created (RFC3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Indicates whether the user is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        Email of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="exactMatch")
    def exact_match(self) -> Optional[_builtins.bool]:
        """
        When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute. Defaults to `false`.
        """
        return pulumi.get(self, "exact_match")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.str:
        """
        Filter all users by the given string.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def handle(self) -> _builtins.str:
        """
        The user's handle.
        """
        return pulumi.get(self, "handle")

    @_builtins.property
    @pulumi.getter
    def icon(self) -> _builtins.str:
        """
        The URL where the user's icon is located.
        """
        return pulumi.get(self, "icon")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> _builtins.bool:
        """
        Indicates whether the user has enabled MFA.
        """
        return pulumi.get(self, "mfa_enabled")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> _builtins.str:
        """
        The time at which the user was last updated (RFC3339 format).
        """
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.bool:
        """
        Indicates whether the user is a service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The user's status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        The user's title.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def verified(self) -> _builtins.bool:
        """
        Indicates whether the user is verified.
        """
        return pulumi.get(self, "verified")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            created_at=self.created_at,
            disabled=self.disabled,
            email=self.email,
            exact_match=self.exact_match,
            filter=self.filter,
            handle=self.handle,
            icon=self.icon,
            id=self.id,
            mfa_enabled=self.mfa_enabled,
            modified_at=self.modified_at,
            name=self.name,
            service_account=self.service_account,
            status=self.status,
            title=self.title,
            verified=self.verified)


def get_user(exact_match: Optional[_builtins.bool] = None,
             filter: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to retrieve information about an existing user to use it in an other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_user(filter="user.name@company.com")
    ```


    :param _builtins.bool exact_match: When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute. Defaults to `false`.
    :param _builtins.str filter: Filter all users by the given string.
    """
    __args__ = dict()
    __args__['exactMatch'] = exact_match
    __args__['filter'] = filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        disabled=pulumi.get(__ret__, 'disabled'),
        email=pulumi.get(__ret__, 'email'),
        exact_match=pulumi.get(__ret__, 'exact_match'),
        filter=pulumi.get(__ret__, 'filter'),
        handle=pulumi.get(__ret__, 'handle'),
        icon=pulumi.get(__ret__, 'icon'),
        id=pulumi.get(__ret__, 'id'),
        mfa_enabled=pulumi.get(__ret__, 'mfa_enabled'),
        modified_at=pulumi.get(__ret__, 'modified_at'),
        name=pulumi.get(__ret__, 'name'),
        service_account=pulumi.get(__ret__, 'service_account'),
        status=pulumi.get(__ret__, 'status'),
        title=pulumi.get(__ret__, 'title'),
        verified=pulumi.get(__ret__, 'verified'))
def get_user_output(exact_match: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                    filter: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to retrieve information about an existing user to use it in an other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_user(filter="user.name@company.com")
    ```


    :param _builtins.bool exact_match: When true, `filter` string is exact matched against the user's `email`, followed by `name` attribute. Defaults to `false`.
    :param _builtins.str filter: Filter all users by the given string.
    """
    __args__ = dict()
    __args__['exactMatch'] = exact_match
    __args__['filter'] = filter
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        created_at=pulumi.get(__response__, 'created_at'),
        disabled=pulumi.get(__response__, 'disabled'),
        email=pulumi.get(__response__, 'email'),
        exact_match=pulumi.get(__response__, 'exact_match'),
        filter=pulumi.get(__response__, 'filter'),
        handle=pulumi.get(__response__, 'handle'),
        icon=pulumi.get(__response__, 'icon'),
        id=pulumi.get(__response__, 'id'),
        mfa_enabled=pulumi.get(__response__, 'mfa_enabled'),
        modified_at=pulumi.get(__response__, 'modified_at'),
        name=pulumi.get(__response__, 'name'),
        service_account=pulumi.get(__response__, 'service_account'),
        status=pulumi.get(__response__, 'status'),
        title=pulumi.get(__response__, 'title'),
        verified=pulumi.get(__response__, 'verified')))
