# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetWorkflowAutomationResult',
    'AwaitableGetWorkflowAutomationResult',
    'get_workflow_automation',
    'get_workflow_automation_output',
]

@pulumi.output_type
class GetWorkflowAutomationResult:
    """
    A collection of values returned by getWorkflowAutomation.
    """
    def __init__(__self__, description=None, id=None, name=None, published=None, spec_json=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if published and not isinstance(published, bool):
            raise TypeError("Expected argument 'published' to be a bool")
        pulumi.set(__self__, "published", published)
        if spec_json and not isinstance(spec_json, str):
            raise TypeError("Expected argument 'spec_json' to be a str")
        pulumi.set(__self__, "spec_json", spec_json)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the workflow.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the workflow.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the workflow.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def published(self) -> _builtins.bool:
        """
        Set the workflow to published or unpublished. Workflows in an unpublished state are only executable through manual runs. Automatic triggers such as Schedule do not execute the workflow until it is published.
        """
        return pulumi.get(self, "published")

    @_builtins.property
    @pulumi.getter(name="specJson")
    def spec_json(self) -> _builtins.str:
        """
        The spec defines what the workflow does.
        """
        return pulumi.get(self, "spec_json")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Tags of the workflow.
        """
        return pulumi.get(self, "tags")


class AwaitableGetWorkflowAutomationResult(GetWorkflowAutomationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowAutomationResult(
            description=self.description,
            id=self.id,
            name=self.name,
            published=self.published,
            spec_json=self.spec_json,
            tags=self.tags)


def get_workflow_automation(id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowAutomationResult:
    """
    This data source retrieves the definition of an existing Datadog workflow from Workflow Automation for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    my_workflow = datadog.get_workflow_automation(id="11111111-2222-3333-4444-555555555555")
    ```


    :param _builtins.str id: ID of the workflow.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getWorkflowAutomation:getWorkflowAutomation', __args__, opts=opts, typ=GetWorkflowAutomationResult).value

    return AwaitableGetWorkflowAutomationResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        published=pulumi.get(__ret__, 'published'),
        spec_json=pulumi.get(__ret__, 'spec_json'),
        tags=pulumi.get(__ret__, 'tags'))
def get_workflow_automation_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkflowAutomationResult]:
    """
    This data source retrieves the definition of an existing Datadog workflow from Workflow Automation for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    my_workflow = datadog.get_workflow_automation(id="11111111-2222-3333-4444-555555555555")
    ```


    :param _builtins.str id: ID of the workflow.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getWorkflowAutomation:getWorkflowAutomation', __args__, opts=opts, typ=GetWorkflowAutomationResult)
    return __ret__.apply(lambda __response__: GetWorkflowAutomationResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        published=pulumi.get(__response__, 'published'),
        spec_json=pulumi.get(__response__, 'spec_json'),
        tags=pulumi.get(__response__, 'tags')))
