# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogsCustomDestinationArgs', 'LogsCustomDestination']

@pulumi.input_type
class LogsCustomDestinationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 elasticsearch_destination: Optional[pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags_restriction_list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_tags_restriction_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_destination: Optional[pulumi.Input['LogsCustomDestinationHttpDestinationArgs']] = None,
                 microsoft_sentinel_destination: Optional[pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs']] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 splunk_destination: Optional[pulumi.Input['LogsCustomDestinationSplunkDestinationArgs']] = None):
        """
        The set of arguments for constructing a LogsCustomDestination resource.
        :param pulumi.Input[_builtins.str] name: The custom destination name.
        :param pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs'] elasticsearch_destination: The Elasticsearch destination.
        :param pulumi.Input[_builtins.bool] enabled: Whether logs matching this custom destination should be forwarded or not.
        :param pulumi.Input[_builtins.bool] forward_tags: Whether tags from the forwarded logs should be forwarded or not.
        :param pulumi.Input[_builtins.str] forward_tags_restriction_list_type: How the `forward_tags_restriction_list` parameter should be interpreted.
               			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
               			are forwarded.
               			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forward_tags_restriction_lists: List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
               			An empty list represents no restriction is in place and either all or no tags will be
               			forwarded depending on `forward_tags_restriction_list_type` parameter.
        :param pulumi.Input['LogsCustomDestinationHttpDestinationArgs'] http_destination: The HTTP destination.
        :param pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs'] microsoft_sentinel_destination: The Microsoft Sentinel destination.
        :param pulumi.Input[_builtins.str] query: The custom destination query filter. Logs matching this query are forwarded to the destination.
        :param pulumi.Input['LogsCustomDestinationSplunkDestinationArgs'] splunk_destination: The Splunk HTTP Event Collector (HEC) destination.
        """
        pulumi.set(__self__, "name", name)
        if elasticsearch_destination is not None:
            pulumi.set(__self__, "elasticsearch_destination", elasticsearch_destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forward_tags is not None:
            pulumi.set(__self__, "forward_tags", forward_tags)
        if forward_tags_restriction_list_type is not None:
            pulumi.set(__self__, "forward_tags_restriction_list_type", forward_tags_restriction_list_type)
        if forward_tags_restriction_lists is not None:
            pulumi.set(__self__, "forward_tags_restriction_lists", forward_tags_restriction_lists)
        if http_destination is not None:
            pulumi.set(__self__, "http_destination", http_destination)
        if microsoft_sentinel_destination is not None:
            pulumi.set(__self__, "microsoft_sentinel_destination", microsoft_sentinel_destination)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if splunk_destination is not None:
            pulumi.set(__self__, "splunk_destination", splunk_destination)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The custom destination name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="elasticsearchDestination")
    def elasticsearch_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs']]:
        """
        The Elasticsearch destination.
        """
        return pulumi.get(self, "elasticsearch_destination")

    @elasticsearch_destination.setter
    def elasticsearch_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs']]):
        pulumi.set(self, "elasticsearch_destination", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether logs matching this custom destination should be forwarded or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardTags")
    def forward_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether tags from the forwarded logs should be forwarded or not.
        """
        return pulumi.get(self, "forward_tags")

    @forward_tags.setter
    def forward_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tags", value)

    @_builtins.property
    @pulumi.getter(name="forwardTagsRestrictionListType")
    def forward_tags_restriction_list_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the `forward_tags_restriction_list` parameter should be interpreted.
        			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
        			are forwarded.
        			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        """
        return pulumi.get(self, "forward_tags_restriction_list_type")

    @forward_tags_restriction_list_type.setter
    def forward_tags_restriction_list_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_tags_restriction_list_type", value)

    @_builtins.property
    @pulumi.getter(name="forwardTagsRestrictionLists")
    def forward_tags_restriction_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
        			An empty list represents no restriction is in place and either all or no tags will be
        			forwarded depending on `forward_tags_restriction_list_type` parameter.
        """
        return pulumi.get(self, "forward_tags_restriction_lists")

    @forward_tags_restriction_lists.setter
    def forward_tags_restriction_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "forward_tags_restriction_lists", value)

    @_builtins.property
    @pulumi.getter(name="httpDestination")
    def http_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationHttpDestinationArgs']]:
        """
        The HTTP destination.
        """
        return pulumi.get(self, "http_destination")

    @http_destination.setter
    def http_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationHttpDestinationArgs']]):
        pulumi.set(self, "http_destination", value)

    @_builtins.property
    @pulumi.getter(name="microsoftSentinelDestination")
    def microsoft_sentinel_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs']]:
        """
        The Microsoft Sentinel destination.
        """
        return pulumi.get(self, "microsoft_sentinel_destination")

    @microsoft_sentinel_destination.setter
    def microsoft_sentinel_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs']]):
        pulumi.set(self, "microsoft_sentinel_destination", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom destination query filter. Logs matching this query are forwarded to the destination.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="splunkDestination")
    def splunk_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationSplunkDestinationArgs']]:
        """
        The Splunk HTTP Event Collector (HEC) destination.
        """
        return pulumi.get(self, "splunk_destination")

    @splunk_destination.setter
    def splunk_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationSplunkDestinationArgs']]):
        pulumi.set(self, "splunk_destination", value)


@pulumi.input_type
class _LogsCustomDestinationState:
    def __init__(__self__, *,
                 elasticsearch_destination: Optional[pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags_restriction_list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_tags_restriction_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_destination: Optional[pulumi.Input['LogsCustomDestinationHttpDestinationArgs']] = None,
                 microsoft_sentinel_destination: Optional[pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 splunk_destination: Optional[pulumi.Input['LogsCustomDestinationSplunkDestinationArgs']] = None):
        """
        Input properties used for looking up and filtering LogsCustomDestination resources.
        :param pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs'] elasticsearch_destination: The Elasticsearch destination.
        :param pulumi.Input[_builtins.bool] enabled: Whether logs matching this custom destination should be forwarded or not.
        :param pulumi.Input[_builtins.bool] forward_tags: Whether tags from the forwarded logs should be forwarded or not.
        :param pulumi.Input[_builtins.str] forward_tags_restriction_list_type: How the `forward_tags_restriction_list` parameter should be interpreted.
               			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
               			are forwarded.
               			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forward_tags_restriction_lists: List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
               			An empty list represents no restriction is in place and either all or no tags will be
               			forwarded depending on `forward_tags_restriction_list_type` parameter.
        :param pulumi.Input['LogsCustomDestinationHttpDestinationArgs'] http_destination: The HTTP destination.
        :param pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs'] microsoft_sentinel_destination: The Microsoft Sentinel destination.
        :param pulumi.Input[_builtins.str] name: The custom destination name.
        :param pulumi.Input[_builtins.str] query: The custom destination query filter. Logs matching this query are forwarded to the destination.
        :param pulumi.Input['LogsCustomDestinationSplunkDestinationArgs'] splunk_destination: The Splunk HTTP Event Collector (HEC) destination.
        """
        if elasticsearch_destination is not None:
            pulumi.set(__self__, "elasticsearch_destination", elasticsearch_destination)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forward_tags is not None:
            pulumi.set(__self__, "forward_tags", forward_tags)
        if forward_tags_restriction_list_type is not None:
            pulumi.set(__self__, "forward_tags_restriction_list_type", forward_tags_restriction_list_type)
        if forward_tags_restriction_lists is not None:
            pulumi.set(__self__, "forward_tags_restriction_lists", forward_tags_restriction_lists)
        if http_destination is not None:
            pulumi.set(__self__, "http_destination", http_destination)
        if microsoft_sentinel_destination is not None:
            pulumi.set(__self__, "microsoft_sentinel_destination", microsoft_sentinel_destination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if splunk_destination is not None:
            pulumi.set(__self__, "splunk_destination", splunk_destination)

    @_builtins.property
    @pulumi.getter(name="elasticsearchDestination")
    def elasticsearch_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs']]:
        """
        The Elasticsearch destination.
        """
        return pulumi.get(self, "elasticsearch_destination")

    @elasticsearch_destination.setter
    def elasticsearch_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationElasticsearchDestinationArgs']]):
        pulumi.set(self, "elasticsearch_destination", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether logs matching this custom destination should be forwarded or not.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="forwardTags")
    def forward_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether tags from the forwarded logs should be forwarded or not.
        """
        return pulumi.get(self, "forward_tags")

    @forward_tags.setter
    def forward_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "forward_tags", value)

    @_builtins.property
    @pulumi.getter(name="forwardTagsRestrictionListType")
    def forward_tags_restriction_list_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the `forward_tags_restriction_list` parameter should be interpreted.
        			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
        			are forwarded.
        			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        """
        return pulumi.get(self, "forward_tags_restriction_list_type")

    @forward_tags_restriction_list_type.setter
    def forward_tags_restriction_list_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_tags_restriction_list_type", value)

    @_builtins.property
    @pulumi.getter(name="forwardTagsRestrictionLists")
    def forward_tags_restriction_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
        			An empty list represents no restriction is in place and either all or no tags will be
        			forwarded depending on `forward_tags_restriction_list_type` parameter.
        """
        return pulumi.get(self, "forward_tags_restriction_lists")

    @forward_tags_restriction_lists.setter
    def forward_tags_restriction_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "forward_tags_restriction_lists", value)

    @_builtins.property
    @pulumi.getter(name="httpDestination")
    def http_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationHttpDestinationArgs']]:
        """
        The HTTP destination.
        """
        return pulumi.get(self, "http_destination")

    @http_destination.setter
    def http_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationHttpDestinationArgs']]):
        pulumi.set(self, "http_destination", value)

    @_builtins.property
    @pulumi.getter(name="microsoftSentinelDestination")
    def microsoft_sentinel_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs']]:
        """
        The Microsoft Sentinel destination.
        """
        return pulumi.get(self, "microsoft_sentinel_destination")

    @microsoft_sentinel_destination.setter
    def microsoft_sentinel_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationMicrosoftSentinelDestinationArgs']]):
        pulumi.set(self, "microsoft_sentinel_destination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom destination name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom destination query filter. Logs matching this query are forwarded to the destination.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="splunkDestination")
    def splunk_destination(self) -> Optional[pulumi.Input['LogsCustomDestinationSplunkDestinationArgs']]:
        """
        The Splunk HTTP Event Collector (HEC) destination.
        """
        return pulumi.get(self, "splunk_destination")

    @splunk_destination.setter
    def splunk_destination(self, value: Optional[pulumi.Input['LogsCustomDestinationSplunkDestinationArgs']]):
        pulumi.set(self, "splunk_destination", value)


@pulumi.type_token("datadog:index/logsCustomDestination:LogsCustomDestination")
class LogsCustomDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_destination: Optional[pulumi.Input[Union['LogsCustomDestinationElasticsearchDestinationArgs', 'LogsCustomDestinationElasticsearchDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags_restriction_list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_tags_restriction_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_destination: Optional[pulumi.Input[Union['LogsCustomDestinationHttpDestinationArgs', 'LogsCustomDestinationHttpDestinationArgsDict']]] = None,
                 microsoft_sentinel_destination: Optional[pulumi.Input[Union['LogsCustomDestinationMicrosoftSentinelDestinationArgs', 'LogsCustomDestinationMicrosoftSentinelDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 splunk_destination: Optional[pulumi.Input[Union['LogsCustomDestinationSplunkDestinationArgs', 'LogsCustomDestinationSplunkDestinationArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Datadog Logs Custom Destination API resource, which is used to create and manage Datadog log forwarding.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_destination = datadog.LogsCustomDestination("sample_destination",
            name="sample destination",
            query="service:my-service",
            enabled=True,
            http_destination={
                "endpoint": "https://example.org",
                "basic_auth": {
                    "username": "my-username",
                    "password": "my-password",
                },
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Custom destinations can be imported using the destination ID. Caution: auth credentials can not be imported.

        ```sh
        $ pulumi import datadog:index/logsCustomDestination:LogsCustomDestination sample_destination "destination-id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LogsCustomDestinationElasticsearchDestinationArgs', 'LogsCustomDestinationElasticsearchDestinationArgsDict']] elasticsearch_destination: The Elasticsearch destination.
        :param pulumi.Input[_builtins.bool] enabled: Whether logs matching this custom destination should be forwarded or not.
        :param pulumi.Input[_builtins.bool] forward_tags: Whether tags from the forwarded logs should be forwarded or not.
        :param pulumi.Input[_builtins.str] forward_tags_restriction_list_type: How the `forward_tags_restriction_list` parameter should be interpreted.
               			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
               			are forwarded.
               			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forward_tags_restriction_lists: List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
               			An empty list represents no restriction is in place and either all or no tags will be
               			forwarded depending on `forward_tags_restriction_list_type` parameter.
        :param pulumi.Input[Union['LogsCustomDestinationHttpDestinationArgs', 'LogsCustomDestinationHttpDestinationArgsDict']] http_destination: The HTTP destination.
        :param pulumi.Input[Union['LogsCustomDestinationMicrosoftSentinelDestinationArgs', 'LogsCustomDestinationMicrosoftSentinelDestinationArgsDict']] microsoft_sentinel_destination: The Microsoft Sentinel destination.
        :param pulumi.Input[_builtins.str] name: The custom destination name.
        :param pulumi.Input[_builtins.str] query: The custom destination query filter. Logs matching this query are forwarded to the destination.
        :param pulumi.Input[Union['LogsCustomDestinationSplunkDestinationArgs', 'LogsCustomDestinationSplunkDestinationArgsDict']] splunk_destination: The Splunk HTTP Event Collector (HEC) destination.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsCustomDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Logs Custom Destination API resource, which is used to create and manage Datadog log forwarding.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        sample_destination = datadog.LogsCustomDestination("sample_destination",
            name="sample destination",
            query="service:my-service",
            enabled=True,
            http_destination={
                "endpoint": "https://example.org",
                "basic_auth": {
                    "username": "my-username",
                    "password": "my-password",
                },
            })
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Custom destinations can be imported using the destination ID. Caution: auth credentials can not be imported.

        ```sh
        $ pulumi import datadog:index/logsCustomDestination:LogsCustomDestination sample_destination "destination-id"
        ```

        :param str resource_name: The name of the resource.
        :param LogsCustomDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsCustomDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 elasticsearch_destination: Optional[pulumi.Input[Union['LogsCustomDestinationElasticsearchDestinationArgs', 'LogsCustomDestinationElasticsearchDestinationArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_tags_restriction_list_type: Optional[pulumi.Input[_builtins.str]] = None,
                 forward_tags_restriction_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 http_destination: Optional[pulumi.Input[Union['LogsCustomDestinationHttpDestinationArgs', 'LogsCustomDestinationHttpDestinationArgsDict']]] = None,
                 microsoft_sentinel_destination: Optional[pulumi.Input[Union['LogsCustomDestinationMicrosoftSentinelDestinationArgs', 'LogsCustomDestinationMicrosoftSentinelDestinationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 splunk_destination: Optional[pulumi.Input[Union['LogsCustomDestinationSplunkDestinationArgs', 'LogsCustomDestinationSplunkDestinationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsCustomDestinationArgs.__new__(LogsCustomDestinationArgs)

            __props__.__dict__["elasticsearch_destination"] = elasticsearch_destination
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["forward_tags"] = forward_tags
            __props__.__dict__["forward_tags_restriction_list_type"] = forward_tags_restriction_list_type
            __props__.__dict__["forward_tags_restriction_lists"] = forward_tags_restriction_lists
            __props__.__dict__["http_destination"] = http_destination
            __props__.__dict__["microsoft_sentinel_destination"] = microsoft_sentinel_destination
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["query"] = query
            __props__.__dict__["splunk_destination"] = splunk_destination
        super(LogsCustomDestination, __self__).__init__(
            'datadog:index/logsCustomDestination:LogsCustomDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            elasticsearch_destination: Optional[pulumi.Input[Union['LogsCustomDestinationElasticsearchDestinationArgs', 'LogsCustomDestinationElasticsearchDestinationArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_tags: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_tags_restriction_list_type: Optional[pulumi.Input[_builtins.str]] = None,
            forward_tags_restriction_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            http_destination: Optional[pulumi.Input[Union['LogsCustomDestinationHttpDestinationArgs', 'LogsCustomDestinationHttpDestinationArgsDict']]] = None,
            microsoft_sentinel_destination: Optional[pulumi.Input[Union['LogsCustomDestinationMicrosoftSentinelDestinationArgs', 'LogsCustomDestinationMicrosoftSentinelDestinationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            splunk_destination: Optional[pulumi.Input[Union['LogsCustomDestinationSplunkDestinationArgs', 'LogsCustomDestinationSplunkDestinationArgsDict']]] = None) -> 'LogsCustomDestination':
        """
        Get an existing LogsCustomDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['LogsCustomDestinationElasticsearchDestinationArgs', 'LogsCustomDestinationElasticsearchDestinationArgsDict']] elasticsearch_destination: The Elasticsearch destination.
        :param pulumi.Input[_builtins.bool] enabled: Whether logs matching this custom destination should be forwarded or not.
        :param pulumi.Input[_builtins.bool] forward_tags: Whether tags from the forwarded logs should be forwarded or not.
        :param pulumi.Input[_builtins.str] forward_tags_restriction_list_type: How the `forward_tags_restriction_list` parameter should be interpreted.
               			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
               			are forwarded.
               			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] forward_tags_restriction_lists: List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
               			An empty list represents no restriction is in place and either all or no tags will be
               			forwarded depending on `forward_tags_restriction_list_type` parameter.
        :param pulumi.Input[Union['LogsCustomDestinationHttpDestinationArgs', 'LogsCustomDestinationHttpDestinationArgsDict']] http_destination: The HTTP destination.
        :param pulumi.Input[Union['LogsCustomDestinationMicrosoftSentinelDestinationArgs', 'LogsCustomDestinationMicrosoftSentinelDestinationArgsDict']] microsoft_sentinel_destination: The Microsoft Sentinel destination.
        :param pulumi.Input[_builtins.str] name: The custom destination name.
        :param pulumi.Input[_builtins.str] query: The custom destination query filter. Logs matching this query are forwarded to the destination.
        :param pulumi.Input[Union['LogsCustomDestinationSplunkDestinationArgs', 'LogsCustomDestinationSplunkDestinationArgsDict']] splunk_destination: The Splunk HTTP Event Collector (HEC) destination.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsCustomDestinationState.__new__(_LogsCustomDestinationState)

        __props__.__dict__["elasticsearch_destination"] = elasticsearch_destination
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["forward_tags"] = forward_tags
        __props__.__dict__["forward_tags_restriction_list_type"] = forward_tags_restriction_list_type
        __props__.__dict__["forward_tags_restriction_lists"] = forward_tags_restriction_lists
        __props__.__dict__["http_destination"] = http_destination
        __props__.__dict__["microsoft_sentinel_destination"] = microsoft_sentinel_destination
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["splunk_destination"] = splunk_destination
        return LogsCustomDestination(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="elasticsearchDestination")
    def elasticsearch_destination(self) -> pulumi.Output[Optional['outputs.LogsCustomDestinationElasticsearchDestination']]:
        """
        The Elasticsearch destination.
        """
        return pulumi.get(self, "elasticsearch_destination")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether logs matching this custom destination should be forwarded or not.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="forwardTags")
    def forward_tags(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether tags from the forwarded logs should be forwarded or not.
        """
        return pulumi.get(self, "forward_tags")

    @_builtins.property
    @pulumi.getter(name="forwardTagsRestrictionListType")
    def forward_tags_restriction_list_type(self) -> pulumi.Output[_builtins.str]:
        """
        How the `forward_tags_restriction_list` parameter should be interpreted.
        			If `ALLOW_LIST`, then only tags whose keys on the forwarded logs match the ones on the restriction list
        			are forwarded.
        			`BLOCK_LIST` works the opposite way. It does not forward the tags matching the ones on the list. Valid values are `ALLOW_LIST`, `BLOCK_LIST`.
        """
        return pulumi.get(self, "forward_tags_restriction_list_type")

    @_builtins.property
    @pulumi.getter(name="forwardTagsRestrictionLists")
    def forward_tags_restriction_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of [tag keys](https://docs.datadoghq.com/getting_started/tagging/#define-tags) to be filtered.
        			An empty list represents no restriction is in place and either all or no tags will be
        			forwarded depending on `forward_tags_restriction_list_type` parameter.
        """
        return pulumi.get(self, "forward_tags_restriction_lists")

    @_builtins.property
    @pulumi.getter(name="httpDestination")
    def http_destination(self) -> pulumi.Output[Optional['outputs.LogsCustomDestinationHttpDestination']]:
        """
        The HTTP destination.
        """
        return pulumi.get(self, "http_destination")

    @_builtins.property
    @pulumi.getter(name="microsoftSentinelDestination")
    def microsoft_sentinel_destination(self) -> pulumi.Output[Optional['outputs.LogsCustomDestinationMicrosoftSentinelDestination']]:
        """
        The Microsoft Sentinel destination.
        """
        return pulumi.get(self, "microsoft_sentinel_destination")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The custom destination name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The custom destination query filter. Logs matching this query are forwarded to the destination.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="splunkDestination")
    def splunk_destination(self) -> pulumi.Output[Optional['outputs.LogsCustomDestinationSplunkDestination']]:
        """
        The Splunk HTTP Event Collector (HEC) destination.
        """
        return pulumi.get(self, "splunk_destination")

