# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OnCallEscalationPolicyArgs', 'OnCallEscalationPolicy']

@pulumi.input_type
class OnCallEscalationPolicyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 steps: pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]],
                 resolve_page_on_policy_end: Optional[pulumi.Input[_builtins.bool]] = None,
                 retries: Optional[pulumi.Input[_builtins.int]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a OnCallEscalationPolicy resource.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the escalation policy.
        :param pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]] steps: List of steps for the escalation policy.
        :param pulumi.Input[_builtins.bool] resolve_page_on_policy_end: If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        :param pulumi.Input[_builtins.int] retries: If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the escalation policy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "steps", steps)
        if resolve_page_on_policy_end is not None:
            pulumi.set(__self__, "resolve_page_on_policy_end", resolve_page_on_policy_end)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        A human-readable name for the escalation policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]]:
        """
        List of steps for the escalation policy.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]]):
        pulumi.set(self, "steps", value)

    @_builtins.property
    @pulumi.getter(name="resolvePageOnPolicyEnd")
    def resolve_page_on_policy_end(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        """
        return pulumi.get(self, "resolve_page_on_policy_end")

    @resolve_page_on_policy_end.setter
    def resolve_page_on_policy_end(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resolve_page_on_policy_end", value)

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retries", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of team ids associated with the escalation policy.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class _OnCallEscalationPolicyState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_page_on_policy_end: Optional[pulumi.Input[_builtins.bool]] = None,
                 retries: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OnCallEscalationPolicy resources.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the escalation policy.
        :param pulumi.Input[_builtins.bool] resolve_page_on_policy_end: If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        :param pulumi.Input[_builtins.int] retries: If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        :param pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]] steps: List of steps for the escalation policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the escalation policy.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resolve_page_on_policy_end is not None:
            pulumi.set(__self__, "resolve_page_on_policy_end", resolve_page_on_policy_end)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-readable name for the escalation policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resolvePageOnPolicyEnd")
    def resolve_page_on_policy_end(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        """
        return pulumi.get(self, "resolve_page_on_policy_end")

    @resolve_page_on_policy_end.setter
    def resolve_page_on_policy_end(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resolve_page_on_policy_end", value)

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retries", value)

    @_builtins.property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]]]:
        """
        List of steps for the escalation policy.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OnCallEscalationPolicyStepArgs']]]]):
        pulumi.set(self, "steps", value)

    @_builtins.property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of team ids associated with the escalation policy.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "teams", value)


@pulumi.type_token("datadog:index/onCallEscalationPolicy:OnCallEscalationPolicy")
class OnCallEscalationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_page_on_policy_end: Optional[pulumi.Input[_builtins.bool]] = None,
                 retries: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallEscalationPolicyStepArgs', 'OnCallEscalationPolicyStepArgsDict']]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Datadog On-Call escalation policy resource. This can be used to create and manage Datadog On-Call escalation policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        policy_test = datadog.OnCallEscalationPolicy("policy_test",
            name="Policy Name",
            resolve_page_on_policy_end=True,
            retries=3,
            steps=[{
                "assignment": "round-robin",
                "escalate_after_seconds": 300,
                "targets": [
                    {
                        "team": "00000000-aba2-0000-0000-000000000000",
                    },
                    {
                        "user": "00000000-aba2-0000-0000-000000000000",
                    },
                    {
                        "schedule": "00000000-aba2-0000-0000-000000000000",
                    },
                ],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import an existing on_call_escalation_policy

        ```sh
        $ pulumi import datadog:index/onCallEscalationPolicy:OnCallEscalationPolicy test "b03a07d5-49da-43e9-83b4-5d84969b588b"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the escalation policy.
        :param pulumi.Input[_builtins.bool] resolve_page_on_policy_end: If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        :param pulumi.Input[_builtins.int] retries: If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnCallEscalationPolicyStepArgs', 'OnCallEscalationPolicyStepArgsDict']]]] steps: List of steps for the escalation policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the escalation policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OnCallEscalationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog On-Call escalation policy resource. This can be used to create and manage Datadog On-Call escalation policies.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        policy_test = datadog.OnCallEscalationPolicy("policy_test",
            name="Policy Name",
            resolve_page_on_policy_end=True,
            retries=3,
            steps=[{
                "assignment": "round-robin",
                "escalate_after_seconds": 300,
                "targets": [
                    {
                        "team": "00000000-aba2-0000-0000-000000000000",
                    },
                    {
                        "user": "00000000-aba2-0000-0000-000000000000",
                    },
                    {
                        "schedule": "00000000-aba2-0000-0000-000000000000",
                    },
                ],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import an existing on_call_escalation_policy

        ```sh
        $ pulumi import datadog:index/onCallEscalationPolicy:OnCallEscalationPolicy test "b03a07d5-49da-43e9-83b4-5d84969b588b"
        ```

        :param str resource_name: The name of the resource.
        :param OnCallEscalationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OnCallEscalationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resolve_page_on_policy_end: Optional[pulumi.Input[_builtins.bool]] = None,
                 retries: Optional[pulumi.Input[_builtins.int]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallEscalationPolicyStepArgs', 'OnCallEscalationPolicyStepArgsDict']]]]] = None,
                 teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OnCallEscalationPolicyArgs.__new__(OnCallEscalationPolicyArgs)

            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["resolve_page_on_policy_end"] = resolve_page_on_policy_end
            __props__.__dict__["retries"] = retries
            if steps is None and not opts.urn:
                raise TypeError("Missing required property 'steps'")
            __props__.__dict__["steps"] = steps
            __props__.__dict__["teams"] = teams
        super(OnCallEscalationPolicy, __self__).__init__(
            'datadog:index/onCallEscalationPolicy:OnCallEscalationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resolve_page_on_policy_end: Optional[pulumi.Input[_builtins.bool]] = None,
            retries: Optional[pulumi.Input[_builtins.int]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OnCallEscalationPolicyStepArgs', 'OnCallEscalationPolicyStepArgsDict']]]]] = None,
            teams: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'OnCallEscalationPolicy':
        """
        Get an existing OnCallEscalationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: A human-readable name for the escalation policy.
        :param pulumi.Input[_builtins.bool] resolve_page_on_policy_end: If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        :param pulumi.Input[_builtins.int] retries: If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OnCallEscalationPolicyStepArgs', 'OnCallEscalationPolicyStepArgsDict']]]] steps: List of steps for the escalation policy.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] teams: A list of team ids associated with the escalation policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OnCallEscalationPolicyState.__new__(_OnCallEscalationPolicyState)

        __props__.__dict__["name"] = name
        __props__.__dict__["resolve_page_on_policy_end"] = resolve_page_on_policy_end
        __props__.__dict__["retries"] = retries
        __props__.__dict__["steps"] = steps
        __props__.__dict__["teams"] = teams
        return OnCallEscalationPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A human-readable name for the escalation policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resolvePageOnPolicyEnd")
    def resolve_page_on_policy_end(self) -> pulumi.Output[_builtins.bool]:
        """
        If true, pages will be automatically resolved if unacknowledged after the final step. Defaults to `false`.
        """
        return pulumi.get(self, "resolve_page_on_policy_end")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> pulumi.Output[_builtins.int]:
        """
        If set, policy will be retried this many times after the final step. Must be in the range 0-10. Value must be between 0 and 10. Defaults to `0`.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.OnCallEscalationPolicyStep']]:
        """
        List of steps for the escalation policy.
        """
        return pulumi.get(self, "steps")

    @_builtins.property
    @pulumi.getter
    def teams(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of team ids associated with the escalation policy.
        """
        return pulumi.get(self, "teams")

