# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityMonitoringDefaultRuleArgs', 'SecurityMonitoringDefaultRule']

@pulumi.input_type
class SecurityMonitoringDefaultRuleArgs:
    def __init__(__self__, *,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]] = None,
                 custom_message: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]] = None,
                 options: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityMonitoringDefaultRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[_builtins.str] custom_message: Custom Message (will override default message) for generated signals.
        :param pulumi.Input[_builtins.str] custom_name: The name (will override default name) of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[_builtins.bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs'] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]] queries: Queries for selecting logs which are part of the rule.
        """
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if custom_message is not None:
            pulumi.set(__self__, "custom_message", custom_message)
        if custom_name is not None:
            pulumi.set(__self__, "custom_name", custom_name)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)

    @_builtins.property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]:
        """
        Cases of the rule, this is used to update notifications.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @_builtins.property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom Message (will override default message) for generated signals.
        """
        return pulumi.get(self, "custom_message")

    @custom_message.setter
    def custom_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_message", value)

    @_builtins.property
    @pulumi.getter(name="customName")
    def custom_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name (will override default name) of the rule.
        """
        return pulumi.get(self, "custom_name")

    @custom_name.setter
    def custom_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_name", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Custom tags for generated signals.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]:
        """
        Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class _SecurityMonitoringDefaultRuleState:
    def __init__(__self__, *,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]] = None,
                 custom_message: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]] = None,
                 options: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityMonitoringDefaultRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[_builtins.str] custom_message: Custom Message (will override default message) for generated signals.
        :param pulumi.Input[_builtins.str] custom_name: The name (will override default name) of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[_builtins.bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs'] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]] queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[_builtins.str] type: The rule type.
        """
        if cases is not None:
            pulumi.set(__self__, "cases", cases)
        if custom_message is not None:
            pulumi.set(__self__, "custom_message", custom_message)
        if custom_name is not None:
            pulumi.set(__self__, "custom_name", custom_name)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queries is not None:
            pulumi.set(__self__, "queries", queries)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def cases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]:
        """
        Cases of the rule, this is used to update notifications.
        """
        return pulumi.get(self, "cases")

    @cases.setter
    def cases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleCaseArgs']]]]):
        pulumi.set(self, "cases", value)

    @_builtins.property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom Message (will override default message) for generated signals.
        """
        return pulumi.get(self, "custom_message")

    @custom_message.setter
    def custom_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_message", value)

    @_builtins.property
    @pulumi.getter(name="customName")
    def custom_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name (will override default name) of the rule.
        """
        return pulumi.get(self, "custom_name")

    @custom_name.setter
    def custom_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_name", value)

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Custom tags for generated signals.
        """
        return pulumi.get(self, "custom_tags")

    @custom_tags.setter
    def custom_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_tags", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]:
        """
        Additional queries to filter matched events before they are processed.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]:
        """
        Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['SecurityMonitoringDefaultRuleOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringDefaultRuleQueryArgs']]]]):
        pulumi.set(self, "queries", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule")
class SecurityMonitoringDefaultRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleCaseArgs', 'SecurityMonitoringDefaultRuleCaseArgsDict']]]]] = None,
                 custom_message: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleFilterArgs', 'SecurityMonitoringDefaultRuleFilterArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[Union['SecurityMonitoringDefaultRuleOptionsArgs', 'SecurityMonitoringDefaultRuleOptionsArgsDict']]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleQueryArgs', 'SecurityMonitoringDefaultRuleQueryArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Datadog Security Monitoring Rule API resource for default rules. It can only be imported, you can't create a default rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        adefaultrule = datadog.SecurityMonitoringDefaultRule("adefaultrule",
            enabled=True,
            cases=[{
                "status": "high",
                "notifications": ["@me"],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Default rules need to be imported using their ID before applying.

        resource "datadog_security_monitoring_default_rule" "adefaultrule" {

        }

        ```sh
        $ pulumi import datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule adefaultrule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleCaseArgs', 'SecurityMonitoringDefaultRuleCaseArgsDict']]]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[_builtins.str] custom_message: Custom Message (will override default message) for generated signals.
        :param pulumi.Input[_builtins.str] custom_name: The name (will override default name) of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[_builtins.bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleFilterArgs', 'SecurityMonitoringDefaultRuleFilterArgsDict']]]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input[Union['SecurityMonitoringDefaultRuleOptionsArgs', 'SecurityMonitoringDefaultRuleOptionsArgsDict']] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleQueryArgs', 'SecurityMonitoringDefaultRuleQueryArgsDict']]]] queries: Queries for selecting logs which are part of the rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SecurityMonitoringDefaultRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Security Monitoring Rule API resource for default rules. It can only be imported, you can't create a default rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        adefaultrule = datadog.SecurityMonitoringDefaultRule("adefaultrule",
            enabled=True,
            cases=[{
                "status": "high",
                "notifications": ["@me"],
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Default rules need to be imported using their ID before applying.

        resource "datadog_security_monitoring_default_rule" "adefaultrule" {

        }

        ```sh
        $ pulumi import datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule adefaultrule m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param SecurityMonitoringDefaultRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityMonitoringDefaultRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleCaseArgs', 'SecurityMonitoringDefaultRuleCaseArgsDict']]]]] = None,
                 custom_message: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleFilterArgs', 'SecurityMonitoringDefaultRuleFilterArgsDict']]]]] = None,
                 options: Optional[pulumi.Input[Union['SecurityMonitoringDefaultRuleOptionsArgs', 'SecurityMonitoringDefaultRuleOptionsArgsDict']]] = None,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleQueryArgs', 'SecurityMonitoringDefaultRuleQueryArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityMonitoringDefaultRuleArgs.__new__(SecurityMonitoringDefaultRuleArgs)

            __props__.__dict__["cases"] = cases
            __props__.__dict__["custom_message"] = custom_message
            __props__.__dict__["custom_name"] = custom_name
            __props__.__dict__["custom_tags"] = custom_tags
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["filters"] = filters
            __props__.__dict__["options"] = options
            __props__.__dict__["queries"] = queries
            __props__.__dict__["type"] = None
        super(SecurityMonitoringDefaultRule, __self__).__init__(
            'datadog:index/securityMonitoringDefaultRule:SecurityMonitoringDefaultRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleCaseArgs', 'SecurityMonitoringDefaultRuleCaseArgsDict']]]]] = None,
            custom_message: Optional[pulumi.Input[_builtins.str]] = None,
            custom_name: Optional[pulumi.Input[_builtins.str]] = None,
            custom_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleFilterArgs', 'SecurityMonitoringDefaultRuleFilterArgsDict']]]]] = None,
            options: Optional[pulumi.Input[Union['SecurityMonitoringDefaultRuleOptionsArgs', 'SecurityMonitoringDefaultRuleOptionsArgsDict']]] = None,
            queries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleQueryArgs', 'SecurityMonitoringDefaultRuleQueryArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityMonitoringDefaultRule':
        """
        Get an existing SecurityMonitoringDefaultRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleCaseArgs', 'SecurityMonitoringDefaultRuleCaseArgsDict']]]] cases: Cases of the rule, this is used to update notifications.
        :param pulumi.Input[_builtins.str] custom_message: Custom Message (will override default message) for generated signals.
        :param pulumi.Input[_builtins.str] custom_name: The name (will override default name) of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_tags: Custom tags for generated signals.
        :param pulumi.Input[_builtins.bool] enabled: Enable the rule. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleFilterArgs', 'SecurityMonitoringDefaultRuleFilterArgsDict']]]] filters: Additional queries to filter matched events before they are processed.
        :param pulumi.Input[Union['SecurityMonitoringDefaultRuleOptionsArgs', 'SecurityMonitoringDefaultRuleOptionsArgsDict']] options: Options on default rules. Note that only a subset of fields can be updated on default rule options.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringDefaultRuleQueryArgs', 'SecurityMonitoringDefaultRuleQueryArgsDict']]]] queries: Queries for selecting logs which are part of the rule.
        :param pulumi.Input[_builtins.str] type: The rule type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityMonitoringDefaultRuleState.__new__(_SecurityMonitoringDefaultRuleState)

        __props__.__dict__["cases"] = cases
        __props__.__dict__["custom_message"] = custom_message
        __props__.__dict__["custom_name"] = custom_name
        __props__.__dict__["custom_tags"] = custom_tags
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["filters"] = filters
        __props__.__dict__["options"] = options
        __props__.__dict__["queries"] = queries
        __props__.__dict__["type"] = type
        return SecurityMonitoringDefaultRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def cases(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringDefaultRuleCase']]]:
        """
        Cases of the rule, this is used to update notifications.
        """
        return pulumi.get(self, "cases")

    @_builtins.property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom Message (will override default message) for generated signals.
        """
        return pulumi.get(self, "custom_message")

    @_builtins.property
    @pulumi.getter(name="customName")
    def custom_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name (will override default name) of the rule.
        """
        return pulumi.get(self, "custom_name")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Custom tags for generated signals.
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable the rule. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringDefaultRuleFilter']]]:
        """
        Additional queries to filter matched events before they are processed.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.SecurityMonitoringDefaultRuleOptions']]:
        """
        Options on default rules. Note that only a subset of fields can be updated on default rule options.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def queries(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringDefaultRuleQuery']]]:
        """
        Queries for selecting logs which are part of the rule.
        """
        return pulumi.get(self, "queries")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The rule type.
        """
        return pulumi.get(self, "type")

