# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityMonitoringFilterArgs', 'SecurityMonitoringFilter']

@pulumi.input_type
class SecurityMonitoringFilterArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[_builtins.bool],
                 name: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]]] = None,
                 filtered_data_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityMonitoringFilter resource.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the security filter is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the security filter.
        :param pulumi.Input[_builtins.str] query: The query of the security filter.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]] exclusion_filters: Exclusion filters to exclude some logs from the security filter.
        :param pulumi.Input[_builtins.str] filtered_data_type: The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        if exclusion_filters is not None:
            pulumi.set(__self__, "exclusion_filters", exclusion_filters)
        if filtered_data_type is not None:
            pulumi.set(__self__, "filtered_data_type", filtered_data_type)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the security filter is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the security filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        The query of the security filter.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]]]:
        """
        Exclusion filters to exclude some logs from the security filter.
        """
        return pulumi.get(self, "exclusion_filters")

    @exclusion_filters.setter
    def exclusion_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]]]):
        pulumi.set(self, "exclusion_filters", value)

    @_builtins.property
    @pulumi.getter(name="filteredDataType")
    def filtered_data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        """
        return pulumi.get(self, "filtered_data_type")

    @filtered_data_type.setter
    def filtered_data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filtered_data_type", value)


@pulumi.input_type
class _SecurityMonitoringFilterState:
    def __init__(__self__, *,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]]] = None,
                 filtered_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SecurityMonitoringFilter resources.
        :param pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]] exclusion_filters: Exclusion filters to exclude some logs from the security filter.
        :param pulumi.Input[_builtins.str] filtered_data_type: The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the security filter is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the security filter.
        :param pulumi.Input[_builtins.str] query: The query of the security filter.
        :param pulumi.Input[_builtins.int] version: The version of the security filter.
        """
        if exclusion_filters is not None:
            pulumi.set(__self__, "exclusion_filters", exclusion_filters)
        if filtered_data_type is not None:
            pulumi.set(__self__, "filtered_data_type", filtered_data_type)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]]]:
        """
        Exclusion filters to exclude some logs from the security filter.
        """
        return pulumi.get(self, "exclusion_filters")

    @exclusion_filters.setter
    def exclusion_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityMonitoringFilterExclusionFilterArgs']]]]):
        pulumi.set(self, "exclusion_filters", value)

    @_builtins.property
    @pulumi.getter(name="filteredDataType")
    def filtered_data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        """
        return pulumi.get(self, "filtered_data_type")

    @filtered_data_type.setter
    def filtered_data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filtered_data_type", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the security filter is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the security filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The query of the security filter.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the security filter.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("datadog:index/securityMonitoringFilter:SecurityMonitoringFilter")
class SecurityMonitoringFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringFilterExclusionFilterArgs', 'SecurityMonitoringFilterExclusionFilterArgsDict']]]]] = None,
                 filtered_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Datadog Security Monitoring Rule API resource for security filters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_filter = datadog.SecurityMonitoringFilter("my_filter",
            name="My filter",
            query="The filter is filtering.",
            is_enabled=True,
            exclusion_filters=[
                {
                    "name": "first",
                    "query": "exclude some logs",
                },
                {
                    "name": "second",
                    "query": "exclude some other logs",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Security monitoring filters can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/securityMonitoringFilter:SecurityMonitoringFilter my_filter m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringFilterExclusionFilterArgs', 'SecurityMonitoringFilterExclusionFilterArgsDict']]]] exclusion_filters: Exclusion filters to exclude some logs from the security filter.
        :param pulumi.Input[_builtins.str] filtered_data_type: The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the security filter is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the security filter.
        :param pulumi.Input[_builtins.str] query: The query of the security filter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityMonitoringFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Security Monitoring Rule API resource for security filters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        my_filter = datadog.SecurityMonitoringFilter("my_filter",
            name="My filter",
            query="The filter is filtering.",
            is_enabled=True,
            exclusion_filters=[
                {
                    "name": "first",
                    "query": "exclude some logs",
                },
                {
                    "name": "second",
                    "query": "exclude some other logs",
                },
            ])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Security monitoring filters can be imported using ID, e.g.

        ```sh
        $ pulumi import datadog:index/securityMonitoringFilter:SecurityMonitoringFilter my_filter m0o-hto-lkb
        ```

        :param str resource_name: The name of the resource.
        :param SecurityMonitoringFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityMonitoringFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringFilterExclusionFilterArgs', 'SecurityMonitoringFilterExclusionFilterArgsDict']]]]] = None,
                 filtered_data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityMonitoringFilterArgs.__new__(SecurityMonitoringFilterArgs)

            __props__.__dict__["exclusion_filters"] = exclusion_filters
            __props__.__dict__["filtered_data_type"] = filtered_data_type
            if is_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'is_enabled'")
            __props__.__dict__["is_enabled"] = is_enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["version"] = None
        super(SecurityMonitoringFilter, __self__).__init__(
            'datadog:index/securityMonitoringFilter:SecurityMonitoringFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            exclusion_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringFilterExclusionFilterArgs', 'SecurityMonitoringFilterExclusionFilterArgsDict']]]]] = None,
            filtered_data_type: Optional[pulumi.Input[_builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'SecurityMonitoringFilter':
        """
        Get an existing SecurityMonitoringFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityMonitoringFilterExclusionFilterArgs', 'SecurityMonitoringFilterExclusionFilterArgsDict']]]] exclusion_filters: Exclusion filters to exclude some logs from the security filter.
        :param pulumi.Input[_builtins.str] filtered_data_type: The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        :param pulumi.Input[_builtins.bool] is_enabled: Whether the security filter is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the security filter.
        :param pulumi.Input[_builtins.str] query: The query of the security filter.
        :param pulumi.Input[_builtins.int] version: The version of the security filter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityMonitoringFilterState.__new__(_SecurityMonitoringFilterState)

        __props__.__dict__["exclusion_filters"] = exclusion_filters
        __props__.__dict__["filtered_data_type"] = filtered_data_type
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["version"] = version
        return SecurityMonitoringFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="exclusionFilters")
    def exclusion_filters(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityMonitoringFilterExclusionFilter']]]:
        """
        Exclusion filters to exclude some logs from the security filter.
        """
        return pulumi.get(self, "exclusion_filters")

    @_builtins.property
    @pulumi.getter(name="filteredDataType")
    def filtered_data_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The filtered data type. Valid values are `logs`. Defaults to `"logs"`.
        """
        return pulumi.get(self, "filtered_data_type")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the security filter is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the security filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The query of the security filter.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the security filter.
        """
        return pulumi.get(self, "version")

